/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.AbstractApplication;
import de.sciss.app.DocumentHandler;
import de.sciss.app.GraphicsHandler;
import de.sciss.app.WindowHandler;
import de.sciss.common.BasicGraphicsHandler;
import de.sciss.common.BasicMenuFactory;
import de.sciss.common.BasicWindowHandler;
import de.sciss.gui.MenuAction;
import de.sciss.gui.MenuRoot;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;

public abstract class BasicApplication
extends AbstractApplication {
    private final ActionQuit actionQuit = new ActionQuit(this.getResourceString("menuQuit"), KeyStroke.getKeyStroke(81, BasicMenuFactory.MENU_SHORTCUT));
    private BasicWindowHandler wh;
    private DocumentHandler dh;
    private GraphicsHandler gh;
    private BasicMenuFactory mf;

    protected BasicApplication(Class clazz, String string) {
        super(clazz, string);
    }

    protected void init() {
        this.gh = new BasicGraphicsHandler();
        this.dh = this.createDocumentHandler();
        this.mf = this.createMenuFactory();
        this.wh = this.createWindowHandler();
        this.mf.init();
        this.wh.init();
    }

    @Override
    public GraphicsHandler getGraphicsHandler() {
        return this.gh;
    }

    protected abstract BasicMenuFactory createMenuFactory();

    protected abstract BasicWindowHandler createWindowHandler();

    protected abstract DocumentHandler createDocumentHandler();

    @Override
    public WindowHandler getWindowHandler() {
        return this.wh;
    }

    @Override
    public DocumentHandler getDocumentHandler() {
        return this.dh;
    }

    public MenuRoot getMenuBarRoot() {
        return this.mf;
    }

    public BasicMenuFactory getMenuFactory() {
        return this.mf;
    }

    public Action getQuitAction() {
        return this.actionQuit;
    }

    private class ActionQuit
    extends MenuAction {
        protected ActionQuit(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicApplication.this.quit();
        }
    }
}

