/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.AbstractApplication;
import de.sciss.app.AbstractWindow;
import de.sciss.app.WindowHandler;
import de.sciss.common.AppWindow;
import de.sciss.common.BasicApplication;
import de.sciss.common.SmartJFrame;
import de.sciss.gui.AbstractWindowHandler;
import de.sciss.gui.FloatingPaletteHandler;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.MenuRoot;
import de.sciss.gui.WindowListenerWrapper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class BasicWindowHandler
extends AbstractWindowHandler {
    public static final String KEY_INTERNALFRAMES = "internalframes";
    public static final String KEY_FLOATINGPALETTES = "floatingpalettes";
    public static final String KEY_LAFDECORATION = "lafdecoration";
    public static final String KEY_SCREENSPACE = "screenspace";
    private final FloatingPaletteHandler fph;
    private final boolean internalFrames;
    private final boolean floating;
    protected final JDesktopPane desktop;
    private final MasterFrame masterFrame;
    private final List collBorrowListeners = new ArrayList();
    private AbstractWindow borrower = null;
    private AbstractWindow defaultBorrower = null;
    private final Action actionCollect;
    private boolean autoCollect = false;
    private final BasicApplication root;

    public BasicWindowHandler(BasicApplication basicApplication) {
        this(basicApplication, basicApplication.getUserPrefs().getBoolean(KEY_LAFDECORATION, false), basicApplication.getUserPrefs().getBoolean(KEY_INTERNALFRAMES, false), basicApplication.getUserPrefs().getBoolean(KEY_FLOATINGPALETTES, false));
        Preferences preferences = basicApplication.getUserPrefs();
        Rectangle rectangle = BasicWindowHandler.stringToRectangle(preferences.get(KEY_SCREENSPACE, null));
        Rectangle rectangle2 = this.calcOuterBounds();
        this.autoCollect = !rectangle2.equals(rectangle);
        preferences.put(KEY_SCREENSPACE, BasicWindowHandler.rectangleToString(rectangle2));
    }

    public BasicWindowHandler(BasicApplication basicApplication, boolean bl, boolean bl2, boolean bl3) {
        JFrame.setDefaultLookAndFeelDecorated(bl);
        this.root = basicApplication;
        this.internalFrames = bl2;
        this.floating = bl3;
        this.fph = FloatingPaletteHandler.getInstance();
        if (bl2) {
            this.masterFrame = new MasterFrame(this.usesScreenMenuBar());
            this.masterFrame.setTitle(basicApplication.getName());
            this.desktop = new JDesktopPane();
            this.masterFrame.getContentPane().add(this.desktop);
        } else {
            this.desktop = null;
            this.masterFrame = null;
            this.fph.setListening(true);
        }
        this.actionCollect = new ActionCollect(basicApplication.getResourceString("menuCollectWindows"));
    }

    public MenuRoot getMenuBarRoot() {
        return this.root.getMenuBarRoot();
    }

    public Action getCollectAction() {
        return this.actionCollect;
    }

    public static Component getWindowAncestor(Component component) {
        WindowHandler windowHandler = AbstractApplication.getApplication().getWindowHandler();
        return SwingUtilities.getAncestorOfClass(windowHandler instanceof BasicWindowHandler && ((BasicWindowHandler)windowHandler).internalFrames ? JInternalFrame.class : Window.class, component);
    }

    public void init() {
        if (this.masterFrame != null) {
            this.masterFrame.setDefaultMenuBar(this.root.getMenuBarRoot().createBar(this.masterFrame));
            this.masterFrame.setVisible(true);
        }
    }

    public void setMenuBarBorrower(AbstractWindow abstractWindow) {
        this.borrower = abstractWindow;
        Iterator iterator = this.collBorrowListeners.iterator();
        while (iterator.hasNext()) {
            ((AppWindow)iterator.next()).borrowMenuBar(this.borrower == null ? this.defaultBorrower : this.borrower);
        }
    }

    public void setDefaultBorrower(AbstractWindow abstractWindow) {
        if (!this.internalFrames) {
            this.defaultBorrower = abstractWindow;
        }
    }

    public void addBorrowListener(AppWindow appWindow) {
        this.collBorrowListeners.add(appWindow);
    }

    public void removeBorrowListener(AppWindow appWindow) {
        this.collBorrowListeners.remove(appWindow);
    }

    public AbstractWindow getMenuBarBorrower() {
        return this.borrower == null ? this.defaultBorrower : this.borrower;
    }

    @Override
    public void addWindow(AbstractWindow abstractWindow, Map map) {
        super.addWindow(abstractWindow, map);
        if (this.fph != null) {
            this.fph.add(abstractWindow);
        }
        if (this.autoCollect) {
            this.collect(abstractWindow, this.calcOuterBounds());
        }
    }

    @Override
    public void removeWindow(AbstractWindow abstractWindow, Map map) {
        super.removeWindow(abstractWindow, map);
        if (this.fph != null) {
            this.fph.remove(abstractWindow);
        }
    }

    @Override
    public AbstractWindow createWindow(int n) {
        return new AppWindow(n);
    }

    @Override
    public boolean usesInternalFrames() {
        return this.internalFrames;
    }

    public boolean usesFloating() {
        return this.floating;
    }

    @Override
    public boolean usesScreenMenuBar() {
        return false;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public AbstractWindow getMasterFrame() {
        return this.masterFrame;
    }

    public Rectangle getWindowSpace() {
        if (this.masterFrame != null) {
            return new Rectangle(0, 0, this.masterFrame.getWidth(), this.masterFrame.getHeight());
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public void place(AbstractWindow abstractWindow, float f, float f2) {
        Rectangle rectangle = this.getWindowSpace();
        Dimension dimension = abstractWindow.getSize();
        abstractWindow.setLocation(new Point((int)((float)rectangle.x + f * (float)(rectangle.width - dimension.width)), (int)((float)rectangle.y + f2 * (float)(rectangle.height - dimension.height))));
    }

    private static Rectangle stringToRectangle(String string) {
        Rectangle rectangle = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                rectangle = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return rectangle;
    }

    private static String rectangleToString(Rectangle rectangle) {
        return rectangle != null ? rectangle.x + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height : null;
    }

    protected Rectangle calcOuterBounds() {
        Rectangle rectangle;
        boolean bl;
        boolean bl2 = bl = System.getProperty("os.name").indexOf("Mac OS") >= 0;
        if (this.desktop == null) {
            rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            if (bl) {
                rectangle.y += 22;
                rectangle.width -= 80;
                rectangle.height -= 22;
            }
        } else {
            rectangle = new Rectangle(0, 0, this.desktop.getWidth(), this.desktop.getHeight());
        }
        return rectangle;
    }

    protected void collect(AbstractWindow abstractWindow, Rectangle rectangle) {
        boolean bl;
        Rectangle rectangle2 = abstractWindow.getBounds();
        boolean bl2 = rectangle2.x < rectangle.x;
        boolean bl3 = rectangle2.y < rectangle.y;
        boolean bl4 = rectangle2.x + rectangle2.width > rectangle.x + rectangle.width;
        boolean bl5 = bl = rectangle2.y + rectangle2.height > rectangle.y + rectangle.height;
        if (!(bl2 || bl3 || bl4 || bl)) {
            return;
        }
        if (bl2) {
            rectangle2.x = rectangle.x;
            boolean bl6 = bl4 = rectangle2.x + rectangle2.width > rectangle.x + rectangle.width;
        }
        if (bl3) {
            rectangle2.y = rectangle.y;
            boolean bl7 = bl = rectangle2.y + rectangle2.height > rectangle.y + rectangle.height;
        }
        if (bl4) {
            rectangle2.x = Math.max(rectangle.x, rectangle.x + rectangle.width - rectangle2.width);
            boolean bl8 = bl4 = rectangle2.x + rectangle2.width > rectangle.x + rectangle.width;
            if (bl4 && abstractWindow.isResizable()) {
                rectangle2.width = rectangle.width;
            }
        }
        if (bl) {
            rectangle2.y = Math.max(rectangle.y, rectangle.y + rectangle.height - rectangle2.height);
            boolean bl9 = bl = rectangle2.y + rectangle2.height > rectangle.y + rectangle.height;
            if (bl && abstractWindow.isResizable()) {
                rectangle2.height = rectangle.height;
            }
        }
        abstractWindow.setBounds(rectangle2);
    }

    public static void showDialog(Dialog dialog) {
        BasicWindowHandler basicWindowHandler = (BasicWindowHandler)AbstractApplication.getApplication().getWindowHandler();
        basicWindowHandler.instShowDialog(dialog);
    }

    public static int showDialog(JOptionPane jOptionPane, Component component, String string) {
        int n;
        JDialog jDialog = jOptionPane.createDialog(component, string);
        BasicWindowHandler.showDialog(jDialog);
        Object object = jOptionPane.getValue();
        if (object == null) {
            n = -1;
        } else {
            Object[] objectArray = jOptionPane.getOptions();
            if (objectArray == null) {
                n = object instanceof Integer ? (Integer)object : -1;
            } else {
                int n2;
                for (n2 = 0; n2 < objectArray.length && !objectArray[n2].equals(object); ++n2) {
                }
                n = n2 < objectArray.length ? n2 : -1;
            }
        }
        return n;
    }

    public static void showErrorDialog(Component component, Throwable throwable, String string) {
        StringBuffer stringBuffer = new StringBuffer(GUIUtil.getResourceString("errException"));
        String string2 = throwable == null ? "null" : throwable.getClass().getName() + " - " + throwable.getLocalizedMessage();
        int n = 0;
        Object[] objectArray = new String[]{GUIUtil.getResourceString("buttonOk"), GUIUtil.getResourceString("optionDlgStack")};
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        stringBuffer.append(":\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n > 0 && n + string3.length() > 40) {
                stringBuffer.append("\n");
                n = 0;
            }
            stringBuffer.append(string3);
            stringBuffer.append(' ');
            n += string3.length() + 1;
        }
        JOptionPane jOptionPane = new JOptionPane(stringBuffer.toString(), 0, 0, null, objectArray, objectArray[0]);
        if (BasicWindowHandler.showDialog(jOptionPane, component, string) == 1) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instShowDialog(Dialog dialog) {
        AbstractWindow abstractWindow;
        boolean bl;
        ArrayList<AbstractWindow> arrayList = new ArrayList<AbstractWindow>();
        boolean bl2 = bl = dialog.isModal() && this.fph != null;
        if (!this.internalFrames && this.floating) {
            Iterator iterator = this.getWindows();
            while (iterator.hasNext()) {
                abstractWindow = (AbstractWindow)iterator.next();
                if (!GUIUtil.isAlwaysOnTop(abstractWindow.getWindow())) continue;
                arrayList.add(abstractWindow);
                GUIUtil.setAlwaysOnTop(abstractWindow.getWindow(), false);
            }
        }
        try {
            AppWindow appWindow = new AppWindow(dialog);
            appWindow.init();
            if (bl) {
                this.fph.addModalDialog();
            }
            appWindow.setVisible(true);
            if (bl) {
                this.fph.removeModalDialog();
            }
            appWindow.dispose();
        }
        finally {
            for (int i = 0; i < arrayList.size(); ++i) {
                abstractWindow = (AbstractWindow)arrayList.get(i);
                GUIUtil.setAlwaysOnTop(abstractWindow.getWindow(), true);
            }
        }
    }

    private class ActionCollect
    extends AbstractAction {
        protected ActionCollect(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = BasicWindowHandler.this.calcOuterBounds();
            Iterator iterator = BasicWindowHandler.this.getWindows();
            while (iterator.hasNext()) {
                BasicWindowHandler.this.collect((AbstractWindow)iterator.next(), rectangle);
            }
        }
    }

    private static class MasterFrame
    extends SmartJFrame
    implements AbstractWindow {
        private JMenuBar bar = null;

        protected MasterFrame(boolean bl) {
            super(bl);
            this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }

        @Override
        public void init() {
        }

        protected void setDefaultMenuBar(JMenuBar jMenuBar) {
            this.bar = jMenuBar;
            this.setJMenuBar(null);
        }

        @Override
        public void setJMenuBar(JMenuBar jMenuBar) {
            super.setJMenuBar(jMenuBar == null ? this.bar : jMenuBar);
        }

        @Override
        public void revalidate() {
            this.getRootPane().revalidate();
        }

        @Override
        public void setDirty(boolean bl) {
        }

        @Override
        public ActionMap getActionMap() {
            return this.getRootPane().getActionMap();
        }

        @Override
        public InputMap getInputMap(int n) {
            return this.getRootPane().getInputMap(n);
        }

        @Override
        public void addListener(AbstractWindow.Listener listener) {
            WindowListenerWrapper.add(listener, this);
        }

        @Override
        public void removeListener(AbstractWindow.Listener listener) {
            WindowListenerWrapper.remove(listener, this);
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public Component getWindow() {
            return this;
        }
    }
}

