/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.ProgressComponent;
import de.sciss.util.Disposable;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ProcessingThread
implements Runnable,
EventManager.Processor,
ActionListener,
Disposable {
    private final Client client;
    private final ProgressComponent pc;
    private final Map clientMap = Collections.synchronizedMap(new HashMap());
    protected final String name;
    private final Runnable runProgressUpdate;
    private final Runnable runProcessFinished;
    protected volatile float progress;
    private volatile float progOff = 0.0f;
    private volatile float progStop = 1.0f;
    private volatile float progWeight = 1.0f;
    protected volatile boolean progressInvoked = false;
    protected volatile Exception exception = null;
    protected EventManager elm = null;
    protected int returnCode = -1;
    private volatile boolean shouldCancel = false;
    protected final Object sync = new Object();
    private Thread thread = null;
    private static final Map mapThreads = Collections.synchronizedMap(new HashMap());

    public ProcessingThread(final Client client, final ProgressComponent progressComponent, String string) {
        this.client = client;
        this.pc = progressComponent;
        this.name = string;
        this.runProgressUpdate = new Runnable(){

            @Override
            public void run() {
                ProcessingThread.this.progressInvoked = false;
                progressComponent.setProgression(ProcessingThread.this.progress);
            }
        };
        this.runProcessFinished = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                progressComponent.finishProgression(ProcessingThread.this.returnCode);
                progressComponent.removeCancelListener(ProcessingThread.this);
                client.processFinished(ProcessingThread.this);
                Object object = ProcessingThread.this.sync;
                synchronized (object) {
                    if (ProcessingThread.this.elm != null) {
                        ProcessingThread.this.elm.dispatchEvent(new Event(ProcessingThread.this, 1, System.currentTimeMillis(), ProcessingThread.this));
                    }
                }
                if (ProcessingThread.this.returnCode == 1 && ProcessingThread.this.exception != null) {
                    progressComponent.displayError(ProcessingThread.this.exception, ProcessingThread.this.name);
                }
            }
        };
    }

    public void putClientArg(Object object, Object object2) {
        if (object2 != null) {
            this.clientMap.put(object, object2);
        } else {
            this.clientMap.remove(object);
        }
    }

    public Object getClientArg(Object object) {
        return this.clientMap.get(object);
    }

    public Map getClientMap() {
        return Collections.unmodifiableMap(this.clientMap);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.pc.resetProgression();
        this.pc.setProgressionText(this.name);
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                throw new IllegalStateException("Process was already started");
            }
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            mapThreads.put(this.thread, this);
            this.thread.start();
            try {
                this.sync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.elm != null) {
                this.elm.dispatchEvent(new Event(this, 0, System.currentTimeMillis(), this));
            }
            this.pc.addCancelListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Object object = this.sync;
        synchronized (object) {
            while (this.thread != null && this.thread.isAlive()) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(int n) {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null && this.thread.isAlive()) {
                try {
                    this.sync.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void cancel(boolean bl) {
        this.shouldCancel = true;
        this.client.processCancel(this);
        if (bl) {
            this.sync();
        }
    }

    public static ProcessingThread currentThread() {
        return (ProcessingThread)mapThreads.get(Thread.currentThread());
    }

    public static boolean shouldCancel() {
        ProcessingThread processingThread = ProcessingThread.currentThread();
        return processingThread == null ? false : processingThread.shouldCancel;
    }

    public static void update(float f) throws CancelledException {
        ProcessingThread processingThread = ProcessingThread.currentThread();
        if (processingThread != null) {
            processingThread.setProgression(f);
            if (processingThread.shouldCancel) {
                throw new CancelledException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.sync;
        synchronized (object) {
            return this.thread != null;
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Object object = this.sync;
        synchronized (object) {
            if (this.elm == null) {
                this.elm = new EventManager(this);
            }
        }
        this.elm.addListener(listener);
    }

    public void removeListener(Listener listener) {
        this.elm.removeListener(listener);
    }

    @Override
    public void dispose() {
        if (this.elm != null) {
            this.elm.dispose();
            this.elm = null;
        }
        this.clientMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.sync.notifyAll();
            }
            this.returnCode = this.client.processRun(this);
        }
        catch (CancelledException cancelledException) {
            this.returnCode = 2;
        }
        catch (Exception exception) {
            this.exception = exception;
            this.returnCode = 1;
        }
        finally {
            Object object = this.sync;
            synchronized (object) {
                mapThreads.remove(this.thread);
                this.thread = null;
                this.sync.notifyAll();
            }
            EventQueue.invokeLater(this.runProcessFinished);
        }
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public static void setNextProgStop(float f) {
        ProcessingThread processingThread = ProcessingThread.currentThread();
        if (processingThread != null) {
            processingThread.progOff = processingThread.progress;
            processingThread.progStop = f;
            processingThread.progWeight = processingThread.progStop - processingThread.progress;
        }
    }

    public static void flushProgression() {
        ProcessingThread processingThread = ProcessingThread.currentThread();
        if (processingThread != null) {
            processingThread.progOff = processingThread.progress;
            processingThread.progWeight = processingThread.progStop - processingThread.progress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null && !this.shouldCancel) {
                this.cancel(false);
            }
        }
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        Event event = (Event)basicEvent;
        int n = event.getID();
        block4: for (int i = 0; i < this.elm.countListeners(); ++i) {
            Listener listener = (Listener)this.elm.getListener(i);
            switch (n) {
                case 0: {
                    listener.processStarted(event);
                    continue block4;
                }
                case 1: {
                    listener.processStopped(event);
                    continue block4;
                }
                default: {
                    assert (false) : n;
                    continue block4;
                }
            }
        }
        if (n == 1) {
            this.dispose();
        }
    }

    public Component getComponent() {
        return this.pc.getComponent();
    }

    public void setProgression(float f) {
        this.progress = f * this.progWeight + this.progOff;
        if (!this.progressInvoked) {
            this.progressInvoked = true;
            EventQueue.invokeLater(this.runProgressUpdate);
        }
    }

    public void resetProgression() {
        this.pc.resetProgression();
    }

    public static class CancelledException
    extends IOException {
    }

    public static class Event
    extends BasicEvent {
        private final ProcessingThread pt;
        public static final int STARTED = 0;
        public static final int STOPPED = 1;

        public Event(Object object, int n, long l, ProcessingThread processingThread) {
            super(object, n, l);
            this.pt = processingThread;
        }

        public boolean isDone() {
            return this.pt.getReturnCode() == 0;
        }

        public boolean isCancelled() {
            return this.pt.getReturnCode() == 2;
        }

        public boolean hasFailed() {
            return this.pt.getReturnCode() == 1;
        }

        public ProcessingThread getProcessingThread() {
            return this.pt;
        }

        @Override
        public boolean incorporate(BasicEvent basicEvent) {
            return basicEvent instanceof Event && this.getSource() == basicEvent.getSource() && this.getID() == basicEvent.getID();
        }
    }

    public static interface Listener {
        public void processStarted(Event var1);

        public void processStopped(Event var1);
    }

    public static interface Client {
        public static final int DONE = 0;
        public static final int FAILED = 1;
        public static final int CANCELLED = 2;

        public int processRun(ProcessingThread var1) throws IOException;

        public void processFinished(ProcessingThread var1);

        public void processCancel(ProcessingThread var1);
    }
}

