/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.common;

import java.awt.GraphicsConfiguration;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public class SmartJFrame
extends JFrame {
    private final boolean screenMenuBar;
    private ContainerListener barListener = null;
    private JMenuBar savedBar = null;

    public SmartJFrame(boolean bl) {
        this.screenMenuBar = bl;
    }

    public SmartJFrame(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration);
        this.screenMenuBar = bl;
    }

    public SmartJFrame(String string, boolean bl) {
        super(string);
        this.screenMenuBar = bl;
    }

    public SmartJFrame(String string, GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(string, graphicsConfiguration);
        this.screenMenuBar = bl;
    }

    @Override
    public void setJMenuBar(JMenuBar jMenuBar) {
        if (this.screenMenuBar) {
            super.setJMenuBar(jMenuBar);
            return;
        }
        if (jMenuBar != null) {
            if (this.barListener == null) {
                this.barListener = new ContainerListener(){

                    @Override
                    public void componentAdded(ContainerEvent containerEvent) {
                        SmartJFrame.this.checkMenuBar(containerEvent);
                    }

                    @Override
                    public void componentRemoved(ContainerEvent containerEvent) {
                        SmartJFrame.this.checkMenuBar(containerEvent);
                    }
                };
            } else if (this.savedBar != null) {
                this.savedBar.removeContainerListener(this.barListener);
            }
            this.savedBar = jMenuBar;
            if (jMenuBar.getMenuCount() > 0) {
                super.setJMenuBar(jMenuBar);
            }
            jMenuBar.addContainerListener(this.barListener);
        } else {
            if (this.savedBar != null) {
                this.savedBar.removeContainerListener(this.barListener);
                this.savedBar = null;
            }
            super.setJMenuBar(null);
        }
    }

    protected void checkMenuBar(ContainerEvent containerEvent) {
        JMenuBar jMenuBar = (JMenuBar)containerEvent.getContainer();
        if (jMenuBar.getMenuCount() == 0) {
            if (this.getJMenuBar() == jMenuBar) {
                super.setJMenuBar(null);
            }
        } else if (this.getJMenuBar() == null) {
            super.setJMenuBar(jMenuBar);
        }
        JRootPane jRootPane = this.getRootPane();
        jRootPane.revalidate();
        jRootPane.repaint();
    }
}

