/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class AquaResizeGadget
extends JComponent {
    private static final Dimension d = new Dimension(16, 16);
    private static final Color c = new Color(136, 136, 136);

    public AquaResizeGadget() {
        this.setSize(d);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setForeground(c);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Point initialMouse = null;
            Dimension initialSize;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                if (window != null) {
                    this.initialMouse = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(this.initialMouse, mouseEvent.getComponent());
                    this.initialSize = window.getSize();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.initialMouse = null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                if (this.initialMouse != null && window != null) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                    window.setSize(Math.max(32, this.initialSize.width + point.x - this.initialMouse.x), Math.max(32, this.initialSize.height + point.y - this.initialMouse.y));
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.mouseDragged(mouseEvent);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawLine(4, 13, 13, 4);
        graphics2D.drawLine(8, 13, 13, 8);
        graphics2D.drawLine(12, 13, 13, 12);
    }
}

