/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractWindow;
import de.sciss.gui.AquaFocusBorder;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.TemporaryFocusTracker;
import de.sciss.gui.TiledImage;
import de.sciss.util.Disposable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.event.MouseInputAdapter;

public class AquaWindowBar
extends JPanel
implements Disposable,
SwingConstants,
WindowConstants {
    private static final int BAR_WIDTH = 22;
    private static final int BAR_WIDTH_SM = 16;
    private static final int PNT_WIDTH = 20;
    private static final int PNT_WIDTH_SM = 15;
    private static final int[] bgPixels = new int[]{-1052689, -1513240, -1644826, -1644826, -1644826, -1776412, -1842205, -1907998, -2039584, -2105377, -2236963, -2368549, -2500135, -2631721, -2697514, -2894893, -3026479, -3158065, -3355444, -3487030};
    private final BufferedImage imgActive;
    private final Paint pntActive;
    private String title;
    private static final Color colrTextActive = Color.black;
    private static final Color colrTextInactive = new Color(0, 0, 0, 127);
    private static final Color colrLine1 = new Color(249, 249, 249);
    private static final Color colrLine2 = new Color(140, 140, 140);
    private static final Color colrLineS = new Color(142, 142, 142);
    private static final Color colrLineSI = new Color(142, 142, 142, 151);
    private static final Paint pntInactive = new Color(0, 0, 0, 8);
    private static final double nintyCCW = -1.5707963267948966;
    private final AbstractWindow w;
    private final AbstractWindow.Listener winListener;
    private final int flags;
    private final boolean small;
    private final boolean vertical;
    private final int width;
    private final int pntExtent;
    private boolean alwaysOnTop = false;
    protected final TripletButton[] ggTriplet = new TripletButton[3];
    private int tripletX;
    private final MouseAdapter tripletML;
    protected static TiledImage imgTriplet = null;
    public static final int CLOSEGADGET = 1;
    public static final int MINGADGET = 2;
    public static final int MAXGADGET = 4;
    public static final int TRIPLET = 7;
    protected int dco = 1;
    protected final boolean isMac;
    private TemporaryFocusTracker tft = null;

    public AquaWindowBar(AbstractWindow abstractWindow, String string, boolean bl) {
        this(abstractWindow, string, bl, 0);
    }

    public AquaWindowBar(AbstractWindow abstractWindow, String string, boolean bl, int n) {
        this(abstractWindow, string, bl, n, 7);
    }

    public AquaWindowBar(AbstractWindow abstractWindow, String string, boolean bl, int n, int n2) {
        this(abstractWindow, bl, n, n2);
        this.title = string;
    }

    public AquaWindowBar(AbstractWindow abstractWindow, boolean bl) {
        this(abstractWindow, bl, 0);
    }

    public AquaWindowBar(AbstractWindow abstractWindow, boolean bl, int n) {
        this(abstractWindow, bl, n, 7);
    }

    public AquaWindowBar(final AbstractWindow abstractWindow, boolean bl, int n, int n2) {
        super(null);
        this.w = abstractWindow;
        this.small = bl;
        this.vertical = n == 1;
        this.flags = n2;
        this.width = bl ? 16 : 22;
        this.pntExtent = bl ? 15 : 20;
        boolean bl2 = this.isMac = System.getProperty("os.name").indexOf("Mac OS") >= 0;
        if (this.vertical) {
            GUIUtil.constrainWidth(this, this.width);
            this.imgActive = new BufferedImage(this.pntExtent, 1, 2);
            this.imgActive.setRGB(0, 0, this.pntExtent, 1, bgPixels, 0, this.pntExtent);
            this.pntActive = new TexturePaint(this.imgActive, new Rectangle(0, 0, this.pntExtent, 1));
        } else {
            GUIUtil.constrainHeight(this, this.width);
            this.imgActive = new BufferedImage(1, this.pntExtent, 2);
            this.imgActive.setRGB(0, 0, 1, this.pntExtent, bgPixels, 0, 1);
            this.pntActive = new TexturePaint(this.imgActive, new Rectangle(0, 0, 1, this.pntExtent));
        }
        if (bl) {
            this.setFont(new Font("Lucida Grande", 0, 11));
        }
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private Point initialMouse = null;
            private Point initialLoc;
            private Rectangle bounds;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                if (window != null) {
                    this.initialMouse = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(this.initialMouse, mouseEvent.getComponent());
                    this.initialLoc = window.getLocation();
                    GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                    this.bounds = graphicsDeviceArray[0].getDefaultConfiguration().getBounds();
                    for (int i = 1; i < graphicsDeviceArray.length; ++i) {
                        this.bounds = this.bounds.union(graphicsDeviceArray[i].getDefaultConfiguration().getBounds());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.initialMouse = null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                if (this.initialMouse != null && window != null) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                    window.setLocation(Math.max(this.bounds.x, this.initialLoc.x + point.x - this.initialMouse.x), Math.max(this.bounds.y + (AquaWindowBar.this.isMac ? 22 : 0), this.initialLoc.y + point.y - this.initialMouse.y));
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.mouseDragged(mouseEvent);
            }
        };
        this.winListener = new AbstractWindow.Adapter(){

            @Override
            public void windowActivated(AbstractWindow.Event event) {
                AquaWindowBar.this.repaint();
            }

            @Override
            public void windowDeactivated(AbstractWindow.Event event) {
                AquaWindowBar.this.repaint();
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        abstractWindow.addListener(this.winListener);
        if ((n2 & 7) != 0 && bl) {
            if (imgTriplet == null) {
                imgTriplet = new TiledImage(this.getClass().getResource(AquaFocusBorder.getAquaColorVariant() == 1 ? "paletteblue.png" : "palettegraphite.png"), 11, 12);
            }
            this.tripletML = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    for (int i = 0; i < AquaWindowBar.this.ggTriplet.length; ++i) {
                        if (AquaWindowBar.this.ggTriplet[i] == null) continue;
                        AquaWindowBar.this.ggTriplet[i].setArmed(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    for (int i = 0; i < AquaWindowBar.this.ggTriplet.length; ++i) {
                        if (AquaWindowBar.this.ggTriplet[i] == null) continue;
                        AquaWindowBar.this.ggTriplet[i].setArmed(false);
                    }
                }
            };
            this.tripletX = this.vertical ? 3 : 5;
            for (int i = 0; i < this.ggTriplet.length; ++i) {
                this.createGadget(i);
            }
        } else {
            if ((n2 & 7) != 0) {
                throw new IllegalArgumentException("Gadgets not yet working for regular size bars");
            }
            this.tripletML = null;
        }
        if (this.ggTriplet[0] != null) {
            this.ggTriplet[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    abstractWindow.getWindow().dispatchEvent(new WindowEvent((Window)abstractWindow.getWindow(), 201));
                    switch (AquaWindowBar.this.dco) {
                        case 1: {
                            abstractWindow.setVisible(false);
                            break;
                        }
                        case 2: {
                            abstractWindow.dispose();
                            break;
                        }
                        case 3: {
                            System.exit(0);
                            break;
                        }
                    }
                }
            });
        }
        if (this.ggTriplet[1] != null) {
            this.ggTriplet[1].setEnabled(false);
        }
        if (this.ggTriplet[2] != null) {
            this.ggTriplet[2].setEnabled(false);
        }
    }

    public void setResizable(boolean bl) {
    }

    public void addCloseActionListener(ActionListener actionListener) {
        this.ggTriplet[0].addActionListener(actionListener);
    }

    public void removeCloseActionListener(ActionListener actionListener) {
        this.ggTriplet[0].removeActionListener(actionListener);
    }

    public void addMinActionListener(ActionListener actionListener) {
        this.ggTriplet[1].addActionListener(actionListener);
    }

    public void removeMinActionListener(ActionListener actionListener) {
        this.ggTriplet[1].removeActionListener(actionListener);
    }

    public void addMaxActionListener(ActionListener actionListener) {
        this.ggTriplet[2].addActionListener(actionListener);
    }

    public void removeMaxActionListener(ActionListener actionListener) {
        this.ggTriplet[2].removeActionListener(actionListener);
    }

    public int getDefaultCloseOperation() {
        return this.dco;
    }

    public void setDefaultCloseOperation(int n) {
        this.dco = n;
    }

    private void createGadget(int n) {
        if ((this.flags & 1 << n) != 0) {
            this.ggTriplet[n] = new TripletButton(n);
            if (this.vertical) {
                this.ggTriplet[n].setLocation(3, this.tripletX);
            } else {
                this.ggTriplet[n].setLocation(this.tripletX, 2);
            }
            this.ggTriplet[n].addMouseListener(this.tripletML);
            this.add(this.ggTriplet[n]);
            this.tripletX += 18;
            if (n > 0) {
                this.ggTriplet[n - 1].setGaps(this.vertical ? 0 : 5, this.vertical ? 5 : 0);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = this.alwaysOnTop || this.w.isActive();
        graphics2D.setPaint(this.pntActive != null && bl ? this.pntActive : pntInactive);
        if (this.vertical) {
            graphics2D.fillRect(0, 0, this.pntExtent, this.getHeight());
            if (this.small) {
                graphics2D.setColor(bl ? colrLineS : colrLineSI);
                graphics2D.drawLine(this.pntExtent, 0, this.pntExtent, this.getHeight() - 1);
            } else {
                graphics2D.setColor(colrLine1);
                graphics2D.drawLine(this.pntExtent, 0, this.pntExtent, this.getHeight() - 1);
                graphics2D.setColor(colrLine2);
                graphics2D.drawLine(this.pntExtent + 1, 0, this.pntExtent + 1, this.getHeight() - 1);
            }
            if (this.title != null) {
                AffineTransform affineTransform = graphics2D.getTransform();
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                graphics2D.setColor(bl || this.small ? colrTextActive : colrTextInactive);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawString(this.title, -(this.getHeight() + fontMetrics.stringWidth(this.title) >> 1), (this.pntExtent + fontMetrics.getAscent() >> 1) - 1);
                graphics2D.setTransform(affineTransform);
            }
        } else {
            graphics2D.fillRect(0, 0, this.getWidth(), this.pntExtent);
            if (this.small) {
                graphics2D.setColor(bl ? colrLineS : colrLineSI);
                graphics2D.drawLine(0, this.pntExtent, this.getWidth() - 1, this.pntExtent);
            } else {
                graphics2D.setColor(colrLine1);
                graphics2D.drawLine(0, this.pntExtent, this.getWidth() - 1, this.pntExtent);
                graphics2D.setColor(colrLine2);
                graphics2D.drawLine(0, this.pntExtent + 1, this.getWidth() - 1, this.pntExtent + 1);
            }
            if (this.title != null) {
                AffineTransform affineTransform = graphics2D.getTransform();
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                graphics2D.setColor(bl || this.small ? colrTextActive : colrTextInactive);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawString(this.title, Math.max(this.tripletX, this.getWidth() - fontMetrics.stringWidth(this.title) >> 1), (this.pntExtent + fontMetrics.getAscent() >> 1) - 1);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public void setAlwaysOnTop(boolean bl) {
        if (bl != this.alwaysOnTop) {
            if (this.tft != null) {
                this.tft.dispose();
                this.tft = null;
            }
            if (GUIUtil.setAlwaysOnTop(this.w.getWindow(), true)) {
                if (this.alwaysOnTop && this.w.isVisible()) {
                    this.w.toFront();
                }
                JFrame jFrame = (JFrame)this.w.getWindow();
                jFrame.setFocusableWindowState(false);
                this.tft = new TemporaryFocusTracker(jFrame);
                this.repaint();
            }
        }
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void dispose() {
        this.imgActive.flush();
    }

    private static class TripletButton
    extends JButton {
        private final Icon icnNormal;
        private final Icon icnDisabled;
        private final Icon icnOver;
        private final Icon icnPressed;

        protected TripletButton(int n) {
            this(imgTriplet.createIcon(n, 0), imgTriplet.createIcon(n, 1), imgTriplet.createIcon(n, 2), imgTriplet.createIcon(n, 3));
        }

        private TripletButton(Icon icon, Icon icon2, Icon icon3, Icon icon4) {
            this.icnNormal = icon;
            this.icnDisabled = icon2;
            this.icnOver = icon3;
            this.icnPressed = icon4;
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            Dimension dimension = new Dimension(n, n2);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
        }

        protected void setGaps(int n, int n2) {
            int n3 = this.icnNormal.getIconWidth();
            int n4 = this.icnNormal.getIconHeight();
            Dimension dimension = new Dimension(n3 + n, n4 + n2);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
        }

        protected void setArmed(boolean bl) {
            ButtonModel buttonModel = this.getModel();
            buttonModel.setArmed(bl);
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            ButtonModel buttonModel;
            Icon icon = this.isEnabled() ? ((buttonModel = this.getModel()).isPressed() ? this.icnPressed : (buttonModel.isArmed() ? this.icnOver : this.icnNormal)) : this.icnDisabled;
            icon.paintIcon(this, graphics, 0, 0);
        }
    }
}

