/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ComponentBoundsRestrictor
extends ComponentAdapter {
    public static int NO_MIN = Integer.MIN_VALUE;
    public static int NO_MAX = Integer.MAX_VALUE;
    private int minLeft = NO_MIN;
    private int maxLeft = NO_MAX;
    private int minTop = NO_MIN;
    private int maxTop = NO_MAX;
    private int minRight = NO_MIN;
    private int maxRight = NO_MAX;
    private int minBottom = NO_MIN;
    private int maxBottom = NO_MAX;
    private int minWidth = NO_MIN;
    private int maxWidth = NO_MAX;
    private int minHeight = NO_MIN;
    private int maxHeight = NO_MAX;
    private final Map map = new HashMap();
    private final Rectangle r = new Rectangle();

    public void add(Component component) {
        Rectangle rectangle = component.getBounds();
        if (this.map.put(component, rectangle) != null) {
            throw new IllegalArgumentException("Component was already added");
        }
        component.addComponentListener(this);
        this.restrict(component, rectangle);
    }

    public void remove(Component component) {
        if (this.map.remove(component) == null) {
            throw new IllegalArgumentException("Component was not added");
        }
        component.removeComponentListener(this);
    }

    public void setMinimumLeft(int n) {
        this.minLeft = n;
        this.restrict();
    }

    public void setMaximumLeft(int n) {
        this.maxLeft = n;
        this.restrict();
    }

    public void setMinimumTop(int n) {
        this.minTop = n;
        this.restrict();
    }

    public void setMaximumTop(int n) {
        this.maxTop = n;
        this.restrict();
    }

    public void setMinimumBottom(int n) {
        this.minBottom = n;
        this.restrict();
    }

    public void setMaximumBottom(int n) {
        this.maxBottom = n;
        this.restrict();
    }

    public void setMinimumRight(int n) {
        this.minRight = n;
        this.restrict();
    }

    public void setMaximumRight(int n) {
        this.maxRight = n;
        this.restrict();
    }

    public void setMinimumWidth(int n) {
        this.minWidth = n;
        this.restrict();
    }

    public void setMaximumWidth(int n) {
        this.maxWidth = n;
        this.restrict();
    }

    public void setMinimumHeight(int n) {
        this.minHeight = n;
        this.restrict();
    }

    public void setMaximumHeight(int n) {
        this.maxHeight = n;
        this.restrict();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.restrict(component, (Rectangle)this.map.get(component));
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.restrict(component, (Rectangle)this.map.get(component));
    }

    private void restrict() {
        for (Map.Entry entry : this.map.entrySet()) {
            this.restrict((Component)entry.getKey(), (Rectangle)entry.getValue());
        }
    }

    private void restrict(Component component, Rectangle rectangle) {
        component.getBounds(this.r);
        boolean bl = false;
        if (this.r.x < this.minLeft) {
            bl = true;
            if (this.r.x + this.r.width == rectangle.x + rectangle.width) {
                this.r.width -= this.minLeft - this.r.x;
            }
            this.r.x = this.minLeft;
        } else if (this.r.x > this.maxLeft) {
            bl = true;
            if (this.r.x + this.r.width == rectangle.x + rectangle.width) {
                this.r.width -= this.maxLeft - this.r.x;
            }
            this.r.x = this.maxLeft;
        }
        if (this.r.y < this.minTop) {
            bl = true;
            if (this.r.y + this.r.height == rectangle.y + rectangle.height) {
                this.r.height -= this.minTop - this.r.y;
            }
            this.r.y = this.minTop;
        } else if (this.r.y > this.maxTop) {
            bl = true;
            if (this.r.y + this.r.height == rectangle.y + rectangle.height) {
                this.r.height -= this.maxTop - this.r.y;
            }
            this.r.y = this.maxTop;
        }
        if (this.r.x + this.r.width < this.minRight) {
            bl = true;
            if (this.r.x == rectangle.x) {
                this.r.width = this.minRight - this.r.x;
            } else {
                this.r.x = this.minRight - this.r.width;
            }
        } else if (this.r.x + this.r.width > this.maxRight) {
            bl = true;
            if (this.r.x == rectangle.x) {
                this.r.width = this.maxRight - this.r.x;
            } else {
                this.r.x = this.maxRight - this.r.width;
            }
        }
        if (this.r.y + this.r.height < this.minBottom) {
            bl = true;
            if (this.r.y == rectangle.y) {
                this.r.height = this.minBottom - this.r.y;
            } else {
                this.r.y = this.minBottom - this.r.height;
            }
        } else if (this.r.y + this.r.height > this.maxBottom) {
            bl = true;
            if (this.r.y == rectangle.y) {
                this.r.height = this.maxBottom - this.r.y;
            } else {
                this.r.y = this.maxBottom - this.r.height;
            }
        }
        if (this.r.width < this.minWidth) {
            bl = true;
            if (this.r.x + this.r.width == rectangle.x + rectangle.width) {
                this.r.x -= this.minWidth - this.r.width;
            }
            this.r.width = this.minWidth;
        } else if (this.r.width > this.maxWidth) {
            bl = true;
            if (this.r.x + this.r.width == rectangle.x + rectangle.width) {
                this.r.x -= this.maxWidth - this.r.width;
            }
            this.r.width = this.maxWidth;
        }
        if (this.r.height < this.minHeight) {
            bl = true;
            if (this.r.y + this.r.height == rectangle.y + rectangle.height) {
                this.r.y -= this.minHeight - this.r.height;
            }
            this.r.height = this.minHeight;
        } else if (this.r.height > this.maxHeight) {
            bl = true;
            if (this.r.y + this.r.height == rectangle.y + rectangle.height) {
                this.r.y -= this.maxHeight - this.r.height;
            }
            this.r.height = this.maxHeight;
        }
        rectangle.setBounds(this.r);
        if (bl) {
            component.setBounds(this.r);
        }
    }

    public static void test() {
        final JFrame jFrame = new JFrame("Test");
        final JLabel jLabel = new JLabel("", 0);
        final Rectangle rectangle = new Rectangle();
        ComponentBoundsRestrictor componentBoundsRestrictor = new ComponentBoundsRestrictor();
        jFrame.getContentPane().add(jLabel);
        jFrame.addComponentListener(new ComponentAdapter(){

            private void update() {
                jFrame.getBounds(rectangle);
                jLabel.setText("L " + rectangle.x + ", T " + rectangle.y + ", R " + (rectangle.x + rectangle.width) + ", B " + (rectangle.y + rectangle.height) + ", W " + rectangle.width + ", H " + rectangle.height);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.update();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.update();
            }
        });
        componentBoundsRestrictor.setMinimumLeft(100);
        componentBoundsRestrictor.setMinimumTop(200);
        componentBoundsRestrictor.setMinimumWidth(300);
        componentBoundsRestrictor.setMaximumWidth(330);
        componentBoundsRestrictor.setMinimumHeight(120);
        componentBoundsRestrictor.setMaximumHeight(150);
        componentBoundsRestrictor.setMaximumRight(700);
        componentBoundsRestrictor.setMaximumBottom(500);
        componentBoundsRestrictor.add(jFrame);
        jFrame.setVisible(true);
    }
}

