/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.HelpFrame;
import de.sciss.gui.TiledImage;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class HelpButton
extends JButton
implements DynamicListening,
ActionListener {
    private final Icon icnNormal;
    private final Icon icnPressed;
    private final Icon icnUnfocussed;
    private static TiledImage imgHelpIcons = null;
    private Window win = null;
    private String file = null;
    private final WindowAdapter winListener;

    public HelpButton(String string) {
        this();
        this.setHelpFile(string);
    }

    public HelpButton() {
        if (imgHelpIcons == null) {
            imgHelpIcons = new TiledImage(this.getClass().getResource("helpbutton.png"), 24, 24);
        }
        this.icnNormal = imgHelpIcons.createIcon(0, 0);
        this.icnPressed = imgHelpIcons.createIcon(0, 1);
        this.icnUnfocussed = imgHelpIcons.createIcon(0, 2);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMargin(new Insets(2, 2, 2, 2));
        GUIUtil.constrainSize(this, 28, 28);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        new DynamicAncestorAdapter(this).addTo(this);
        this.addActionListener(this);
        this.winListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                HelpButton.this.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                HelpButton.this.repaint();
            }
        };
    }

    public void setHelpFile(String string) {
        this.file = string;
    }

    public String getHelpFile() {
        return this.file;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.file != null) {
            HelpFrame.openViewerAndLoadHelpFile(this.file);
        }
    }

    @Override
    public void startListening() {
        this.win = SwingUtilities.getWindowAncestor(this);
        if (this.win != null) {
            this.win.addWindowListener(this.winListener);
        }
    }

    @Override
    public void stopListening() {
        if (this.win != null) {
            this.win.removeWindowListener(this.winListener);
        }
        this.win = null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Window window = SwingUtilities.getWindowAncestor(this);
        Icon icon = window != null && window.isActive() ? (this.getModel().isPressed() ? this.icnPressed : this.icnNormal) : this.icnUnfocussed;
        icon.paintIcon(this, graphics, (this.getWidth() - 24 >> 1) + 2, (this.getHeight() - 24 >> 1) + 2);
    }
}

