/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class MenuAction
extends AbstractAction {
    public MenuAction(String string, KeyStroke keyStroke) {
        super(string);
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
    }

    public MenuAction(String string) {
        super(string);
    }

    public MenuAction() {
    }

    public void mimic(Action action) {
        this.putValue("Name", action.getValue("Name"));
        this.putValue("SmallIcon", action.getValue("SmallIcon"));
        this.putValue("AcceleratorKey", action.getValue("AcceleratorKey"));
        this.putValue("MnemonicKey", action.getValue("MnemonicKey"));
        this.putValue("ShortDescription", action.getValue("ShortDescription"));
        this.putValue("LongDescription", action.getValue("LongDescription"));
        this.setEnabled(action.isEnabled());
    }

    public void installOn(JComponent jComponent, int n) {
        InputMap inputMap = jComponent.getInputMap(n);
        ActionMap actionMap = jComponent.getActionMap();
        String string = (String)this.getValue("Name");
        inputMap.put((KeyStroke)this.getValue("AcceleratorKey"), string);
        actionMap.put(string, this);
    }

    public void deinstallFrom(JComponent jComponent, int n) {
        InputMap inputMap = jComponent.getInputMap(n);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.remove((KeyStroke)this.getValue("AcceleratorKey"));
        actionMap.remove(this.getValue("Name"));
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

