/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractWindow;
import de.sciss.gui.MenuItem;
import de.sciss.gui.MenuNode;
import de.sciss.gui.MenuSeparator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class MenuGroup
extends MenuItem {
    protected final Map proxies = new HashMap();
    protected final NodeProxy defaultProxy = new NodeProxy(null);

    public MenuGroup(String string, Action action) {
        super(string, action);
    }

    public MenuGroup(String string, String string2) {
        this(string, new MenuNode.DummyAction(string2));
    }

    public MenuNode get(String string) {
        return this.get(this.defaultProxy, string);
    }

    public MenuNode get(AbstractWindow abstractWindow, String string) {
        return this.get(this.getProxy(abstractWindow, false), string);
    }

    private NodeProxy getProxy(AbstractWindow abstractWindow, boolean bl) {
        if (abstractWindow == null) {
            return this.defaultProxy;
        }
        NodeProxy nodeProxy = (NodeProxy)this.proxies.get(abstractWindow);
        if (nodeProxy == null && bl) {
            nodeProxy = new NodeProxy(abstractWindow);
            this.proxies.put(abstractWindow, nodeProxy);
        }
        return nodeProxy;
    }

    private MenuNode get(NodeProxy nodeProxy, String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return (MenuNode)nodeProxy.mapElements.get(string);
        }
        MenuGroup menuGroup = (MenuGroup)nodeProxy.mapElements.get(string.substring(0, n));
        if (menuGroup == null) {
            throw new NullPointerException(string);
        }
        return menuGroup.get(nodeProxy.w, string.substring(n + 1));
    }

    public int indexOf(String string) {
        return this.indexOf(this.defaultProxy, string);
    }

    public int indexOf(AbstractWindow abstractWindow, String string) {
        return this.indexOf(this.getProxy(abstractWindow, false), string);
    }

    private int indexOf(NodeProxy nodeProxy, String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return nodeProxy.collElements.indexOf(nodeProxy.mapElements.get(string));
        }
        MenuGroup menuGroup = (MenuGroup)nodeProxy.mapElements.get(string.substring(0, n));
        if (menuGroup == null) {
            throw new NullPointerException(string);
        }
        return menuGroup.indexOf(string.substring(n + 1));
    }

    public MenuNode getByAction(Action action) {
        return this.getByAction(this.defaultProxy, action);
    }

    public MenuNode getByAction(AbstractWindow abstractWindow, Action action) {
        return this.getByAction(this.getProxy(abstractWindow, false), action);
    }

    private MenuNode getByAction(NodeProxy nodeProxy, Action action) {
        for (MenuNode menuNode : nodeProxy.collElements) {
            if (menuNode.getAction() != action) continue;
            return menuNode;
        }
        return null;
    }

    public void add(AbstractWindow abstractWindow, MenuNode menuNode) {
        this.add(this.getProxy(abstractWindow, true), menuNode);
    }

    public void add(MenuNode menuNode) {
        this.add(this.defaultProxy, menuNode);
    }

    public void add(MenuNode menuNode, int n) {
        this.add(this.defaultProxy, menuNode, n);
    }

    public void add(AbstractWindow abstractWindow, MenuNode menuNode, int n) {
        this.add(this.getProxy(abstractWindow, true), menuNode, n);
    }

    private void add(NodeProxy nodeProxy, MenuNode menuNode) {
        this.add(nodeProxy, menuNode, nodeProxy.collElements.size());
    }

    public int size() {
        return this.defaultProxy.size();
    }

    public MenuNode get(int n) {
        return (MenuNode)this.defaultProxy.collElements.get(n);
    }

    private void add(NodeProxy nodeProxy, MenuNode menuNode, int n) {
        if (nodeProxy.mapElements.put(menuNode.getID(), menuNode) != null) {
            throw new IllegalArgumentException("Element already added : " + menuNode);
        }
        boolean bl = nodeProxy.w == null;
        nodeProxy.collElements.add(n, menuNode);
        for (MenuItem.Realized realized : this.mapRealized.values()) {
            if (!bl && nodeProxy.w != realized.w) continue;
            realized.c.add((Component)menuNode.create(realized.w), n + (bl ? 0 : this.defaultProxy.size()));
        }
    }

    public void addSeparator(AbstractWindow abstractWindow) {
        this.add(abstractWindow, (MenuNode)new MenuSeparator());
    }

    public void addSeparator() {
        this.addSeparator(null);
    }

    public void remove(int n) {
        this.remove(this.defaultProxy, n);
    }

    public void remove(AbstractWindow abstractWindow, int n) {
        this.remove(this.getProxy(abstractWindow, false), n);
    }

    private void remove(NodeProxy nodeProxy, int n) {
        MenuNode menuNode = (MenuNode)nodeProxy.collElements.remove(n);
        nodeProxy.mapElements.remove(menuNode.getID());
        boolean bl = nodeProxy.w == null;
        for (MenuItem.Realized realized : this.mapRealized.values()) {
            if (!bl && nodeProxy.w != realized.w) continue;
            realized.c.remove(n + (bl ? 0 : this.defaultProxy.size()));
            menuNode.destroy(realized.w);
        }
    }

    public void remove(MenuNode menuNode) {
        this.remove(this.defaultProxy, menuNode);
    }

    public void remove(AbstractWindow abstractWindow, MenuNode menuNode) {
        this.remove(this.getProxy(abstractWindow, false), menuNode);
    }

    private void remove(NodeProxy nodeProxy, MenuNode menuNode) {
        for (int i = 0; i < nodeProxy.collElements.size(); ++i) {
            if ((MenuNode)nodeProxy.collElements.get(i) != menuNode) continue;
            this.remove(nodeProxy, i);
            return;
        }
    }

    @Override
    public JComponent create(AbstractWindow abstractWindow) {
        JComponent jComponent = super.create(abstractWindow);
        this.defaultProxy.create(jComponent, abstractWindow);
        NodeProxy nodeProxy = this.getProxy(abstractWindow, false);
        if (nodeProxy != null) {
            nodeProxy.create(jComponent, abstractWindow);
        }
        return jComponent;
    }

    @Override
    public void destroy(AbstractWindow abstractWindow) {
        super.destroy(abstractWindow);
        this.defaultProxy.destroy(abstractWindow);
        NodeProxy nodeProxy = this.getProxy(abstractWindow, false);
        if (nodeProxy != null) {
            nodeProxy.destroy(abstractWindow);
            if (nodeProxy.isEmpty()) {
                this.proxies.remove(abstractWindow);
            }
        }
    }

    @Override
    protected JComponent createComponent(Action action) {
        return new JMenu(action);
    }

    public void putMimic(String string, AbstractWindow abstractWindow, Action action) {
        if (action == null) {
            return;
        }
        MenuItem menuItem = (MenuItem)this.get(string);
        if (menuItem == null) {
            throw new NullPointerException(string);
        }
        Action action2 = menuItem.getAction();
        action.putValue("Name", action2.getValue("Name"));
        action.putValue("SmallIcon", action2.getValue("SmallIcon"));
        action.putValue("AcceleratorKey", action2.getValue("AcceleratorKey"));
        this.putNoNullNull(action2, action, "MnemonicKey");
        action.putValue("ShortDescription", action2.getValue("ShortDescription"));
        action.putValue("LongDescription", action2.getValue("LongDescription"));
        menuItem.put(abstractWindow, action);
    }

    private void putNoNullNull(Action action, Action action2, String string) {
        Object object = action.getValue(string);
        Object object2 = action2.getValue(string);
        if (object == null && object2 == null) {
            return;
        }
        action2.putValue(string, object);
    }

    private static class NodeProxy {
        protected final AbstractWindow w;
        protected final List collElements = new ArrayList();
        protected final Map mapElements = new HashMap();

        protected NodeProxy(AbstractWindow abstractWindow) {
            this.w = abstractWindow;
        }

        protected int size() {
            return this.collElements.size();
        }

        protected boolean isEmpty() {
            return this.collElements.isEmpty();
        }

        protected void create(JComponent jComponent, AbstractWindow abstractWindow) {
            if (this.w != null && this.w != abstractWindow) {
                throw new IllegalArgumentException();
            }
            Iterator iterator = this.collElements.iterator();
            while (iterator.hasNext()) {
                jComponent.add(((MenuNode)iterator.next()).create(abstractWindow));
            }
        }

        protected void destroy(AbstractWindow abstractWindow) {
            if (this.w != null && this.w != abstractWindow) {
                throw new IllegalArgumentException();
            }
            Iterator iterator = this.collElements.iterator();
            while (iterator.hasNext()) {
                ((MenuNode)iterator.next()).destroy(abstractWindow);
            }
        }
    }
}

