/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.LooseFocusAction;
import de.sciss.gui.NumberEvent;
import de.sciss.gui.NumberListener;
import de.sciss.gui.TimeFormat;
import de.sciss.gui.TimeFormatter;
import de.sciss.util.NumberSpace;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberField
extends JFormattedTextField
implements EventManager.Processor {
    private static final double LN10 = Math.log(10.0);
    public static final int HHMMSS = 131072;
    private NumberSpace space;
    protected Number value;
    private NumberFormat numberFormat;
    private TimeFormat timeFormat;
    private int flags;
    private EventManager elm = null;
    private final DefaultFormatterFactory factory = new DefaultFormatterFactory();
    private final NumberFormatter numberFormatter = new NumberFormatter();
    private final TimeFormatter timeFormatter = new TimeFormatter();
    protected static final DataFlavor numberFlavor = new DataFlavor(Number.class, Number.class.getName());
    protected static final DataFlavor[] supportedFlavors = new DataFlavor[]{numberFlavor, DataFlavor.stringFlavor};

    public NumberField() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.setFormatterFactory(this.factory);
        this.setHorizontalAlignment(4);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    NumberField.this.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Number number = (Number)NumberField.this.getValue();
                if (!number.equals(NumberField.this.value)) {
                    NumberField.this.value = number;
                    NumberField.this.fireNumberChanged();
                }
            }
        });
        new LooseFocusAction(this);
        Action action = TransferHandler.getCopyAction();
        Object object = action.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(67, n), object);
        actionMap.put(object, action);
        action = TransferHandler.getPasteAction();
        object = action.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(86, n), object);
        actionMap.put(object, action);
        this.setTransferHandler(new NumberTransferHandler());
    }

    public NumberField(NumberSpace numberSpace) {
        this();
        this.setSpace(numberSpace);
    }

    public void setSpace(NumberSpace numberSpace) {
        if (!numberSpace.equals(this.space)) {
            this.space = numberSpace;
            this.updateFormatter();
        }
    }

    public void setFlags(int n) {
        int n2 = this.flags ^ n;
        this.flags = n;
        if ((n2 & 0x20000) != 0) {
            this.updateFormatter();
        }
    }

    public int getFlags() {
        return this.flags;
    }

    private void updateFormatter() {
        int n;
        if (this.space.isInteger()) {
            this.numberFormat = NumberFormat.getIntegerInstance(Locale.US);
        } else {
            this.numberFormat = NumberFormat.getInstance(Locale.US);
            n = Math.min(8, this.space.maxFracDigits);
            this.numberFormat.setMinimumFractionDigits(this.space.minFracDigits);
            this.numberFormat.setMaximumFractionDigits(n);
        }
        if ((this.flags & 0x20000) != 0) {
            this.timeFormat = new TimeFormat(0, null, null, this.numberFormat.getMaximumFractionDigits(), Locale.US);
            this.numberFormat.setMinimumIntegerDigits(2);
            this.numberFormat.setMaximumIntegerDigits(2);
            this.numberFormat.setMinimumFractionDigits(this.numberFormat.getMaximumFractionDigits());
            n = 5;
        } else {
            this.timeFormat = null;
            if (Double.isInfinite(this.space.min) || Double.isInfinite(this.space.max)) {
                this.numberFormat.setMaximumIntegerDigits(8);
            } else {
                double d = Math.max(1.0, Math.floor(Math.abs(this.space.min)) + 0.1);
                n = (int)(Math.log(d) / LN10) + 1;
                d = Math.max(1.0, Math.floor(Math.abs(this.space.max)) + 0.1);
                n = Math.max(n, (int)(Math.log(d) / LN10) + 1);
                this.numberFormat.setMaximumIntegerDigits(n);
            }
            n = 1;
        }
        this.setColumns(n += Math.min(4, this.numberFormat.getMaximumFractionDigits()) + this.numberFormat.getMaximumIntegerDigits());
        if (this.value == null) {
            this.value = this.space.isInteger() ? (Number)new Long((long)(this.space.reset + 0.5)) : (Number)new Double(this.space.reset);
        }
        this.numberFormat.setGroupingUsed(false);
        if ((this.flags & 0x20000) == 0) {
            this.numberFormatter.setFormat(this.numberFormat);
            if (this.space.isInteger()) {
                this.numberFormatter.setValueClass(Long.class);
                if (!Double.isInfinite(this.space.min)) {
                    this.numberFormatter.setMinimum(new Long((long)this.space.min));
                }
                if (!Double.isInfinite(this.space.max)) {
                    this.numberFormatter.setMaximum(new Long((long)this.space.max));
                }
            } else {
                this.numberFormatter.setValueClass(Double.class);
                if (!Double.isInfinite(this.space.min)) {
                    this.numberFormatter.setMinimum(new Double(this.space.min));
                }
                if (!Double.isInfinite(this.space.max)) {
                    this.numberFormatter.setMaximum(new Double(this.space.max));
                }
            }
            this.factory.setDefaultFormatter(this.numberFormatter);
        } else {
            this.timeFormatter.setFormat(this.timeFormat);
            this.factory.setDefaultFormatter(this.timeFormatter);
        }
        this.setValue(this.value);
    }

    public Number getNumber() {
        return this.value;
    }

    public void setNumber(Number number) {
        this.value = number;
        this.setValue(number);
    }

    public NumberSpace getSpace() {
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NumberListener numberListener) {
        NumberField numberField = this;
        synchronized (numberField) {
            if (this.elm == null) {
                this.elm = new EventManager(this);
            }
            this.elm.addListener(numberListener);
        }
    }

    public void removeListener(NumberListener numberListener) {
        if (this.elm != null) {
            this.elm.removeListener(numberListener);
        }
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            NumberListener numberListener = (NumberListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    numberListener.numberChanged((NumberEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    protected void fireNumberChanged() {
        if (this.elm != null) {
            this.elm.dispatchEvent(new NumberEvent(this, 0, System.currentTimeMillis(), this.value, false));
        }
    }

    private static class NumberTransferable
    implements Transferable {
        private final Number n;
        private final JFormattedTextField.AbstractFormatter f;

        protected NumberTransferable(Number number, JFormattedTextField.AbstractFormatter abstractFormatter) {
            this.n = number;
            this.f = abstractFormatter;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < supportedFlavors.length; ++i) {
                if (!supportedFlavors[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.n == null) {
                throw new IOException();
            }
            if (dataFlavor.equals(numberFlavor)) {
                return this.n;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                try {
                    return this.f.valueToString(this.n);
                }
                catch (ParseException parseException) {
                    throw new IOException(parseException.getLocalizedMessage());
                }
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    private class NumberTransferHandler
    extends TransferHandler {
        protected NumberTransferHandler() {
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            Number number = null;
            try {
                if (transferable.isDataFlavorSupported(numberFlavor)) {
                    number = (Number)transferable.getTransferData(numberFlavor);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    number = (Number)NumberField.this.getFormatter().stringToValue((String)transferable.getTransferData(DataFlavor.stringFlavor));
                }
                if (number != null) {
                    NumberField.this.setNumber(number);
                    NumberField.this.fireNumberChanged();
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return new NumberTransferable(NumberField.this.getNumber(), NumberField.this.getFormatter());
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                for (int j = 0; j < supportedFlavors.length; ++j) {
                    if (!dataFlavorArray[i].equals(supportedFlavors[j])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

