/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.ComboBoxEditor;
import de.sciss.gui.DefaultUnitViewFactory;
import de.sciss.gui.Jog;
import de.sciss.gui.NumberEvent;
import de.sciss.gui.NumberField;
import de.sciss.gui.NumberListener;
import de.sciss.gui.StringItem;
import de.sciss.gui.UnitLabel;
import de.sciss.util.DefaultUnitTranslator;
import de.sciss.util.Param;
import de.sciss.util.ParamSpace;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class ParamField
extends JPanel
implements PropertyChangeListener,
EventManager.Processor,
ComboBoxEditor {
    private final Jog ggJog;
    protected final NumberField ggNumber;
    protected final UnitLabel lbUnit;
    private static final UnitViewFactory uvf = new DefaultUnitViewFactory();
    private ParamSpace.Translator ut;
    protected final List collSpaces = new ArrayList();
    protected ParamSpace currentSpace = null;
    private EventManager elm = null;
    private boolean comboGate = true;

    public ParamField() {
        this(new DefaultUnitTranslator());
    }

    public ParamField(ParamSpace.Translator translator) {
        this.ut = translator;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.ggJog = new Jog();
        this.ggNumber = new NumberField();
        this.lbUnit = new UnitLabel();
        this.ggJog.addListener(new NumberListener(){

            @Override
            public void numberChanged(NumberEvent numberEvent) {
                if (ParamField.this.currentSpace != null) {
                    boolean bl;
                    double d = numberEvent.getNumber().doubleValue() * ParamField.this.currentSpace.inc;
                    Number number = ParamField.this.ggNumber.getNumber();
                    Number number2 = ParamField.this.currentSpace.isInteger() ? (Number)((long)ParamField.this.currentSpace.fitValue((double)number.longValue() + d)) : (Number)ParamField.this.currentSpace.fitValue(number.doubleValue() + d);
                    boolean bl2 = bl = !((Object)number2).equals(number);
                    if (bl) {
                        ParamField.this.ggNumber.setNumber(number2);
                    }
                    if (bl || !numberEvent.isAdjusting()) {
                        ParamField.this.fireValueChanged(numberEvent.isAdjusting());
                    }
                }
            }
        });
        this.ggNumber.addListener(new NumberListener(){

            @Override
            public void numberChanged(NumberEvent numberEvent) {
                ParamField.this.fireValueChanged(numberEvent.isAdjusting());
            }
        });
        this.lbUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParamField.this.selectSpace(ParamField.this.lbUnit.getSelectedIndex());
                ParamField.this.fireSpaceChanged();
                ParamField.this.fireValueChanged(false);
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.ggJog, gridBagConstraints);
        this.ggJog.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add(this.ggJog);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.ggNumber, gridBagConstraints);
        this.add(this.ggNumber);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.lbUnit, gridBagConstraints);
        this.lbUnit.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.add(this.lbUnit);
        this.addPropertyChangeListener("font", this);
        this.addPropertyChangeListener("enabled", this);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.ggNumber.requestFocusInWindow();
    }

    public void addSpace(ParamSpace paramSpace) {
        this.collSpaces.add(paramSpace);
        Object object = uvf.createView(paramSpace.unit);
        if (object instanceof Icon) {
            this.lbUnit.addUnit((Icon)object);
        } else {
            this.lbUnit.addUnit(object.toString());
        }
        if (this.collSpaces.size() == 1) {
            this.currentSpace = paramSpace;
            this.ggNumber.setSpace(paramSpace);
        }
    }

    public Param getValue() {
        return new Param(this.ggNumber.getNumber().doubleValue(), this.currentSpace == null ? 0 : this.currentSpace.unit);
    }

    public void setValue(Param param) {
        Number number = this.ggNumber.getNumber();
        Param param2 = this.ut.translate(param, this.currentSpace);
        Number number2 = this.currentSpace.isInteger() ? (Number)((long)param2.val) : (Number)param2.val;
        if (!number2.equals(number)) {
            this.ggNumber.setNumber(number2);
        }
    }

    public void setValueAndSpace(Param param) {
        int n;
        ParamSpace paramSpace = this.currentSpace;
        boolean bl = false;
        for (n = 0; n < this.collSpaces.size(); ++n) {
            paramSpace = (ParamSpace)this.collSpaces.get(n);
            if (paramSpace == this.currentSpace || paramSpace.unit != param.unit) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.currentSpace = paramSpace;
            this.ggNumber.setSpace(this.currentSpace);
            this.ggNumber.setFlags(this.currentSpace.unit & 0xF0000);
            if (n != this.lbUnit.getSelectedIndex()) {
                this.lbUnit.setSelectedIndex(n);
            }
        }
        this.setValue(param);
        if (bl) {
            this.fireSpaceChanged();
        }
    }

    public ParamSpace getSpace() {
        return this.currentSpace;
    }

    public void setSpace(ParamSpace paramSpace) {
        for (int i = 0; i < this.collSpaces.size(); ++i) {
            if (paramSpace != this.collSpaces.get(i)) continue;
            this.selectSpace(i);
            return;
        }
        throw new IllegalArgumentException("Illegal space switch " + paramSpace);
    }

    public void setCycling(boolean bl) {
        this.lbUnit.setCycling(bl);
    }

    public boolean getCycling() {
        return this.lbUnit.getCycling();
    }

    public ParamSpace.Translator getTranslator() {
        return this.ut;
    }

    public void setTranslator(ParamSpace.Translator translator) {
        this.ut = translator;
    }

    protected void selectSpace(int n) {
        if (n >= 0 && n < this.collSpaces.size()) {
            ParamSpace paramSpace = this.currentSpace;
            this.currentSpace = (ParamSpace)this.collSpaces.get(n);
            Number number = this.ggNumber.getNumber();
            Param param = new Param(number == null ? (paramSpace == null ? 0.0 : paramSpace.reset) : number.doubleValue(), paramSpace == null ? 0 : paramSpace.unit);
            Param param2 = this.ut.translate(param, this.currentSpace);
            Number number2 = this.currentSpace.isInteger() ? (Number)((long)param2.val) : (Number)param2.val;
            this.ggNumber.setSpace(this.currentSpace);
            this.ggNumber.setFlags(this.currentSpace.unit & 0xF0000);
            if (!number2.equals(number)) {
                this.ggNumber.setNumber(number2);
            }
            if (n != this.lbUnit.getSelectedIndex()) {
                this.lbUnit.setSelectedIndex(n);
            }
        } else {
            this.currentSpace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        ParamField paramField = this;
        synchronized (paramField) {
            if (this.elm == null) {
                this.elm = new EventManager(this);
            }
            this.elm.addListener(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (this.elm != null) {
            this.elm.removeListener(listener);
        }
    }

    @Override
    public void processEvent(BasicEvent basicEvent) {
        block4: for (int i = 0; i < this.elm.countListeners(); ++i) {
            Listener listener = (Listener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    listener.paramValueChanged((Event)basicEvent);
                    continue block4;
                }
                case 1: {
                    listener.paramSpaceChanged((Event)basicEvent);
                    continue block4;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block4;
                }
            }
        }
    }

    protected void fireValueChanged(boolean bl) {
        if (this.elm != null) {
            this.elm.dispatchEvent(new Event(this, 0, System.currentTimeMillis(), this.getValue(), this.getSpace(), this.getTranslator(), bl));
        }
    }

    protected void fireSpaceChanged() {
        if (this.elm != null) {
            this.elm.dispatchEvent(new Event(this, 1, System.currentTimeMillis(), this.getValue(), this.getSpace(), this.getTranslator(), false));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("font")) {
            Font font = this.getFont();
            this.ggNumber.setFont(font);
            this.lbUnit.setFont(font);
        } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            boolean bl = this.isEnabled();
            this.ggJog.setEnabled(bl);
            this.ggNumber.setEnabled(bl);
            this.lbUnit.setEnabled(bl);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void setComboGate(boolean bl) {
        this.comboGate = bl;
    }

    protected boolean getComboGate() {
        return this.comboGate;
    }

    @Override
    public void setItem(Object object) {
        if (!this.comboGate || object == null) {
            return;
        }
        if (object instanceof Param) {
            this.setValue((Param)object);
        } else if (object instanceof StringItem) {
            this.setValue(Param.valueOf(((StringItem)object).getKey()));
        }
    }

    @Override
    public Object getItem() {
        Action action = this.lbUnit.getSelectedUnit();
        String string = action == null ? null : (String)action.getValue("Name");
        return new StringItem(this.getValue().toString(), string == null ? this.ggNumber.getText() : this.ggNumber.getText() + " " + string);
    }

    @Override
    public void selectAll() {
        this.ggNumber.requestFocus();
        this.ggNumber.selectAll();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.ggNumber.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.ggNumber.removeActionListener(actionListener);
    }

    public static interface Listener
    extends EventListener {
        public void paramValueChanged(Event var1);

        public void paramSpaceChanged(Event var1);
    }

    public static class Event
    extends BasicEvent {
        public static final int VALUE = 0;
        public static final int SPACE = 1;
        private final Param value;
        private final ParamSpace space;
        private final ParamSpace.Translator ut;
        private final boolean adjusting;

        public Event(Object object, int n, long l, Param param, ParamSpace paramSpace, ParamSpace.Translator translator, boolean bl) {
            super(object, n, l);
            this.value = param;
            this.space = paramSpace;
            this.ut = translator;
            this.adjusting = bl;
        }

        public boolean isAdjusting() {
            return this.adjusting;
        }

        public Param getValue() {
            return this.value;
        }

        public Param getTranslatedValue(ParamSpace paramSpace) {
            return this.ut.translate(this.value, paramSpace);
        }

        public ParamSpace getSpace() {
            return this.space;
        }

        @Override
        public boolean incorporate(BasicEvent basicEvent) {
            return basicEvent instanceof Event && this.getSource() == basicEvent.getSource() && this.getID() == basicEvent.getID();
        }
    }

    public static interface UnitViewFactory {
        public Object createView(int var1);
    }
}

