/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class PeakMeterCaption
extends JComponent
implements SwingConstants,
PropertyChangeListener {
    private static final float[] MAJOR_TICKS = new float[]{0.0f, 0.05f, 0.15f, 0.225f, 0.3f, 0.4f, 0.5f, 0.625f, 0.75f, 0.875f, 1.0f};
    private static final String[] LABELS = new String[]{"60", "50", "40", "35", "30", "25", "20", "15", "10", "5", "0"};
    private static final Stroke strkMajorTicks = new BasicStroke(1.0f);
    private static final Stroke strkMinorTicks = new BasicStroke(0.5f);
    private static final float MAJOR_W = 5.25f;
    private static final float MINOR_W = 3.5f;
    private int hAlign = 4;
    private boolean paintLabels = true;
    private int recentWidth = -1;
    private int recentHeight = -1;
    private Shape shpMajorTicks;
    private Shape shpMinorTicks;
    private Shape shpLabels;
    private int ascent;
    private int descent;
    private int labW;
    private int ticks = 0;
    private boolean vertical;

    public PeakMeterCaption() {
        this(1);
    }

    public PeakMeterCaption(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.vertical = n == 1;
        this.setPreferredSize(new Dimension(20, 20));
        this.setOpaque(true);
        this.setFont(new Font("SansSerif", 0, 12));
        this.recalcPrefSize();
        this.addPropertyChangeListener("border", this);
        this.addPropertyChangeListener("font", this);
    }

    public void setOrientation(int n) {
        boolean bl;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        boolean bl2 = bl = n == 1;
        if (bl != this.vertical) {
            this.vertical = bl;
        }
    }

    public void setTicks(int n) {
        this.ticks = n;
        this.recalcPrefSize();
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    private void recalcPrefSize() {
        Insets insets = this.getInsets();
        if (this.paintLabels) {
            Font font = this.getFont();
            Window window = SwingUtilities.getWindowAncestor(this);
            GraphicsConfiguration graphicsConfiguration = window != null ? window.getGraphicsConfiguration() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            FontRenderContext fontRenderContext = new FontRenderContext(graphicsConfiguration.getNormalizingTransform(), true, true);
            this.labW = 0;
            float f = 0.0f;
            for (int i = 0; i < LABELS.length; ++i) {
                Rectangle2D rectangle2D = font.createGlyphVector(fontRenderContext, LABELS[i]).getLogicalBounds();
                this.labW = Math.max(this.labW, (int)(rectangle2D.getWidth() + 0.5));
                f = Math.max(f, (float)rectangle2D.getHeight());
            }
            this.labW += 2;
            this.descent = this.ascent = (int)(f / 2.0f);
        } else {
            this.labW = 0;
            this.ascent = 0;
            this.descent = 0;
        }
        Dimension dimension = new Dimension(this.labW + (this.hAlign == 0 ? 12 : 5) + insets.left + insets.right, this.ticks <= 0 ? this.getPreferredSize().height : this.ticks * 2 - 1 + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
        this.setMinimumSize(new Dimension(dimension.width, 2 + insets.top + insets.bottom));
        this.setMaximumSize(new Dimension(dimension.width, this.getMaximumSize().height));
    }

    public void setHorizontalAlignment(int n) {
        if (this.hAlign == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.hAlign = n;
        this.recentHeight = -1;
        this.recalcPrefSize();
        this.repaint();
    }

    public void setPaintLabels(boolean bl) {
        if (this.paintLabels != bl) {
            this.paintLabels = bl;
            this.recentHeight = -1;
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.recentHeight = -1;
        this.recalcPrefSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.white);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (n != this.recentWidth || n2 != this.recentHeight) {
            int n3;
            float f;
            this.recentWidth = n;
            this.recentHeight = n2;
            switch (this.hAlign) {
                case 2: {
                    f = 0.0f;
                    n3 = 8;
                    break;
                }
                case 0: {
                    f = 0.5f;
                    n3 = 8;
                    break;
                }
                case 4: {
                    f = 1.0f;
                    n3 = 0;
                    break;
                }
                default: {
                    assert (false) : this.hAlign;
                    f = 0.0f;
                    n3 = 0;
                }
            }
            AffineTransform affineTransform = new AffineTransform();
            Insets insets = this.getInsets();
            int n4 = n - (insets.left + insets.right);
            int n5 = n2 - (insets.top + insets.bottom + this.ascent + this.descent);
            int n6 = n5 - 1;
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath();
            affineTransform.translate(insets.left, insets.top + this.ascent);
            for (int i = 0; i < (this.hAlign == 0 ? 2 : 1); ++i) {
                int n7;
                float f2 = this.hAlign == 0 ? (i == 0 ? 0.0f : 1.0f) : f;
                float f3 = ((float)n4 - 5.25f) * f2;
                float f4 = ((float)n4 - 3.5f) * f2;
                for (n7 = 0; n7 < MAJOR_TICKS.length; ++n7) {
                    generalPath.moveTo(f3, (1.0f - MAJOR_TICKS[n7]) * (float)n6);
                    generalPath.lineTo(f3 + 5.25f, (1.0f - MAJOR_TICKS[n7]) * (float)n6);
                }
                for (n7 = 0; n7 < 20; ++n7) {
                    if (n7 % 5 == 0) continue;
                    generalPath2.moveTo(f4, (float)n7 * 0.025f * (float)n6);
                    generalPath2.lineTo(f4 + 3.5f, (float)n7 * 0.025f * (float)n6);
                }
            }
            this.shpMajorTicks = affineTransform.createTransformedShape(generalPath);
            this.shpMinorTicks = affineTransform.createTransformedShape(generalPath2);
            if (this.paintLabels) {
                int n8;
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                GeneralPath generalPath3 = new GeneralPath();
                double d = (double)(n5 - 1) * 0.004;
                GlyphVector[] glyphVectorArray = new GlyphVector[LABELS.length];
                Rectangle2D[] rectangle2DArray = new Rectangle2D[LABELS.length];
                Font font = this.getFont();
                float f5 = 0.0f;
                for (n8 = 0; n8 < LABELS.length; ++n8) {
                    glyphVectorArray[n8] = font.createGlyphVector(fontRenderContext, LABELS[n8]);
                    rectangle2DArray[n8] = glyphVectorArray[n8].getLogicalBounds();
                    f5 = Math.max(f5, (float)rectangle2DArray[n8].getWidth());
                }
                for (n8 = 0; n8 < glyphVectorArray.length; ++n8) {
                    generalPath3.append(glyphVectorArray[n8].getOutline((f5 - (float)rectangle2DArray[n8].getWidth()) * f + 1.5f, (1.0f - MAJOR_TICKS[n8]) * 250.0f - (float)rectangle2DArray[n8].getCenterY()), false);
                }
                affineTransform.setToTranslation(insets.left + n3, insets.top + this.ascent);
                affineTransform.scale(d, d);
                this.shpLabels = affineTransform.createTransformedShape(generalPath3);
            }
        }
        graphics2D.setStroke(strkMajorTicks);
        graphics2D.draw(this.shpMajorTicks);
        graphics2D.setStroke(strkMinorTicks);
        graphics2D.draw(this.shpMinorTicks);
        if (this.paintLabels) {
            graphics2D.fill(this.shpLabels);
        }
    }
}

