/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.PeakMeterView;

public class PeakMeterGroup
implements PeakMeterView {
    private final PeakMeterView[] views;
    private final int numChannels;

    public PeakMeterGroup(PeakMeterView[] peakMeterViewArray) {
        this.views = peakMeterViewArray;
        int n = 0;
        for (int i = 0; i < peakMeterViewArray.length; ++i) {
            n += peakMeterViewArray[i].getNumChannels();
        }
        this.numChannels = n;
    }

    @Override
    public int getNumChannels() {
        return this.numChannels;
    }

    @Override
    public boolean meterUpdate(float[] fArray, int n, long l) {
        int n2 = 0;
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i].meterUpdate(fArray, n, l)) {
                ++n2;
            }
            n += this.views[i].getNumChannels() << 1;
        }
        return n2 > 0;
    }

    @Override
    public void clearMeter() {
        for (int i = 0; i < this.views.length; ++i) {
            this.views[i].clearMeter();
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.views.length; ++i) {
            this.views[i].dispose();
        }
    }
}

