/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBox;

public class PrefCheckBox
extends JCheckBox
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private ActionListener listener;
    private boolean defaultValue;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefCheckBox() {
        this.init();
    }

    public PrefCheckBox(String string) {
        super(string);
        this.init();
    }

    public PrefCheckBox(Action action) {
        super(action);
        this.init();
    }

    private void init() {
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrefCheckBox.this.writePrefs) {
                    PrefCheckBox.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addActionListener(this.listener);
                } else {
                    this.removeActionListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void writePrefs() {
        boolean bl;
        boolean bl2;
        if (this.prefs != null && this.key != null && (bl2 = this.prefs.getBoolean(this.key, !(bl = this.isSelected()))) != bl) {
            this.prefs.putBoolean(this.key, bl);
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            this.defaultValue = this.isSelected();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addActionListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        if (string == null) {
            this.setSelected(this.defaultValue);
            if (this.writePrefs) {
                this.writePrefs();
            }
            return;
        }
        boolean bl = this.isSelected();
        boolean bl2 = new Boolean(string);
        if (bl2 != bl) {
            if (this.listening && this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.doClick();
            if (this.listening && this.writePrefs) {
                this.addActionListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

