/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.StringItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;

public class PrefComboBox
extends JComboBox
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private ActionListener listener;
    private Object defaultValue = null;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefComboBox() {
        this.init();
    }

    private void init() {
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrefComboBox.this.writePrefs) {
                    PrefComboBox.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addActionListener(this.listener);
                } else {
                    this.removeActionListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    public void addItem(Object object) {
        super.addItem(this.validateItem(object));
    }

    public void insertItemAt(Object object, int n) {
        super.insertItemAt(this.validateItem(object), n);
    }

    private Object validateItem(Object object) {
        if (!(object instanceof StringItem)) {
            object = new StringItem(object.toString(), object.toString());
        }
        return object;
    }

    @Override
    public void writePrefs() {
        String string = null;
        if (this.prefs != null && this.key != null) {
            Object object = this.getSelectedItem();
            if (object != null && object instanceof StringItem) {
                string = ((StringItem)object).getKey();
            }
            String string2 = this.prefs.get(this.key, null);
            if (string != null && string2 == null || string != null && !string.equals(string2)) {
                this.prefs.put(this.key, string);
            } else if (string == null && string2 != null) {
                this.prefs.remove(this.key);
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            this.defaultValue = this.getSelectedItem();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addActionListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        if (string == null && this.defaultValue != null) {
            if (this.listening && this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.setSelectedItem(this.defaultValue);
            if (this.writePrefs) {
                this.writePrefs();
            }
            if (this.listening && this.writePrefs) {
                this.addActionListener(this.listener);
            }
            return;
        }
        Object object = this.getSelectedItem();
        String string2 = null;
        Object object2 = null;
        if (object != null && object instanceof StringItem) {
            string2 = ((StringItem)object).getKey();
        }
        if (string == null && string2 != null) {
            if (this.listening && this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            super.setSelectedItem(null);
            if (this.listening && this.writePrefs) {
                this.addActionListener(this.listener);
            }
        } else if (string != null && string2 == null || string != null && !string.equals(string2)) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                object = this.getItemAt(i);
                if (object == null || !((StringItem)object).getKey().equals(string)) continue;
                object2 = object;
                break;
            }
            if (this.listening && this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            super.setSelectedItem(object2);
            if (this.listening && this.writePrefs) {
                this.addActionListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

