/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathField;
import de.sciss.gui.PathListener;
import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PrefPathField
extends PathField
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private PathListener listener;
    private File defaultValue = null;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefPathField(int n, String string) {
        super(n, string);
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new PathListener(){

            @Override
            public void pathChanged(PathEvent pathEvent) {
                if (PrefPathField.this.writePrefs) {
                    PrefPathField.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addPathListener(this.listener);
                } else {
                    this.removePathListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void setPath(File file) {
        super.setPath(file);
        if (this.writePrefs) {
            this.writePrefs();
        }
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            String string = this.prefs.get(this.key, "");
            File file = new File(string);
            File file2 = this.getPath();
            if (!file2.equals(file)) {
                this.prefs.put(this.key, file2.getPath());
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key != null) {
            this.defaultValue = this.getPath();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addPathListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removePathListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        if (string == null) {
            if (this.defaultValue != null) {
                this.setPath(this.defaultValue);
                if (this.writePrefs) {
                    this.writePrefs();
                }
            }
            return;
        }
        File file = new File(string);
        if (!file.equals(this.getPath())) {
            if (this.listening && this.writePrefs) {
                this.removePathListener(this.listener);
            }
            this.setPathAndDispatchEvent(file);
            if (this.listening && this.writePrefs) {
                this.addPathListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

