/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.ComboBoxEditor;
import de.sciss.gui.StringItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;

public class PrefRecentItemsCombo
extends JComboBox
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    protected final ComboBoxEditor editor;
    protected final int maxItems;
    private ActionListener listener;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefRecentItemsCombo(ComboBoxEditor comboBoxEditor, int n) {
        this.editor = comboBoxEditor;
        this.maxItems = n;
        this.init();
    }

    private void init() {
        this.setEditor(this.editor);
        this.setEditable(true);
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = PrefRecentItemsCombo.this.editor.getItem();
                for (int i = 0; i < PrefRecentItemsCombo.this.getItemCount(); ++i) {
                    if (!PrefRecentItemsCombo.this.getItemAt(i).equals(object)) continue;
                    if (PrefRecentItemsCombo.this.getSelectedIndex() != i) {
                        PrefRecentItemsCombo.this.setSelectedIndex(i);
                    }
                    return;
                }
                PrefRecentItemsCombo.this.addItem(object);
                PrefRecentItemsCombo.this.setSelectedIndex(PrefRecentItemsCombo.this.getItemCount() - 1);
                if (PrefRecentItemsCombo.this.getItemCount() > PrefRecentItemsCombo.this.maxItems) {
                    PrefRecentItemsCombo.this.removeItemAt(0);
                }
                if (PrefRecentItemsCombo.this.writePrefs) {
                    PrefRecentItemsCombo.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addActionListener(this.listener);
                } else {
                    this.removeActionListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getItemCount(); ++i) {
                Object e = this.getItemAt(i);
                String string = e.toString();
                stringBuffer.append(string.length());
                if (e instanceof StringItem) {
                    stringBuffer.append(";key=");
                    stringBuffer.append(((StringItem)e).getKey());
                }
                stringBuffer.append(";val=");
                stringBuffer.append(string);
                stringBuffer.append(';');
            }
            String string = stringBuffer.toString();
            String string2 = this.prefs.get(this.key, null);
            if (string != null && string2 == null || string != null && !string.equals(string2)) {
                this.prefs.put(this.key, string);
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            // empty if block
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.editor.addActionListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.editor.removeActionListener(this.listener);
            }
            this.listening = false;
        }
    }

    private void printParseError(String string) {
        System.err.println("Warning: for key '" + this.key + "' illegal prefs value '" + string + "'");
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        int n;
        int n2;
        ArrayList<Object> arrayList;
        block13: {
            arrayList = new ArrayList<Object>();
            if (this.listening && this.writePrefs) {
                this.editor.removeActionListener(this.listener);
            }
            try {
                n2 = 0;
                while (n2 < string.length()) {
                    String string2 = null;
                    n = string.indexOf(59, n2);
                    int n3 = Integer.parseInt(string.substring(n2, n));
                    n2 = n + 1;
                    n = n2 + 4;
                    String string3 = string.substring(n2, n);
                    n2 = n;
                    if (string3.equals("key=")) {
                        n = string.indexOf(59, n2);
                        string2 = string.substring(n2, n);
                        n2 = n + 1;
                        n = n2 + 4;
                        string3 = string.substring(n2, n);
                        n2 = n;
                    }
                    if (!string3.equals("val=")) {
                        this.printParseError(string);
                        return;
                    }
                    string3 = string.substring(n2, n2 + n3);
                    n2 = n2 + n3 + 1;
                    if (string2 == null) {
                        arrayList.add(string3);
                        continue;
                    }
                    arrayList.add(new StringItem(string2, string3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.printParseError(string);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.printParseError(string);
                return;
            }
            if (arrayList.size() == this.getItemCount()) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (arrayList.get(n2).equals(this.getItemAt(n2))) {
                        continue;
                    }
                    break block13;
                }
                return;
            }
        }
        Object object = this.editor.getItem();
        this.editor.setComboGate(false);
        this.removeAllItems();
        n = -1;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object e = arrayList.get(n2);
            this.addItem(e);
            if (!e.equals(object)) continue;
            n = n2;
        }
        this.setSelectedIndex(n);
        this.editor.setComboGate(true);
        if (this.listening && this.writePrefs) {
            this.editor.addActionListener(this.listener);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }
}

