/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.DynamicAncestorAdapter;
import de.sciss.app.DynamicListening;
import de.sciss.app.LaterInvocationManager;
import de.sciss.app.PreferenceEntrySync;
import de.sciss.gui.ComboBoxEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JTextField;

public class PrefTextField
extends JTextField
implements DynamicListening,
PreferenceChangeListener,
LaterInvocationManager.Listener,
PreferenceEntrySync,
ComboBoxEditor {
    private boolean listening = false;
    private Preferences prefs = null;
    private String key = null;
    private final LaterInvocationManager lim = new LaterInvocationManager(this);
    private ActionListener listener;
    private String defaultValue = null;
    private boolean comboGate = true;
    private boolean readPrefs = true;
    protected boolean writePrefs = true;

    public PrefTextField() {
        this.init();
    }

    public PrefTextField(String string) {
        super(string);
        this.init();
    }

    public PrefTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public PrefTextField(int n) {
        super(n);
        this.init();
    }

    private void init() {
        new DynamicAncestorAdapter(this).addTo(this);
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrefTextField.this.writePrefs) {
                    PrefTextField.this.writePrefs();
                }
            }
        };
    }

    @Override
    public void setReadPrefs(boolean bl) {
        if (bl != this.readPrefs) {
            this.readPrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.readPrefs) {
                    this.prefs.addPreferenceChangeListener(this);
                } else {
                    this.prefs.removePreferenceChangeListener(this);
                }
            }
        }
    }

    @Override
    public boolean getReadPrefs() {
        return this.readPrefs;
    }

    @Override
    public void setWritePrefs(boolean bl) {
        if (bl != this.writePrefs) {
            this.writePrefs = bl;
            if (this.prefs != null && this.listening) {
                if (this.writePrefs) {
                    this.addActionListener(this.listener);
                } else {
                    this.removeActionListener(this.listener);
                }
            }
        }
    }

    @Override
    public boolean getWritePrefs() {
        return this.writePrefs;
    }

    @Override
    public void writePrefs() {
        if (this.prefs != null && this.key != null) {
            String string = this.prefs.get(this.key, null);
            String string2 = this.getText();
            if (string == null && string2 != null || string != null && string2 == null || string != null && string2 != null && !string.equals(string2)) {
                this.prefs.put(this.key, string2);
            }
        }
    }

    @Override
    public void setPreferenceNode(Preferences preferences) {
        this.setPreferences(preferences, this.key);
    }

    @Override
    public void setPreferenceKey(String string) {
        this.setPreferences(this.prefs, string);
    }

    @Override
    public void setPreferences(Preferences preferences, String string) {
        if (this.prefs == null || this.key == null) {
            this.defaultValue = this.getText();
        }
        if (this.listening) {
            this.stopListening();
            this.prefs = preferences;
            this.key = string;
            this.startListening();
        } else {
            this.prefs = preferences;
            this.key = string;
        }
    }

    @Override
    public Preferences getPreferenceNode() {
        return this.prefs;
    }

    @Override
    public String getPreferenceKey() {
        return this.key;
    }

    @Override
    public void startListening() {
        if (this.prefs != null) {
            this.listening = true;
            if (this.writePrefs) {
                this.addActionListener(this.listener);
            }
            if (this.readPrefs) {
                this.prefs.addPreferenceChangeListener(this);
                this.readPrefs();
            }
        }
    }

    @Override
    public void stopListening() {
        if (this.prefs != null) {
            if (this.readPrefs) {
                this.prefs.removePreferenceChangeListener(this);
            }
            if (this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.listening = false;
        }
    }

    @Override
    public void laterInvocation(Object object) {
        String string = ((PreferenceChangeEvent)object).getNewValue();
        this.readPrefsFromString(string);
    }

    @Override
    public void readPrefs() {
        if (this.prefs != null && this.key != null) {
            this.readPrefsFromString(this.prefs.get(this.key, null));
        }
    }

    private void readPrefsFromString(String string) {
        if (string == null) {
            if (this.defaultValue != null) {
                this.setText(this.defaultValue);
                if (this.writePrefs) {
                    this.writePrefs();
                }
            }
            return;
        }
        String string2 = this.getText();
        if (string2 == null || !string.equals(string2)) {
            if (this.listening && this.writePrefs) {
                this.removeActionListener(this.listener);
            }
            this.setText(string);
            this.fireActionPerformed();
            if (this.listening && this.writePrefs) {
                this.addActionListener(this.listener);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.lim.queue(preferenceChangeEvent);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void setComboGate(boolean bl) {
        this.comboGate = bl;
    }

    @Override
    public void setItem(Object object) {
        if (!this.comboGate || object == null) {
            return;
        }
        this.setText(object.toString());
        if (this.writePrefs) {
            this.writePrefs();
        }
    }

    @Override
    public Object getItem() {
        return this.getText();
    }
}

