/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortedTableModel
extends AbstractTableModel {
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static final Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator STRING_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    public static final Comparator STRING_COMPARATOR_UPCASE = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().toUpperCase().compareTo(object2.toString().toUpperCase());
        }
    };
    private Row[] viewToModel;
    protected int[] modelToView;
    private JTableHeader tableHeader;
    private final MouseListener mouseListener;
    private final TableModelListener tableModelListener;
    private Map mapComparators = new HashMap();
    protected List collSorted = new ArrayList();
    protected Set setDisallowedColumns = new HashSet();
    private final Icon[] icnArrow = new Icon[3];

    public SortedTableModel() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
        this.icnArrow[0] = new ArrowIcon(-1);
        this.icnArrow[1] = new ArrowIcon(0);
        this.icnArrow[2] = new ArrowIcon(1);
        this.mapComparators.put(String.class, STRING_COMPARATOR_UPCASE);
    }

    public SortedTableModel(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public SortedTableModel(TableModel tableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.collSorted.size() != 0;
    }

    public int getSortedColumnIndex() {
        if (this.collSorted.isEmpty()) {
            return -1;
        }
        return ((Directive)this.collSorted.get((int)0)).column;
    }

    public int getSortedColumnDirection() {
        if (this.collSorted.isEmpty()) {
            return 0;
        }
        return ((Directive)this.collSorted.get((int)0)).direction;
    }

    public void setSortedColumn(int n, int n2) {
        this.collSorted.clear();
        if (n2 != 0) {
            this.collSorted.add(new Directive(n, n2));
        }
        this.sortingStatusChanged();
    }

    public void cancelSorting() {
        this.collSorted.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.mapComparators.remove(clazz);
        } else {
            this.mapComparators.put(clazz, comparator);
        }
    }

    public void setSortingAllowed(int n, boolean bl) {
        Integer n2 = new Integer(n);
        if (bl) {
            this.setDisallowedColumns.remove(n2);
        } else {
            this.setDisallowedColumns.add(n2);
        }
    }

    public boolean getSortingAllowed(int n) {
        return !this.setDisallowedColumns.contains(new Integer(n));
    }

    public int getModelIndex(int n) {
        return this.getViewToModel()[n].modelIndex;
    }

    public int getViewIndex(int n) {
        return this.getModelToView()[n];
    }

    protected int getSortingStatus(int n) {
        return this.getDirective((int)n).direction;
    }

    protected void setSortingStatus(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive != EMPTY_DIRECTIVE) {
            this.collSorted.remove(directive);
        }
        if (n2 != 0) {
            this.collSorted.add(new Directive(n, n2));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n) {
        return this.icnArrow[this.getDirective((int)n).direction + 1];
    }

    protected Comparator getComparator(int n) {
        Class<?> clazz = this.tableModel.getColumnClass(n);
        Comparator comparator = (Comparator)this.mapComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return STRING_COMPARATOR;
    }

    protected void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    private Directive getDirective(int n) {
        for (int i = 0; i < this.collSorted.size(); ++i) {
            Directive directive = (Directive)this.collSorted.get(i);
            if (directive.column != n) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n = this.tableModel.getRowCount();
            this.viewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.viewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    protected int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.getModelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(this.getModelIndex(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableModel.getValueAt(this.getModelIndex(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.getModelIndex(n), n2);
    }

    private static class Directive {
        protected final int column;
        protected final int direction;

        public Directive(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        protected final TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setHorizontalTextPosition(2);
                jLabel.setIcon(SortedTableModel.this.getHeaderRendererIcon(n3));
            }
            return component;
        }
    }

    private static class ArrowIcon
    implements Icon {
        private static final Color colrBg = new Color(112, 112, 112, 240);
        private static final GeneralPath shpUpTri = new GeneralPath();
        private static final GeneralPath shpDownTri;
        private final Shape shp;

        public ArrowIcon(int n) {
            switch (n) {
                case 1: {
                    this.shp = shpUpTri;
                    break;
                }
                case -1: {
                    this.shp = shpDownTri;
                    break;
                }
                case 0: {
                    this.shp = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(n));
                }
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.shp == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(n, n2);
            graphics2D.setColor(colrBg);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(this.shp);
            graphics2D.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        static {
            shpUpTri.moveTo(0.0f, 7.0f);
            shpUpTri.lineTo(3.5f, 0.0f);
            shpUpTri.lineTo(7.0f, 7.0f);
            shpUpTri.closePath();
            shpDownTri = new GeneralPath();
            shpDownTri.moveTo(0.0f, 0.0f);
            shpDownTri.lineTo(3.5f, 7.0f);
            shpDownTri.lineTo(7.0f, 0.0f);
            shpDownTri.closePath();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1 && !SortedTableModel.this.setDisallowedColumns.contains(new Integer(n2))) {
                int n3 = SortedTableModel.this.getSortingStatus(n2);
                SortedTableModel.this.cancelSorting();
                n3 = n3 == 1 ? -1 : 1;
                SortedTableModel.this.setSortingStatus(n2, n3);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        protected TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!SortedTableModel.this.isSorting()) {
                SortedTableModel.this.clearSortingState();
                SortedTableModel.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                SortedTableModel.this.cancelSorting();
                SortedTableModel.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && SortedTableModel.this.getSortingStatus(n) == 0 && SortedTableModel.this.modelToView != null) {
                int n2 = SortedTableModel.this.getModelToView()[tableModelEvent.getFirstRow()];
                SortedTableModel.this.fireTableChanged(new TableModelEvent(SortedTableModel.this, n2, n2, n, tableModelEvent.getType()));
                return;
            }
            SortedTableModel.this.clearSortingState();
            SortedTableModel.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        protected int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (Directive directive : SortedTableModel.this.collSorted) {
                int n3 = directive.column;
                Object object2 = SortedTableModel.this.tableModel.getValueAt(n, n3);
                Object object3 = SortedTableModel.this.tableModel.getValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : SortedTableModel.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return directive.direction == -1 ? -n4 : n4;
            }
            return 0;
        }
    }
}

