/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.util.Disposable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;

public class TemporaryFocusTracker
implements Disposable,
ContainerListener,
MouseListener,
FocusListener,
AncestorListener {
    private static final boolean DEBUG = false;
    private final JFrame jf;
    private Component currentFocus = null;

    public TemporaryFocusTracker(JFrame jFrame) {
        this.jf = jFrame;
        jFrame.getRootPane().addAncestorListener(this);
    }

    @Override
    public void dispose() {
        this.removeContainer(this.jf.getContentPane());
        this.jf.getRootPane().removeAncestorListener(this);
    }

    private void addContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            this.addComponent(container.getComponent(i));
        }
        container.addContainerListener(this);
    }

    private void removeContainer(Container container) {
        container.removeContainerListener(this);
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            this.removeComponent(container.getComponent(i));
        }
    }

    private void addComponent(Component component) {
        if (component instanceof JTextComponent) {
            this.addTextComponent((JTextComponent)component);
        } else if (component instanceof JPanel || component instanceof Box || component instanceof JTabbedPane) {
            this.addContainer((Container)component);
        } else if (component instanceof JScrollPane) {
            this.addScrollPane((JScrollPane)component);
        }
    }

    private void removeComponent(Component component) {
        if (component instanceof JTextComponent) {
            this.removeTextComponent((JTextComponent)component);
        } else if (component instanceof JPanel || component instanceof Box || component instanceof JTabbedPane) {
            this.removeContainer((Container)component);
        } else if (component instanceof JScrollPane) {
            this.removeScrollPane((JScrollPane)component);
        }
    }

    private void addTextComponent(JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(this);
        jTextComponent.addFocusListener(this);
    }

    private void removeTextComponent(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeFocusListener(this);
    }

    private void addScrollPane(JScrollPane jScrollPane) {
        Component component = jScrollPane.getViewport().getView();
        component.addMouseListener(this);
        component.addFocusListener(this);
    }

    private void removeScrollPane(JScrollPane jScrollPane) {
        Component component = jScrollPane.getViewport().getView();
        component.removeMouseListener(this);
        component.removeFocusListener(this);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.addComponent(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeComponent(containerEvent.getChild());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        this.jf.setFocusableWindowState(true);
        component.requestFocus();
        this.currentFocus = component;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.currentFocus) {
            this.currentFocus = null;
            this.jf.setFocusableWindowState(false);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.currentFocus = focusEvent.getComponent();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.addContainer(this.jf.getContentPane());
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.removeContainer(this.jf.getContentPane());
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }
}

