/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.gui.TimeFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.SwingConstants;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;

public class TimeFormatter
extends DefaultFormatter {
    private final DocumentFilter docFilter = new DocFilter();
    private final NavigationFilter navFilter = new NavFilter();
    private static final String sepChars = ":.";
    private static final String numChars = "0123456789";
    private TimeFormat tf = null;

    public TimeFormatter() {
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
    }

    public void setFormat(TimeFormat timeFormat) {
        this.tf = timeFormat;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        if (this.tf != null) {
            return this.tf.parseTime(string);
        }
        throw new ParseException("Format hasn't been set", 0);
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (this.tf != null) {
            return this.tf.formatTime((Number)object);
        }
        return object.toString();
    }

    @Override
    protected JFormattedTextField getFormattedTextField() {
        return super.getFormattedTextField();
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.docFilter;
    }

    @Override
    protected NavigationFilter getNavigationFilter() {
        return this.navFilter;
    }

    private static class NavFilter
    extends NavigationFilter
    implements SwingConstants {
        protected NavFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            super.setDot(filterBypass, n, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            super.moveDot(filterBypass, n, bias);
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            String string = jTextComponent.getText();
            if (n2 == 7 && n > 0 && n <= string.length()) {
                if (TimeFormatter.sepChars.indexOf(string.charAt(n - 1)) >= 0) {
                    --n;
                }
            } else if (n2 == 3 && n + 1 < string.length() && TimeFormatter.sepChars.indexOf(string.charAt(n + 1)) >= 0) {
                ++n;
            }
            return super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
        }
    }

    private class DocFilter
    extends DocumentFilter {
        protected DocFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            this.replace(filterBypass, n, string.length(), string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            String string = filterBypass.getDocument().getText(0, n + 1);
            for (int i = 0; i <= n; ++i) {
                if (TimeFormatter.sepChars.indexOf(string.charAt(i)) < 0) continue;
                return;
            }
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3;
            String string2 = TimeFormatter.this.getFormattedTextField().getText();
            for (n3 = 0; n3 < n; ++n3) {
                if (TimeFormatter.sepChars.indexOf(string2.charAt(n3)) < 0) continue;
                n2 = string.length();
                if (n + n2 <= string2.length()) break;
                return;
            }
            if (!string.equals("-") || n != 0) {
                for (n3 = 0; n3 < string.length(); ++n3) {
                    if (TimeFormatter.numChars.indexOf(string.charAt(n3)) != -1) continue;
                    return;
                }
            }
            int n4 = 0;
            int n5 = n;
            while (n4 < Math.min(string.length(), n2)) {
                n3 = string2.charAt(n5);
                char c = string.charAt(n4);
                if (TimeFormatter.sepChars.indexOf(n3) >= 0) {
                    if (TimeFormatter.sepChars.indexOf(c) == -1) {
                        this.replace(filterBypass, n + 1, n2, string, attributeSet);
                        try {
                            TimeFormatter.this.getFormattedTextField().setCaretPosition(n + 1 + n2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return;
                    }
                } else if (TimeFormatter.numChars.indexOf(c) < 0) {
                    return;
                }
                ++n4;
                ++n5;
            }
            filterBypass.replace(n, n2, string, attributeSet);
        }
    }
}

