/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import java.awt.geom.Point2D;

public class VectorSpace {
    public final double hmin;
    public final double hmax;
    public final double vmin;
    public final double vmax;
    public final boolean hlog;
    public final boolean vlog;
    private final double h0;
    private final double hoffset;
    private final double v0;
    private final double voffset;
    public final String hlabel;
    public final String hunit;
    public final String vlabel;
    public final String vunit;
    private final double hlogfactor;
    private final double vlogfactor;

    private VectorSpace(double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6, String string, String string2, String string3, String string4) {
        this.hmin = d;
        this.hmax = d2;
        this.vmin = d3;
        this.vmax = d4;
        this.hlog = bl;
        this.vlog = bl2;
        this.h0 = d5;
        this.v0 = d6;
        this.hlabel = string;
        this.hunit = string2;
        this.vlabel = string3;
        this.vunit = string4;
        this.hlogfactor = Math.log(d2 / d5);
        this.vlogfactor = Math.log(d4 / d6);
        this.hoffset = Math.log(d / d5) / this.hlogfactor;
        this.voffset = Math.log(d3 / d6) / this.vlogfactor;
    }

    public double hUnityToSpace(double d) {
        if (this.hlog) {
            return Math.exp((d * (1.0 - this.hoffset) + this.hoffset) * this.hlogfactor) * this.h0;
        }
        return this.hmin + (this.hmax - this.hmin) * d;
    }

    public double vUnityToSpace(double d) {
        if (this.vlog) {
            return Math.exp((d * (1.0 - this.voffset) + this.voffset) * this.vlogfactor) * this.v0;
        }
        return this.vmin + (this.vmax - this.vmin) * d;
    }

    public double hSpaceToUnity(double d) {
        if (this.hlog) {
            return (Math.log(d / this.h0) / this.hlogfactor - this.hoffset) / (1.0 - this.hoffset);
        }
        return (d - this.hmin) / (this.hmax - this.hmin);
    }

    public double vSpaceToUnity(double d) {
        if (this.vlog) {
            return (Math.log(d / this.v0) / this.vlogfactor - this.voffset) / (1.0 - this.voffset);
        }
        return (d - this.vmin) / (this.vmax - this.vmin);
    }

    public Point2D unityToSpace(Point2D point2D) {
        return new Point2D.Double(this.hUnityToSpace(point2D.getX()), this.vUnityToSpace(point2D.getY()));
    }

    public Point2D spaceToUnity(Point2D point2D) {
        return new Point2D.Double(this.hSpaceToUnity(point2D.getX()), this.vSpaceToUnity(point2D.getY()));
    }

    public static VectorSpace createLinSpace(double d, double d2, double d3, double d4, String string, String string2, String string3, String string4) {
        return new VectorSpace(d, d2, d3, d4, false, false, d, d3, string, string2, string3, string4);
    }

    public static VectorSpace createLogLinSpace(double d, double d2, double d3, double d4, double d5, String string, String string2, String string3, String string4) {
        double d6 = d3 * d3 / d2;
        return new VectorSpace(d, d2, d4, d5, true, false, d6, d4, string, string2, string3, string4);
    }

    public static VectorSpace createLinLogSpace(double d, double d2, double d3, double d4, double d5, String string, String string2, String string3, String string4) {
        double d6 = d5 * d5 / d4;
        return new VectorSpace(d, d2, d3, d4, false, true, d, d6, string, string2, string3, string4);
    }

    public static VectorSpace createLogSpace(double d, double d2, double d3, double d4, double d5, double d6, String string, String string2, String string3, String string4) {
        double d7 = d3 * d3 / d2;
        double d8 = d6 * d6 / d5;
        return new VectorSpace(d, d2, d4, d5, true, true, d7, d8, string, string2, string3, string4);
    }
}

