/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.gui;

import de.sciss.app.AbstractWindow;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class WindowListenerWrapper
implements WindowListener {
    private final AbstractWindow.Listener l;
    private final AbstractWindow w;

    private WindowListenerWrapper(AbstractWindow.Listener listener, AbstractWindow abstractWindow) {
        this.l = listener;
        this.w = abstractWindow;
    }

    public static void add(AbstractWindow.Listener listener, AbstractWindow abstractWindow) {
        WindowListenerWrapper windowListenerWrapper = new WindowListenerWrapper(listener, abstractWindow);
        ((Window)abstractWindow.getWindow()).addWindowListener(windowListenerWrapper);
    }

    public static void remove(AbstractWindow.Listener listener, AbstractWindow abstractWindow) {
        Window window = (Window)abstractWindow.getWindow();
        WindowListener[] windowListenerArray = window.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            if (!(windowListenerArray[i] instanceof WindowListenerWrapper)) continue;
            WindowListenerWrapper windowListenerWrapper = (WindowListenerWrapper)windowListenerArray[i];
            if (windowListenerWrapper.l != listener) continue;
            window.removeWindowListener(windowListenerWrapper);
            return;
        }
        throw new IllegalArgumentException("Listener was not registered " + listener);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.l.windowOpened(this.wrap(windowEvent));
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.l.windowClosing(this.wrap(windowEvent));
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.l.windowClosed(this.wrap(windowEvent));
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.l.windowIconified(this.wrap(windowEvent));
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.l.windowDeiconified(this.wrap(windowEvent));
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.l.windowActivated(this.wrap(windowEvent));
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.l.windowDeactivated(this.wrap(windowEvent));
    }

    private AbstractWindow.Event wrap(WindowEvent windowEvent) {
        return AbstractWindow.Event.convert(this.w, windowEvent);
    }
}

