/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.io;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CacheManager
implements FilenameFilter {
    private static final String CACHE_EXT = ".cache";
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private File folder = null;
    private int capacity;
    private long folderSize;
    private SortedSet cacheList = new TreeSet();
    private boolean active = false;

    public void setActive(boolean bl) {
        this.active = bl;
        if (this.active) {
            this.makeSureFolderExists();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addFile(File file) {
        CacheEntry cacheEntry = new CacheEntry(file);
        if (this.cacheList.add(cacheEntry)) {
            this.folderSize += cacheEntry.size;
            this.trimToCapacity();
        }
    }

    public void removeFile(File file) {
        CacheEntry cacheEntry = new CacheEntry(file);
        if (this.cacheList.remove(cacheEntry)) {
            this.folderSize -= cacheEntry.size;
        }
        if (file.exists() && !file.delete()) {
            String string = file.getName();
            int n = string.lastIndexOf(46);
            String string2 = n == -1 ? string : string.substring(0, n);
            File file2 = new File(this.folder, string2 + ".tmp");
            file2.delete();
            file.renameTo(file2);
            file2.deleteOnExit();
        }
    }

    public File createCacheFileName(File file) {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = file.hashCode();
        int n2 = 0;
        while (n2 < 8) {
            stringBuffer.append(HEX_CHARS.charAt(n & 0xF));
            ++n2;
            n >>= 4;
        }
        stringBuffer.append(CACHE_EXT);
        return new File(this.folder, stringBuffer.toString());
    }

    public void setFolder(String string) {
        this.setFolder(new File(string));
    }

    public void setFolder(File file) {
        this.setFolderAndCapacity(file, this.capacity);
    }

    public File getFolder() {
        return this.folder;
    }

    public void setCapacity(int n) {
        this.setFolderAndCapacity(this.folder, n);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setFolderAndCapacity(String string, int n) {
        this.setFolderAndCapacity(new File(string), n);
    }

    public void setFolderAndCapacity(File file, int n) {
        if (file == null || !file.equals(this.folder)) {
            if (this.folder != null) {
                this.clearCache();
            }
            this.folder = file;
            if (this.isActive()) {
                this.makeSureFolderExists();
            }
        }
        if (this.capacity != n) {
            this.capacity = n;
        }
        this.updateFileList();
        this.trimToCapacity();
    }

    private void makeSureFolderExists() {
        if (this.folder != null) {
            this.folder.mkdirs();
        }
    }

    private void updateFileList() {
        File[] fileArray = this.folder == null ? null : this.folder.listFiles(this);
        this.cacheList.clear();
        this.folderSize = 0L;
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry = new CacheEntry(fileArray[i]);
            this.cacheList.add(cacheEntry);
            this.folderSize += cacheEntry.size;
        }
    }

    private void trimToCapacity() {
        long l = (long)this.capacity * 0x100000L;
        while (this.folderSize > l) {
            CacheEntry cacheEntry = (CacheEntry)this.cacheList.first();
            this.cacheList.remove(cacheEntry);
            this.folderSize -= cacheEntry.size;
            if (cacheEntry.file.delete()) continue;
            cacheEntry.file.deleteOnExit();
        }
    }

    private void clearCache() {
        while (!this.cacheList.isEmpty()) {
            CacheEntry cacheEntry = (CacheEntry)this.cacheList.last();
            this.cacheList.remove(cacheEntry);
            if (cacheEntry.file.delete()) continue;
            cacheEntry.file.deleteOnExit();
        }
        this.folderSize = 0L;
    }

    public Action getDebugDumpAction() {
        return new ActionDebugDump();
    }

    protected void debugDump() {
        System.err.println("WaveformCacheManager " + this.hashCode() + "; active ? " + this.isActive() + "; cache folder = " + (this.folder == null ? "null" : this.folder.getAbsolutePath()) + "; listed files = " + this.cacheList.size() + "; listed size = " + this.folderSize / 0x100000L + "MB (capacity = " + this.capacity + " MB)");
        if (!this.cacheList.isEmpty()) {
            System.err.println("Oldest file = " + new Date(((CacheEntry)this.cacheList.first()).lastModified).toString());
            System.err.println("Newest file = " + new Date(((CacheEntry)this.cacheList.last()).lastModified).toString());
        }
    }

    @Override
    public boolean accept(File file, String string) {
        return string.endsWith(CACHE_EXT);
    }

    private static class CacheEntry
    implements Comparable {
        protected final File file;
        protected final long size;
        protected final long lastModified;

        protected CacheEntry(File file) {
            this.file = file;
            this.size = file.length();
            this.lastModified = file.lastModified();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                if (object instanceof CacheEntry) {
                    return this.file.equals(((CacheEntry)object).file);
                }
                if (object instanceof File) {
                    return this.file.equals(object);
                }
            }
            return false;
        }

        public int compareTo(Object object) {
            long l = this.lastModified - ((CacheEntry)object).lastModified;
            return l < 0L ? -1 : (l > 0L ? 1 : 0);
        }
    }

    private class ActionDebugDump
    extends AbstractAction {
        protected ActionDebugDump() {
            super("Dump Waveform Cache");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CacheManager.this.debugDump();
        }
    }
}

