/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ChangeGainDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_GAIN = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType"};
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Gain"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_INPUTFORMAT = 2048;
    private static final int GG_FINDPEAK = 2049;
    private boolean peakKnown = false;
    private Param peakGain;
    public boolean threadJustFind = false;
    private boolean printMarkers = false;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public ChangeGainDlg() {
        super("Change Gain");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ChangeGainDlg.static_pr.text = prText;
            ChangeGainDlg.static_pr.textName = prTextName;
            ChangeGainDlg.static_pr.intg = prIntg;
            ChangeGainDlg.static_pr.intgName = prIntgName;
            ChangeGainDlg.static_pr.para = prPara;
            ChangeGainDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(ChangeGainDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ChangeGainDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = ChangeGainDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        ChangeGainDlg.this.clearInput();
                    }
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ChangeGainDlg.this.gui.getItemID(actionEvent);
                switch (n) {
                    case 2049: {
                        ChangeGainDlg.this.threadJustFind = true;
                        ChangeGainDlg.this.printMarkers = (actionEvent.getModifiers() & 0xC) != 0;
                        ChangeGainDlg.this.clearInput();
                        ChangeGainDlg.this.start();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform Input", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("File:", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        gridBagConstraints.fill = 2;
        JButton jButton = new JButton("Info");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addButton(jButton, 2049, actionListener);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addGadget(jLabel, 2048);
        this.gui.addLabel(new GroupLabel("Output", 1, 0));
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Gain$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("File:", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        this.clearInput();
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    public void clearInput() {
        this.peakKnown = false;
        JLabel jLabel = (JLabel)this.gui.getItemObj(2048);
        jLabel.setText("");
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        block29: {
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            float[][] fArray = null;
            Param param = new Param(1.0, 1);
            try {
                double d;
                boolean bl;
                int n;
                long l;
                float f;
                int n2;
                float[] fArray2;
                int n3;
                int n4;
                long l2;
                long l3;
                int n5;
                boolean bl2 = this.threadJustFind;
                this.threadJustFind = false;
                boolean bl3 = this.printMarkers;
                this.printMarkers = false;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                if (bl3) {
                    ChangeGainDlg.printMarkers(audioFileDescr);
                }
                if ((long)(n5 = audioFileDescr.channels) * (l3 = (long)((int)audioFileDescr.length)) < 1L) {
                    throw new EOFException("File is empty");
                }
                fArray = new float[n5][8192];
                boolean bl4 = bl2 || !this.peakKnown && this.pr.intg[2] == 0;
                boolean bl5 = !bl2;
                long l4 = (bl4 ? l3 : 0L) + (bl5 ? l3 * 2L : 0L);
                long l5 = 0L;
                long l6 = 10000L;
                long l7 = System.currentTimeMillis() + l6;
                if (bl5) {
                    PathField pathField = (PathField)this.gui.getItemObj(1025);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                    pathField.fillStream(audioFileDescr2);
                    audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                    if (!this.threadRunning) break block29;
                }
                float f2 = -1.0f;
                long l8 = -1L;
                int n6 = -1;
                double d2 = 0.0;
                if (bl4) {
                    l2 = 0L;
                    while (l2 < l3 && this.threadRunning) {
                        n4 = (int)Math.min(8192L, l3 - l2);
                        audioFile2.readFrames(fArray, 0, n4);
                        for (n3 = 0; n3 < n5; ++n3) {
                            fArray2 = fArray[n3];
                            for (n2 = 0; n2 < n4; ++n2) {
                                f = fArray2[n2];
                                f *= f;
                                d2 += (double)f;
                                if (!(f >= f2)) continue;
                                l = l2 + (long)n2 + 1L;
                                n = n3 + 1;
                                if (f > f2) {
                                    f2 = f;
                                    l8 = l;
                                    n6 = n;
                                    continue;
                                }
                                if (l8 != l) {
                                    l8 = -Math.abs(l8);
                                }
                                if (n6 == n) continue;
                                n6 = -Math.abs(n6);
                            }
                        }
                        this.setProgression((float)(l5 += (long)n4) / (float)l4);
                        boolean bl6 = bl = (l2 += (long)n4) == l3;
                        if (System.currentTimeMillis() <= l7 && !bl) continue;
                        d = d2 / (double)(l2 * (long)n5);
                        this.showPeak(audioFileDescr, Math.sqrt(f2), l8, n6, d, bl);
                        l7 += (l6 <<= 1);
                    }
                    if (!this.threadRunning) break block29;
                    this.peakGain = new Param(Math.sqrt(f2), 1);
                    this.peakKnown = true;
                    if (bl5) {
                        this.indicateOutputWrite();
                    }
                }
                if (bl5) {
                    audioFile2.seekFrame(0L);
                    float f3 = this.pr.intg[2] == 1 ? (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value : (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / this.peakGain.value), (int)this.peakGain.unit), null).value;
                    if (this.peakKnown) {
                        f2 = (float)this.peakGain.value * (float)this.peakGain.value;
                    }
                    l2 = 0L;
                    while (l2 < l3 && this.threadRunning) {
                        n4 = (int)Math.min(8192L, l3 - l2);
                        audioFile2.readFrames(fArray, 0, n4);
                        if (!this.peakKnown) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                fArray2 = fArray[n3];
                                for (n2 = 0; n2 < n4; ++n2) {
                                    f = fArray2[n2];
                                    f *= f;
                                    d2 += (double)f;
                                    if (!(f >= f2)) continue;
                                    l = l2 + (long)n2 + 1L;
                                    n = n3 + 1;
                                    if (f > f2) {
                                        f2 = f;
                                        l8 = l;
                                        n6 = n;
                                        continue;
                                    }
                                    if (l8 != l) {
                                        l8 = -Math.abs(l8);
                                    }
                                    if (n6 == n) continue;
                                    n6 = -Math.abs(n6);
                                }
                            }
                            boolean bl7 = bl = l2 == l3;
                            if (System.currentTimeMillis() > l7 || bl) {
                                d = d2 / (double)(l2 * (long)n5);
                                this.showPeak(audioFileDescr, Math.sqrt(f2), l8, n6, d, bl);
                                l7 += (l6 <<= 1);
                            }
                        }
                        l2 += (long)n4;
                        l5 += (long)n4;
                        for (n3 = 0; n3 < n5; ++n3) {
                            Util.mult(fArray[n3], 0, n4, f3);
                        }
                        audioFile.writeFrames(fArray, 0, n4);
                        this.setProgression((float)(l5 += (long)n4) / (float)l4);
                    }
                    if (!this.threadRunning) break block29;
                    if (!this.peakKnown) {
                        this.peakGain = new Param(Math.sqrt(f2), 1);
                        this.peakKnown = true;
                    }
                    f2 *= f3 * f3;
                    audioFile.close();
                    audioFile = null;
                }
                audioFile2.close();
                audioFile2 = null;
                audioFileDescr = null;
                if (!bl2 && f2 > 1.0f && this.pr.intg[2] == 1) {
                    this.handleClipping((float)Math.sqrt(f2));
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                fArray = null;
                Object var14_27 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    private static void printMarkers(AudioFileDescr audioFileDescr) {
        Marker marker;
        int n;
        ArrayList arrayList = (ArrayList)audioFileDescr.getProperty((Object)"markers");
        ArrayList arrayList2 = (ArrayList)audioFileDescr.getProperty((Object)"regions");
        ArrayList arrayList3 = new ArrayList();
        if (arrayList == null) {
            arrayList = arrayList3;
        }
        if (arrayList2 == null) {
            arrayList2 = arrayList3;
        }
        System.out.println("File: " + audioFileDescr.file.getName() + "\n   # of Markers : " + arrayList.size() + "; # of Regions : " + arrayList2.size());
        System.out.println("\nMarker names: ");
        for (n = 0; n < arrayList.size(); ++n) {
            marker = (Marker)arrayList.get(n);
            System.out.println(marker.name);
        }
        System.out.println("\nMarker times in sample frames: ");
        for (n = 0; n < arrayList.size(); ++n) {
            marker = (Marker)arrayList.get(n);
            System.out.println(marker.pos);
        }
        System.out.println("\nMarker times in seconds: ");
        for (n = 0; n < arrayList.size(); ++n) {
            marker = (Marker)arrayList.get(n);
            System.out.println(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)marker.pos) / 1000.0);
        }
        System.out.println("\nRegion names: ");
        for (n = 0; n < arrayList2.size(); ++n) {
            Region region = (Region)arrayList2.get(n);
            System.out.println(region.name);
        }
    }

    private void showPeak(AudioFileDescr audioFileDescr, double d, long l, int n, double d2, boolean bl) {
        boolean bl2;
        double d3 = (AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)(Math.abs(l) - 1L)) + 0.5) / 1000.0;
        int n2 = (int)(d3 / 60.0);
        d3 %= 60.0;
        boolean bl3 = bl2 = n < 0 || audioFileDescr.channels == 1;
        String string = bl2 ? "" : (audioFileDescr.channels == 2 ? (n == 1 ? "[L]" : "[R]") : "[" + n + "]");
        Double d4 = 20.0 * Math.log(d) / 2.302585092994046;
        Double d5 = 10.0 * Math.log(d2) / 2.302585092994046;
        Integer n3 = bl ? 1 : -1;
        Object[] objectArray = new Object[]{d4, d5, n3, n2, d3, l};
        String string2 = "{2,choice,-1#[\u2026|0#}Max amp {0,number,#,##0.0} dBFS @{3,number,##0}:{4,number,00.000}{5,choice,-1#+|0#}" + string + "; RMS {1,number,##,##0.0} dB{2,choice,-1#\u2026]|0#}";
        MessageFormat messageFormat = new MessageFormat(string2);
        messageFormat.setLocale(Locale.US);
        messageFormat.applyPattern(string2);
        JLabel jLabel = (JLabel)this.gui.getItemObj(2048);
        jLabel.setText(messageFormat.format(objectArray));
    }
}

