/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectralFile;
import de.sciss.fscape.spect.Wavelet;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.gui.AbstractWindowHandler;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ConvertDlg
extends ModulePanel {
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private PropertyGUI settingsGUI;
    private int inType = -1;
    private int outType = -1;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_SOUND = 0;
    private static final int TYPE_SPECT = 1;
    private static final int TYPE_IMAGE = 2;
    private static final String ERR_CONVERSION = "Unsupported conversion";
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PRS_BANDS = 1;
    private static final int PRS_BANDWIDTH = 2;
    private static final int PRS_FRAMELEN = 3;
    private static final int PRS_TRANSFORM = 4;
    private static final int PRS_WINDOW = 6;
    private static final int PRS_OVERLAP = 7;
    private static final int PRS_COLORMODE = 8;
    private static final int PRS_OVERHEAD = 9;
    private static final int PRS_CHANNELS = 10;
    private static final int PR_OUTPUTRES = 11;
    private static final int PR_OUTPUTRATE = 12;
    private static final int PR_ADJUSTGAIN = 0;
    private static final int PR_GAIN = 0;
    private static final int PRS_NOISEFLOOR = 1;
    private static final int PRS_TRANSFORM_FFT = 0;
    private static final int PRS_TRANSFORM_DFT = 1;
    private static final int PRS_TRANSFORM_FWT = 2;
    private static final int PRS_FILTER_DAUB4 = 0;
    private static final int PRS_WINDOW_KAISER5 = 3;
    private static final int PRS_OVERLAP_100 = 2;
    private static final int PRS_COLORMODE_CHAN = 0;
    private static final int PRS_COLORMODE_POLAR = 1;
    private static final int PRS_OVERHEAD_TILE = 0;
    private static final int PRS_CHANNELS_3 = 3;
    private static final double[] freqScales = new double[]{1.0036166659754628, 1.0048251256952678, 1.007246412223704, 1.0145453349375237, 1.029302236643492, 1.0594630943592953};
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputRes";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String PRN_BANDS = "Bands";
    private static final String PRN_BANDWIDTH = "Bandwidth";
    private static final String PRN_FRAMELEN = "FrameLen";
    private static final String PRN_TRANSFORM = "Transform";
    private static final String PRN_FILTER = "Filter";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String PRN_COLORMODE = "ColorMode";
    private static final String PRN_OVERHEAD = "Overhead";
    private static final String PRN_CHANNELS = "Channels";
    private static final String PRN_NOISEFLOOR = "NoiseFloor";
    private static final String PRN_ADJUSTGAIN = "AdjustGain";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 1, 1, 1, 0, 0, 3, 2, 0, 0, 3, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "Bands", "Bandwidth", "FrameLen", "Transform", "Filter", "Window", "Overlap", "ColorMode", "Overhead", "Channels", "OutputRes", "OutputRate"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"AdjustGain"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Gain", "NoiseFloor"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 267;
    private static final int GG_OUTPUTRATE = 268;
    private static final int GG_SETTINGS = 2048;
    private static final int GUI_ANALYSIS = 0;
    private static final int GUI_SYNTHESIS = 1;
    private static final int GUI_TOIMAGE = 2;
    private static final int GUI_FROMIMAGE = 3;

    public ConvertDlg() {
        super("Convert files");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ConvertDlg.static_pr.text = prText;
            ConvertDlg.static_pr.textName = prTextName;
            ConvertDlg.static_pr.intg = prIntg;
            ConvertDlg.static_pr.intgName = prIntgName;
            ConvertDlg.static_pr.bool = prBool;
            ConvertDlg.static_pr.boolName = prBoolName;
            ConvertDlg.static_pr.para = prPara;
            ConvertDlg.static_pr.para[0] = new Param(0.0, 785);
            ConvertDlg.static_pr.para[1] = new Param(-120.0, 785);
            ConvertDlg.static_pr.paraName = prParaName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ConvertDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 256: {
                        ConvertDlg.this.outputChanged();
                        break;
                    }
                }
            }
        };
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = ConvertDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        ConvertDlg.this.setInput(((PathField)pathEvent.getSource()).getPath().getPath());
                        ConvertDlg.this.outputChanged();
                    }
                }
            }
        };
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Input / Output", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        int[][] nArrayArray = new int[][]{GenericFile.TYPES_SOUND, GenericFile.TYPES_SPECT, GenericFile.TYPES_IMAGE};
        pathField.handleTypes(nArrayArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(113, "Select output file");
        pathField2.handleTypes(nArrayArray);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        pathField2.getTypeGadget().addItemListener(itemListener);
        this.gui.registerGadget(pathField2.getResGadget(), 267);
        this.gui.registerGadget(pathField2.getRateGadget(), 268);
        this.gui.addLabel(new JLabel("Conversion settings", 0));
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.putClientProperty("styleId", "nofocus");
        jScrollPane.setPreferredSize(new Dimension(256, 256));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.gui.addScrollPane(jScrollPane, 2048, adjustmentListener);
        this.initGUI(this, 6, this.gui);
    }

    protected PropertyGUI createGUI(int n) {
        String string = "cbAdjust gain,actrue|100|en,acfalse|100|di,prAdjustGain;pf7,id100,prGain";
        String string2 = "lbTransform;ch,prTransform,ac0|21|di|22|di|23|di,ac1|21|di|22|en|23|en,ac2|21|en|22|di|23|di,itFast Fourier,itDiscrete Fourier (log. Scale),itFast Wavelet\nlbFilter;ch,id21,prFilter,itDaubechies 4\n";
        String string3 = "lbWindow;ch,prWindow,itHamming,itBlackman,itKaiser \u03b2=4,itKaiser \u03b2=5,itKaiser \u03b2=6,itKaiser \u03b2=8\n";
        String string4 = "lbOverlap;ch,prOverlap,it1x,it2x,it4x,it8x,it16x\n";
        String string5 = "lbBands;ch,prBands,it4096,it2048,it1024,it512,it256,it128,it64,it32\nlbBandwidth [semi];ch,id22,prBandwidth,it1/16,it1/12,it1/8,it1/4,it1/2,it1/1\nlbFrame length;ch,id23,prFrameLen,it4096,it2048,it1024,it512,it256,it128,it64,it32\n";
        String string6 = "";
        String string7 = "";
        String string8 = "lbSeparate colors for;ch,prColorMode,itEach channel,itAmp + Phase\nlbHandle overhead;ch,prOverhead,itBy horizontal tiling,itBy creating separate files\nlbChannels;ch,prChannels,itLeave untouched,it1,it2,it3\nlbNoisefloor;pf7,prNoiseFloor\n";
        String string9 = "";
        String string10 = null;
        switch (n) {
            case 0: {
                string10 = string2 + string5 + string3 + string4 + string;
                break;
            }
            case 1: {
                string10 = string2 + string3 + string7 + string;
                break;
            }
            case 2: {
                string10 = string8 + string9 + string;
                break;
            }
            case 3: {
                string10 = string2 + string6 + string4 + string8 + string;
                break;
            }
            default: {
                return null;
            }
        }
        PropertyGUI propertyGUI = new PropertyGUI(string10);
        propertyGUI.setType(n);
        return propertyGUI;
    }

    public PropertyGUI getSettingsGUI() {
        return this.settingsGUI;
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        PropertyGUI propertyGUI = this.getSettingsGUI();
        this.setInput(this.pr.text[0]);
        this.outputChanged();
        if (propertyGUI != null) {
            propertyGUI.fillGUI(this.pr);
        }
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        PropertyGUI propertyGUI = this.getSettingsGUI();
        if (propertyGUI != null) {
            propertyGUI.fillPropertyArray(this.pr);
        }
    }

    public void setSettingsGUI(int n) {
        JScrollPane jScrollPane = (JScrollPane)this.gui.getItemObj(2048);
        if (jScrollPane == null) {
            return;
        }
        this.settingsGUI = this.createGUI(n);
        if (this.settingsGUI != null) {
            this.settingsGUI.fillGUI(this.getPropertyArray());
            Dimension dimension = jScrollPane.getSize();
            this.settingsGUI.setSize(dimension.width, dimension.height);
            jScrollPane.setViewportView(this.settingsGUI);
            AbstractWindowHandler.setDeepFont((Container)this.settingsGUI);
        } else {
            jScrollPane.setViewportView(null);
        }
    }

    public void setInput(String string) {
        this.inType = -1;
        try {
            GenericFile genericFile = new GenericFile(string, 0);
            int n = genericFile.mode & 0xFFF0;
            this.inType = Util.isValueInArray(n, GenericFile.TYPES_IMAGE) ? 2 : (Util.isValueInArray(n, GenericFile.TYPES_SOUND) ? 0 : (Util.isValueInArray(n, GenericFile.TYPES_SPECT) ? 1 : -1));
            genericFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void outputChanged() {
        int n = -1;
        PathField pathField = (PathField)this.gui.getItemObj(1025);
        this.outType = -1;
        if (pathField != null) {
            int n2 = pathField.getType();
            this.outType = Util.isValueInArray(n2, GenericFile.TYPES_IMAGE) ? 2 : (Util.isValueInArray(n2, GenericFile.TYPES_SOUND) ? 0 : (Util.isValueInArray(n2, GenericFile.TYPES_SPECT) ? 1 : -1));
        }
        switch (this.outType) {
            case 1: {
                if (this.inType == 0) {
                    n = 0;
                    break;
                }
                if (this.inType != 2) break;
                n = 3;
                break;
            }
            case 0: {
                if (this.inType != 1) break;
                n = 1;
                break;
            }
            case 2: {
                if (this.inType != 1) break;
                n = 2;
                break;
            }
        }
        this.settingsGUI = this.getSettingsGUI();
        if (this.settingsGUI == null || this.settingsGUI.getType() != n) {
            this.setSettingsGUI(n);
        }
    }

    @Override
    protected void process() {
        SpectFrame spectFrame;
        GenericFile genericFile;
        GenericFile genericFile2;
        block141: {
            genericFile2 = null;
            genericFile = null;
            Object object = null;
            Object object2 = null;
            spectFrame = null;
            float f = 0.0f;
            int n = this.pr.intg[10];
            int n2 = 0;
            int n3 = (1 << 12 - this.pr.intg[1]) + 1;
            int n4 = 1 << 12 - this.pr.intg[3];
            int n5 = this.pr.intg[7];
            float f2 = 0.0f;
            float f3 = 1.0f;
            Param param = new Param(1.0, 1);
            byte[] byArray = null;
            float f4 = (float)(5100.0 / this.pr.para[1].value / 2.302585092994046);
            float f5 = (float)(1310700.0 / this.pr.para[1].value / 2.302585092994046);
            int n6 = 1;
            double d = 0.0;
            float[] fArray = null;
            float[] fArray2 = null;
            float[][] fArray3 = null;
            float[][] fArray4 = null;
            float[] fArray5 = null;
            float[][] fArray6 = null;
            long l = 0L;
            try {
                int n7;
                int n8;
                if (this.pr.bool[0]) {
                    f3 = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                switch (this.inType) {
                    case 1: {
                        genericFile2 = new SpectralFile(this.pr.text[0], 0);
                        object = ((SpectralFile)genericFile2).getDescr();
                        if (((SpectStream)object).frames > 0L) break;
                        throw new EOFException("File is empty");
                    }
                    case 0: {
                        genericFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                        object = ((AudioFile)genericFile2).getDescr();
                        if (((AudioFileDescr)object).length > 0L) break;
                        throw new EOFException("File is empty");
                    }
                    case 2: {
                        genericFile2 = new ImageFile(this.pr.text[0], 0);
                        object = ((ImageFile)genericFile2).initReader();
                        if (((ImageStream)object).height <= 0) {
                            throw new EOFException("File is empty");
                        }
                        byArray = ((ImageFile)genericFile2).allocRow();
                        break;
                    }
                    default: {
                        throw new IOException(ERR_CONVERSION);
                    }
                }
                if (!this.threadRunning) break block141;
                block6 : switch (this.outType) {
                    case 1: {
                        float f6;
                        float f7;
                        int n9;
                        int n10;
                        PathField pathField = (PathField)this.gui.getItemObj(1025);
                        if (pathField == null) {
                            throw new IOException("Bug! Missing property!");
                        }
                        genericFile = new SpectralFile(this.pr.text[1], 1 | pathField.getType());
                        object2 = new SpectStream();
                        pathField.fillStream((SpectStream)object2);
                        switch (this.inType) {
                            case 2: {
                                if (n == 0) {
                                    n = 1;
                                }
                                if (this.pr.intg[8] == 0) {
                                    n = Math.min(n, ((ImageStream)object).smpPerPixel);
                                }
                                n10 = this.pr.intg[9] == 0 ? (this.pr.intg[8] == 0 ? 2 : n) : 1;
                                n3 = ((ImageStream)object).width / n10;
                                if (this.pr.intg[4] == 0) {
                                    n9 = n3 - 1;
                                    n3 = 1;
                                    while (n9 > 1) {
                                        n9 >>= 1;
                                        n3 <<= 1;
                                    }
                                    ++n3;
                                }
                                f7 = ((SpectStream)object2).smpRate;
                                f6 = f7 / 2.0f;
                                n6 = ((ImageStream)object).smpPerPixel;
                                n2 = ((ImageStream)object).height;
                                break;
                            }
                            case 0: {
                                n = ((AudioFileDescr)object).channels;
                                f7 = (float)((AudioFileDescr)object).rate;
                                switch (this.pr.intg[4]) {
                                    case 1: {
                                        d = freqScales[this.pr.intg[2]];
                                        f2 = (float)((double)f7 / (2.0 * Math.pow(d, --n3 - 1)));
                                        n9 = (int)Math.ceil(Math.log(440.0f / f2) / Math.log(d));
                                        f2 = (float)(440.0 / Math.pow(d, n9));
                                        f6 = (float)((double)f2 * Math.pow(d, n3 - 1));
                                        fArray3 = new float[n3][n4];
                                        fArray4 = new float[n3][n4];
                                        this.calcCosineTables(fArray3, fArray4, f2, f6, f7, 1);
                                        break;
                                    }
                                    case 2: {
                                        f2 = 0.0f;
                                        f6 = f7 / 2.0f;
                                        n4 = --n3;
                                        break;
                                    }
                                    default: {
                                        throw new IOException(ERR_CONVERSION);
                                    }
                                }
                                fArray5 = Filter.createWindow(n4 >> 1, this.pr.intg[6]);
                                if (this.pr.bool[0]) {
                                    n8 = 0;
                                    while (n8 < fArray5.length) {
                                        int n11 = n8++;
                                        fArray5[n11] = fArray5[n11] * f3;
                                    }
                                }
                                fArray = new float[n4 * n];
                                fArray2 = new float[n4 * n];
                                fArray6 = new float[n][n4];
                                n2 = (int)(((AudioFileDescr)object).length + (long)n4 - 1L) / n4;
                                break;
                            }
                            default: {
                                throw new IOException(ERR_CONVERSION);
                            }
                        }
                        ((SpectStream)object2).setChannels(n);
                        n8 = n3 - 1 >> n5;
                        ((SpectStream)object2).setRate(f7, n8);
                        ((SpectStream)object2).setEstimatedLength(n2);
                        ((SpectStream)object2).setBands(f2, f6, n3, this.pr.intg[4] == 0 ? 1 : 2);
                        ((SpectralFile)genericFile).initWriter((SpectStream)object2, this.pr.intg[4] == 2 ? 1 : 3);
                        spectFrame = ((SpectralFile)genericFile).allocFrame();
                        break;
                    }
                    case 0: {
                        float f6;
                        float f7;
                        int n9;
                        PathField pathField = (PathField)this.gui.getItemObj(1025);
                        if (pathField == null) {
                            throw new IOException("Bug! Missing property!");
                        }
                        object2 = new AudioFileDescr();
                        pathField.fillStream((AudioFileDescr)object2);
                        switch (this.inType) {
                            case 1: {
                                n3 = ((SpectStream)object).bands;
                                n = ((SpectStream)object).chanNum;
                                n4 = ((SpectStream)object).smpPerFrame;
                                f7 = ((SpectStream)object).smpRate;
                                object2.channels = n;
                                object2.rate = f7;
                                l = (long)n4 * ((SpectStream)object).frames;
                                switch (this.pr.intg[4]) {
                                    case 1: {
                                        f2 = ((SpectStream)object).loFreq;
                                        f6 = ((SpectStream)object).hiFreq;
                                        fArray3 = new float[n3][n4];
                                        fArray4 = new float[n3][n4];
                                        this.calcCosineTables(fArray3, fArray4, f2, f6, f7, -1);
                                        break;
                                    }
                                    case 2: {
                                        f2 = 0.0f;
                                        f6 = f7 / 2.0f;
                                        n9 = n3 - 1;
                                        n3 = 1;
                                        while (n9 > 1) {
                                            n9 >>= 1;
                                            n3 <<= 1;
                                        }
                                        n4 = n3++;
                                        break;
                                    }
                                    default: {
                                        throw new IOException(ERR_CONVERSION);
                                    }
                                }
                                fArray5 = Filter.createWindow(n4 >> 1, this.pr.intg[6]);
                                if (!this.pr.bool[0]) break;
                                n7 = 0;
                                while (n7 < fArray5.length) {
                                    int n12 = n7++;
                                    fArray5[n12] = fArray5[n12] * f3;
                                }
                                break;
                            }
                            default: {
                                throw new IOException(ERR_CONVERSION);
                            }
                        }
                        genericFile = AudioFile.openAsWrite((AudioFileDescr)object2);
                        fArray = new float[n4 * n];
                        fArray2 = new float[n4 * n];
                        fArray6 = new float[n][n4];
                        break;
                    }
                    case 2: {
                        int n10;
                        PathField pathField = (PathField)this.gui.getItemObj(1025);
                        if (pathField == null) {
                            throw new IOException("Bug! Missing property!");
                        }
                        genericFile = new ImageFile(this.pr.text[1], 1 | pathField.getType());
                        object2 = new ImageStream();
                        pathField.fillStream((ImageStream)object2);
                        switch (this.inType) {
                            case 1: {
                                ((ImageStream)object2).height = (int)((SpectStream)object).frames;
                                ((ImageStream)object2).hRes = 0.013888889f;
                                ((ImageStream)object2).vRes = 0.013888889f;
                                ((ImageStream)object2).resUnit = 2;
                                n3 = ((SpectStream)object).bands;
                                if (n == 0) {
                                    n = ((SpectStream)object).chanNum;
                                }
                                n = Math.min(n, ((SpectStream)object).chanNum);
                                if (this.pr.intg[8] == 0 && n > 3) {
                                    n = 3;
                                }
                                ((ImageStream)object2).smpPerPixel = this.pr.intg[8] == 0 && n > 1 || this.pr.intg[8] == 1 ? 3 : 1;
                                n6 = ((ImageStream)object2).smpPerPixel;
                                n10 = this.pr.intg[9] == 0 ? (this.pr.intg[8] == 0 ? 2 : n) : 1;
                                ((ImageStream)object2).width = n3 * n10;
                                ((ImageFile)genericFile).initWriter((ImageStream)object2);
                                byArray = ((ImageFile)genericFile).allocRow();
                                break block6;
                            }
                        }
                        throw new IOException(ERR_CONVERSION);
                    }
                    default: {
                        throw new IOException(ERR_CONVERSION);
                    }
                }
                int n13 = n3 << 1;
                while (f < 1.0f && this.threadRunning) {
                    switch (this.inType) {
                        case 2: {
                            int n14;
                            int n15;
                            ((ImageFile)genericFile2).readRow(byArray);
                            switch (this.pr.intg[8]) {
                                case 0: {
                                    if (((ImageStream)object).bitsPerSmp == 8) {
                                        for (n8 = 0; n8 < n; ++n8) {
                                            n7 = 0;
                                            n15 = 0;
                                            while (n7 < n3) {
                                                spectFrame.data[n8][n15 + 0] = (float)Math.exp((float)(255 - (byArray[n7 * n6 + n8] & 0xFF)) / f4);
                                                spectFrame.data[n8][n15 + 1] = 0.024639942f * (float)(byArray[(n3 + n7) * n6 + n8] & 0xFF) - (float)Math.PI;
                                                ++n7;
                                                n15 += 2;
                                            }
                                        }
                                    } else {
                                        for (n8 = 0; n8 < n; ++n8) {
                                            for (n7 = 0; n7 < n13; n7 += 2) {
                                                n14 = (byArray[n7 * n6 + n8] & 0xFF) << 8 | byArray[n7 * n6 + n8 + 1] & 0xFF;
                                                spectFrame.data[n8][n7 + 0] = (float)Math.exp((float)(65535 - n14) / f5);
                                                n14 = (byArray[(n13 + n7) * n6 + n8] & 0xFF) << 8 | byArray[(n13 + n7) * n6 + n8 + 1] & 0xFF;
                                                spectFrame.data[n8][n7 + 1] = 9.5875264E-5f * (float)n14 - (float)Math.PI;
                                            }
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    if (((ImageStream)object).bitsPerSmp == 8) {
                                        if (((ImageStream)object).smpPerPixel >= 2) {
                                            for (n8 = 0; n8 < n; ++n8) {
                                                n7 = 0;
                                                n15 = 0;
                                                while (n7 < n3) {
                                                    spectFrame.data[n8][n15 + 0] = (float)Math.exp((float)(255 - (byArray[(n7 + n3 * n8) * n6 + n8] & 0xFF)) / f4);
                                                    spectFrame.data[n8][n15 + 1] = 0.024639942f * (float)(byArray[(n7 + n3 * n8) * n6 + n8 + 1] & 0xFF) - (float)Math.PI;
                                                    ++n7;
                                                    n15 += 2;
                                                }
                                            }
                                        } else {
                                            for (n8 = 0; n8 < n; ++n8) {
                                                n7 = 0;
                                                n15 = 0;
                                                while (n7 < n3) {
                                                    spectFrame.data[n8][n15 + 0] = (float)Math.exp((float)(255 - (byArray[(n7 + n3 * n8) * n6 + n8] & 0xFF)) / f4);
                                                    spectFrame.data[n8][n15 + 1] = 0.0f;
                                                    ++n7;
                                                    n15 += 2;
                                                }
                                            }
                                        }
                                    } else if (((ImageStream)object).smpPerPixel >= 2) {
                                        for (n8 = 0; n8 < n; ++n8) {
                                            for (n7 = 0; n7 < n13; n7 += 2) {
                                                n14 = (byArray[(n7 + n13 * n8) * n6 + n8] & 0xFF) << 8 | byArray[(n7 + n13 * n8) * n6 + n8 + 1] & 0xFF;
                                                spectFrame.data[n8][n7 + 0] = (float)Math.exp((float)(65535 - n14) / f5);
                                                n14 = (byArray[(n7 + n13 * n8) * n6 + n8 + 2] & 0xFF) << 8 | byArray[(n7 + n13 * n8) * n6 + n8 + 3] & 0xFF;
                                                spectFrame.data[n8][n7 + 1] = 9.5875264E-5f * (float)n14 - (float)Math.PI;
                                            }
                                        }
                                    } else {
                                        for (n8 = 0; n8 < n; ++n8) {
                                            for (n7 = 0; n7 < n13; n7 += 2) {
                                                n14 = (byArray[(n7 + n13 * n8) * n6 + n8] & 0xFF) << 8 | byArray[(n7 + n13 * n8) * n6 + n8 + 1] & 0xFF;
                                                spectFrame.data[n8][n7 + 0] = (float)Math.exp((float)(65535 - n14) / f5);
                                                spectFrame.data[n8][n7 + 1] = 0.0f;
                                            }
                                        }
                                    }
                                }
                            }
                            if (this.pr.bool[0]) {
                                for (n8 = 0; n8 < n; ++n8) {
                                    for (n7 = 0; n7 < n13; n7 += 2) {
                                        float[] fArray7 = spectFrame.data[n8];
                                        int n16 = n7 + 0;
                                        fArray7[n16] = fArray7[n16] * f3;
                                    }
                                }
                            }
                            ((SpectralFile)genericFile).writeFrame(spectFrame);
                            f = (float)((ImageStream)object).rowsRead / (float)((ImageStream)object).height;
                            break;
                        }
                        case 1: {
                            int n17;
                            int n18;
                            float f8;
                            float f9;
                            int n14;
                            int n15;
                            spectFrame = ((SpectralFile)genericFile2).readFrame();
                            switch (this.outType) {
                                case 2: {
                                    switch (this.pr.intg[8]) {
                                        case 0: {
                                            if (((ImageStream)object2).bitsPerSmp == 8) {
                                                for (n8 = 0; n8 < n; ++n8) {
                                                    n7 = 0;
                                                    n15 = 0;
                                                    while (n7 < n3) {
                                                        byArray[n7 * n6 + n8] = (byte)Math.max(0, Math.min(255, 255 - (int)Math.rint((double)f4 * Math.log(spectFrame.data[n8][n15 + 0]))));
                                                        byArray[(n3 + n7) * n6 + n8] = (byte)Math.rint(((double)spectFrame.data[n8][n15 + 1] + Math.PI) % (Math.PI * 2) / 0.02463994175195694);
                                                        ++n7;
                                                        n15 += 2;
                                                    }
                                                }
                                            } else {
                                                for (n8 = 0; n8 < n; ++n8) {
                                                    for (n7 = 0; n7 < n13; n7 += 2) {
                                                        n14 = Math.max(0, Math.min(65535, 65535 - (int)Math.rint((double)f5 * Math.log(spectFrame.data[n8][n7 + 0]))));
                                                        byArray[n7 * n6 + n8] = (byte)((n14 & 0xFF00) >> 8);
                                                        byArray[n7 * n6 + n8 + 1] = (byte)(n14 & 0xFF);
                                                        n14 = (int)Math.rint(((double)spectFrame.data[n8][n7 + 1] + Math.PI) % (Math.PI * 2) / 9.587526437826455E-5);
                                                        byArray[(n13 + n7) * n6 + n8] = (byte)((n14 & 0xFF00) >> 8);
                                                        byArray[(n13 + n7) * n6 + n8 + 1] = (byte)(n14 & 0xFF);
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                        default: {
                                            if (((ImageStream)object2).bitsPerSmp == 8) {
                                                for (n8 = 0; n8 < n; ++n8) {
                                                    for (n7 = 0; n7 < n3; ++n7) {
                                                        byArray[(n7 + n3 * n8) * n6 + n8] = (byte)Math.max(0, Math.min(255, 255 - (int)Math.rint((double)f4 * Math.log(spectFrame.data[n8][(n7 << 1) + 0]))));
                                                        byArray[(n7 + n3 * n8) * n6 + n8 + 1] = (byte)Math.rint(((double)spectFrame.data[n8][(n7 << 1) + 1] + Math.PI) % (Math.PI * 2) / 0.02463994175195694);
                                                    }
                                                }
                                            } else {
                                                for (n8 = 0; n8 < n; ++n8) {
                                                    for (n7 = 0; n7 < n13; n7 += 2) {
                                                        n14 = Math.max(0, Math.min(65535, 65535 - (int)Math.rint((double)f5 * Math.log(spectFrame.data[n8][n7 + 0]))));
                                                        byArray[(n7 + n13 * n8) * n6 + n8] = (byte)((n14 & 0xFF00) >> 8);
                                                        byArray[(n7 + n13 * n8) * n6 + n8 + 1] = (byte)(n14 & 0xFF);
                                                        n14 = (int)Math.rint(((double)spectFrame.data[n8][n7 + 1] + Math.PI) % (Math.PI * 2) / 9.587526437826455E-5);
                                                        byArray[(n7 + n13 * n8) * n6 + n8 + 2] = (byte)((n14 & 0xFF00) >> 8);
                                                        byArray[(n7 + n13 * n8) * n6 + n8 + 3] = (byte)(n14 & 0xFF);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ((ImageFile)genericFile).writeRow(byArray);
                                    f = (float)((ImageStream)object2).rowsWritten / (float)((ImageStream)object2).height;
                                    break;
                                }
                                case 0: {
                                    switch (this.pr.intg[4]) {
                                        case 1: {
                                            for (n8 = 0; n8 < n; ++n8) {
                                                for (n7 = 0; n7 < n3 << 1; n7 += 2) {
                                                    f9 = spectFrame.data[n8][n7 + 0];
                                                    f8 = spectFrame.data[n8][n7 + 1];
                                                    spectFrame.data[n8][n7 + 0] = (float)((double)f9 * Math.cos(f8));
                                                    spectFrame.data[n8][n7 + 1] = (float)((double)f9 * Math.sin(f8));
                                                }
                                            }
                                            for (n8 = 0; n8 < n; ++n8) {
                                                n7 = 0;
                                                n15 = n8;
                                                while (n7 < n4) {
                                                    f9 = 0.0f;
                                                    n18 = 0;
                                                    n17 = 0;
                                                    while (n18 < n3) {
                                                        f9 += spectFrame.data[n8][n17 + 0] * fArray3[n18][n7];
                                                        f9 -= spectFrame.data[n8][n17 + 1] * fArray4[n18][n7];
                                                        ++n18;
                                                        n17 += 2;
                                                    }
                                                    fArray[n15] = f9;
                                                    ++n7;
                                                    n15 += n;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            for (n8 = 0; n8 < n; ++n8) {
                                                n7 = 0;
                                                n15 = 0;
                                                while (n15 < n4) {
                                                    spectFrame.data[n8][n15] = spectFrame.data[n8][n7];
                                                    ++n15;
                                                    n7 += 2;
                                                }
                                                Wavelet.invTransformDaub4(spectFrame.data[n8], n4);
                                                n7 = 0;
                                                n15 = n8;
                                                while (n7 < n4) {
                                                    fArray[n15] = spectFrame.data[n8][n7];
                                                    ++n7;
                                                    n15 += n;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    ConvertDlg.writeInterleaved((AudioFile)genericFile, fArray, 0, fArray.length, fArray6, n);
                                    f = (float)object2.length / (float)l;
                                    break;
                                }
                                default: {
                                    throw new IOException(ERR_CONVERSION);
                                }
                            }
                            ((SpectralFile)genericFile2).freeFrame(spectFrame);
                            break;
                        }
                        case 0: {
                            int n17;
                            int n18;
                            float f8;
                            float f9;
                            int n15;
                            ConvertDlg.readInterleaved((AudioFile)genericFile2, fArray, 0, fArray.length, fArray6, n);
                            for (n8 = 0; n8 < n; ++n8) {
                                n7 = 0;
                                n18 = n15 = (n4 >> 1) * n + n8;
                                while (n7 < fArray5.length) {
                                    fArray2[n15] = fArray[n15] * fArray5[n7];
                                    fArray2[n18] = fArray[n18] * fArray5[n7];
                                    ++n7;
                                    n15 += n;
                                    n18 -= n;
                                }
                            }
                            switch (this.pr.intg[4]) {
                                case 1: {
                                    for (n8 = 0; n8 < n; ++n8) {
                                        n7 = 0;
                                        n15 = 0;
                                        while (n7 < n3) {
                                            f9 = 0.0f;
                                            f8 = 0.0f;
                                            float[] fArray8 = fArray3[n7];
                                            float[] fArray9 = fArray4[n7];
                                            n18 = 0;
                                            n17 = n8;
                                            while (n18 < n4) {
                                                float f10 = fArray2[n17];
                                                f9 += f10 * fArray8[n18];
                                                f8 += f10 * fArray9[n18];
                                                ++n18;
                                                n17 += n;
                                            }
                                            spectFrame.data[n8][n15 + 0] = (float)Math.sqrt(f8 * f8 + f9 * f9);
                                            spectFrame.data[n8][n15 + 1] = (float)Math.atan2(f8, f9);
                                            ++n7;
                                            n15 += 2;
                                        }
                                    }
                                    break;
                                }
                                case 2: {
                                    for (n8 = 0; n8 < n; ++n8) {
                                        n7 = 0;
                                        n15 = n8;
                                        while (n7 < n4) {
                                            spectFrame.data[n8][n7] = fArray2[n15];
                                            ++n7;
                                            n15 += n;
                                        }
                                        Wavelet.fwdTransformDaub4(spectFrame.data[n8], n4);
                                        n7 = n4 - 1 << 1;
                                        n15 = n4 - 1;
                                        while (n15 >= 0) {
                                            spectFrame.data[n8][n7 + 0] = spectFrame.data[n8][n7];
                                            spectFrame.data[n8][n7 + 1] = 0.0f;
                                            --n15;
                                            n7 -= 2;
                                        }
                                    }
                                    break;
                                }
                            }
                            ((SpectralFile)genericFile).writeFrame(spectFrame);
                            f = (float)((AudioFile)genericFile2).getFramePosition() / (float)((AudioFileDescr)object).length;
                            break;
                        }
                        default: {
                            throw new IOException(ERR_CONVERSION);
                        }
                    }
                    this.setProgression(f);
                }
                if (this.threadRunning) {
                    if (genericFile instanceof AudioFile) {
                        ((AudioFile)genericFile).close();
                    } else if (genericFile instanceof GenericFile) {
                        genericFile.close();
                    }
                    genericFile = null;
                    if (genericFile2 instanceof AudioFile) {
                        ((AudioFile)genericFile2).close();
                    } else if (genericFile2 instanceof GenericFile) {
                        genericFile2.close();
                    }
                    genericFile2 = null;
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fArray = null;
                fArray2 = null;
                spectFrame = null;
                fArray4 = null;
                fArray3 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (genericFile2 != null) {
            switch (this.inType) {
                case 1: {
                    if (spectFrame != null) {
                        ((SpectralFile)genericFile2).freeFrame(spectFrame);
                    }
                    ((SpectralFile)genericFile2).cleanUp();
                    break;
                }
                case 0: {
                    ((AudioFile)genericFile2).cleanUp();
                    break;
                }
                case 2: {
                    ((ImageFile)genericFile2).cleanUp();
                    break;
                }
            }
        }
        if (genericFile != null) {
            switch (this.outType) {
                case 1: {
                    ((SpectralFile)genericFile).cleanUp();
                    break;
                }
                case 0: {
                    ((AudioFile)genericFile).cleanUp();
                    break;
                }
                case 2: {
                    ((ImageFile)genericFile).cleanUp();
                    break;
                }
            }
        }
    }

    private void calcCosineTables(float[][] fArray, float[][] fArray2, float f, float f2, float f3, int n) {
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        double d = Math.log((double)f2 / (double)f) / (double)(n2 - 1);
        double d2 = (double)n * (Math.PI * 2) / (double)f3;
        for (int i = 0; i < n2; ++i) {
            double d3 = d2 * Math.exp((double)i * d) * (double)f;
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            for (int j = 0; j < n3; ++j) {
                double d4 = d3 * (double)j;
                fArray3[j] = (float)(Math.cos(d4) / (double)n3);
                fArray4[j] = (float)(Math.sin(d4) / (double)n3);
            }
        }
    }

    private static int readInterleaved(AudioFile audioFile, float[] fArray, int n, int n2, float[][] fArray2, int n3) throws IOException {
        assert (n2 % n3 == 0) : "invalid interleaved length";
        int n4 = n2 / n3;
        audioFile.readFrames(fArray2, 0, n4);
        for (int i = 0; i < n3; ++i) {
            int n5 = n + i;
            for (int j = 0; j < n2; j += n3) {
                fArray[n5] = fArray2[i][j];
                ++n5;
            }
        }
        return n2;
    }

    private static void writeInterleaved(AudioFile audioFile, float[] fArray, int n, int n2, float[][] fArray2, int n3) throws IOException {
        assert (n2 % n3 == 0) : "invalid interleaved length";
        int n4 = n2 / n3;
        for (int i = 0; i < n3; ++i) {
            int n5 = n + i;
            for (int j = 0; j < n2; j += n3) {
                fArray2[i][j] = fArray[n5];
                ++n5;
            }
        }
        audioFile.writeFrames(fArray2, 0, n4);
    }
}

