/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.BasicDialog;
import de.sciss.fscape.gui.CurvePanel;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Curve;
import de.sciss.fscape.util.DoublePoint;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EditEnvDlg
extends BasicDialog {
    public static final int GG_PRESETS = 1;
    public static final int GG_ADDPRESET = 2;
    public static final int GG_DELPRESET = 3;
    public static final int GG_ATK = 10;
    public static final int GG_SUS = 11;
    public static final int GG_RLS = 12;
    public static final int GG_ATKCURVE = 13;
    public static final int GG_SUSCURVE = 14;
    public static final int GG_RLSCURVE = 15;
    public static final int GG_ATKTIME = 16;
    public static final int GG_SUSTIME = 17;
    public static final int GG_RLSTIME = 18;
    public static final int GG_POINTX = 19;
    public static final int GG_POINTY = 20;
    public static final int GG_OK = 30;
    public static final int GG_CANCEL = 31;
    protected GUISupport gui;
    private boolean choice = false;
    protected static PropertyArray static_pr = null;
    protected static Presets presets = null;
    protected PropertyArray pr;
    private static final int PR_ENV = 0;
    private static final String PRN_ENV = "Env";
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"Env"};
    private final EditEnvDlg enc_this = this;

    public EditEnvDlg(Component component, Envelope envelope) {
        super(component, "Edit Curve: ", true);
        if (static_pr == null) {
            static_pr = new PropertyArray();
            EditEnvDlg.static_pr.envl = prEnvl;
            EditEnvDlg.static_pr.envl[0] = Envelope.createBasicEnvelope(0);
            EditEnvDlg.static_pr.envlName = prEnvlName;
        }
        if (presets == null) {
            presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.pr = (PropertyArray)static_pr.clone();
        this.pr.envl[0] = envelope;
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        GridBagLayout gridBagLayout = this.gui.getGridBagLayout();
        EditEnvDlgListener editEnvDlgListener = new EditEnvDlgListener(this);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new FlowLayout(3, 4, 2));
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditEnvDlg.this.addPreset();
            }
        });
        this.gui.registerGadget(jButton, 2);
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditEnvDlg.this.removePreset();
            }
        });
        this.gui.registerGadget(jButton2, 3);
        JComboBox jComboBox = new JComboBox();
        Iterator iterator = this.getPresets().presetNames().iterator();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        jComboBox.setSelectedItem("(default)");
        jButton2.setEnabled(false);
        this.gui.registerGadget(jComboBox, 1);
        jComboBox.addItemListener(editEnvDlgListener);
        jPanel.add(new JLabel("Preset:"));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jComboBox);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.gui.add(jPanel);
        GroupLabel groupLabel = new GroupLabel("Attack", 1, 12);
        GroupLabel groupLabel2 = new GroupLabel("Sustain", 1, 12);
        GroupLabel groupLabel3 = new GroupLabel("Release", 1, 12);
        gridBagConstraints.weightx = 0.17;
        gridBagConstraints.gridwidth = 2;
        this.gui.addLabel(groupLabel);
        gridBagConstraints.weightx = 0.66;
        this.gui.addLabel(groupLabel2);
        gridBagConstraints.weightx = 0.17;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(groupLabel3);
        gridBagConstraints.fill = 1;
        CurvePanel curvePanel = new CurvePanel();
        CurvePanel curvePanel2 = new CurvePanel();
        CurvePanel curvePanel3 = new CurvePanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.17;
        gridBagConstraints.gridwidth = 2;
        curvePanel.addActionListener(editEnvDlgListener);
        this.gui.addGadget(curvePanel, 13);
        gridBagConstraints.weightx = 0.66;
        curvePanel2.addActionListener(editEnvDlgListener);
        this.gui.addGadget(curvePanel2, 14);
        gridBagConstraints.weightx = 0.17;
        gridBagConstraints.gridwidth = 0;
        curvePanel3.addActionListener(editEnvDlgListener);
        this.gui.addGadget(curvePanel3, 15);
        ParamSpace[] paramSpaceArray = new ParamSpace[3];
        paramSpaceArray[0] = new ParamSpace(Constants.spaces[8]);
        paramSpaceArray[0] = new ParamSpace(paramSpaceArray[0].inc, paramSpaceArray[0].max, paramSpaceArray[0].inc, paramSpaceArray[0].unit);
        paramSpaceArray[1] = new ParamSpace(Constants.spaces[9]);
        paramSpaceArray[0] = new ParamSpace(paramSpaceArray[1].inc, paramSpaceArray[1].max, paramSpaceArray[1].inc, paramSpaceArray[1].unit);
        paramSpaceArray[2] = new ParamSpace(Constants.spaces[11]);
        paramSpaceArray[2] = new ParamSpace(paramSpaceArray[2].inc, paramSpaceArray[2].max, paramSpaceArray[2].inc, paramSpaceArray[2].unit);
        ParamField paramField = new ParamField(paramSpaceArray);
        ParamField paramField2 = new ParamField(paramSpaceArray);
        ParamField paramField3 = new ParamField(paramSpaceArray);
        JCheckBox jCheckBox = new JCheckBox();
        JCheckBox jCheckBox2 = new JCheckBox();
        JCheckBox jCheckBox3 = new JCheckBox();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.gui.addCheckbox(jCheckBox, 10, editEnvDlgListener);
        gridBagConstraints.weightx = 0.17;
        this.gui.addParamField(paramField, 16, editEnvDlgListener);
        gridBagConstraints.weightx = 0.0;
        this.gui.addCheckbox(jCheckBox2, 11, editEnvDlgListener);
        gridBagConstraints.weightx = 0.66;
        this.gui.addParamField(paramField2, 17, editEnvDlgListener);
        gridBagConstraints.weightx = 0.0;
        this.gui.addCheckbox(jCheckBox3, 12, editEnvDlgListener);
        gridBagConstraints.weightx = 0.17;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField3, 18, editEnvDlgListener);
        GroupLabel groupLabel4 = new GroupLabel("Point", 1, 12);
        gridBagConstraints.gridwidth = 4;
        this.gui.addLabel(groupLabel4);
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        ParamField paramField4 = new ParamField(Constants.spaces[8]);
        ParamField paramField5 = new ParamField(Constants.spaces[1]);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("X", 4));
        gridBagConstraints.weightx = 0.17;
        this.gui.addParamField(paramField4, 19, editEnvDlgListener);
        gridBagConstraints.weightx = 0.0;
        this.gui.addLabel(new JLabel("Y", 4));
        gridBagConstraints.weightx = 0.17;
        this.gui.addParamField(paramField5, 20, editEnvDlgListener);
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 2));
        JButton jButton3 = new JButton(" Cancel ");
        this.gui.registerGadget(jButton3, 31);
        jButton3.addActionListener(editEnvDlgListener);
        JButton jButton4 = new JButton("   OK   ");
        this.gui.registerGadget(jButton4, 30);
        jButton4.addActionListener(editEnvDlgListener);
        jPanel2.add((Component)jButton3, "West");
        jPanel2.add((Component)jButton4, "East");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.gui.add(jPanel2);
        this.envelopeToGUI();
        this.getContentPane().add(this.gui);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditEnvDlg.this.closeMe();
            }
        });
        super.initDialog();
    }

    protected void closeMe() {
        this.setVisible(false);
        try {
            this.getPresets().store();
        }
        catch (IOException iOException) {
            System.err.println("error storing presets : " + iOException.getLocalizedMessage());
        }
        this.dispose();
    }

    public void envelopeToGUI() {
        Curve curve = null;
        boolean bl = false;
        Envelope envelope = this.pr.envl[0];
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    curve = envelope.atkCurve;
                    bl = envelope.atkState;
                    break;
                }
                case 1: {
                    curve = envelope.susCurve;
                    bl = envelope.susState;
                    break;
                }
                case 2: {
                    curve = envelope.rlsCurve;
                    bl = envelope.rlsState;
                    break;
                }
            }
            CurvePanel curvePanel = (CurvePanel)this.gui.getItemObj(13 + i);
            JCheckBox jCheckBox = (JCheckBox)this.gui.getItemObj(10 + i);
            ParamField paramField = (ParamField)this.gui.getItemObj(16 + i);
            if (curvePanel == null || curve == null || jCheckBox == null || paramField == null) continue;
            curvePanel.setCurve(curve);
            curvePanel.setEnabled(bl);
            jCheckBox.setSelected(bl);
            ParamSpace paramSpace = curvePanel.getHSpace();
            paramField.setParam(new Param(paramSpace.max, paramSpace.unit));
            paramField.setEnabled(bl);
        }
    }

    public void GUIToEnvelope() {
        Curve curve = null;
        Curve curve2 = null;
        Curve curve3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        CurvePanel curvePanel = (CurvePanel)this.gui.getItemObj(13);
        if (curvePanel != null) {
            curve = curvePanel.getCurve();
            bl = curvePanel.isEnabled();
        }
        if ((curvePanel = (CurvePanel)this.gui.getItemObj(14)) != null) {
            curve2 = curvePanel.getCurve();
            bl2 = curvePanel.isEnabled();
        }
        if ((curvePanel = (CurvePanel)this.gui.getItemObj(15)) != null) {
            curve3 = curvePanel.getCurve();
            bl3 = curvePanel.isEnabled();
        }
        Envelope envelope = new Envelope(curve, curve2, curve3);
        envelope.atkState = bl;
        envelope.susState = bl2;
        envelope.rlsState = bl3;
        this.pr.envl[0] = envelope;
    }

    public PropertyArray getPropertyArray() {
        return this.pr;
    }

    public Presets getPresets() {
        return presets;
    }

    private void addPreset() {
        String string;
        JComboBox jComboBox = (JComboBox)this.gui.getItemObj(1);
        if (jComboBox != null && (string = JOptionPane.showInputDialog(this.enc_this, (Object)"Enter preset name")) != null && string.length() > 0) {
            int n;
            if (string.equals("(default)")) {
                JOptionPane.showMessageDialog(this.enc_this, "Cannot overwrite defaults!");
                return;
            }
            boolean bl = false;
            for (n = jComboBox.getItemCount() - 1; n >= 0 && !bl; --n) {
                bl = jComboBox.getItemAt(n).equals(string);
            }
            if (bl && (n = JOptionPane.showConfirmDialog(this.enc_this, "Overwrite existing preset\n\"" + string + "\"", "Confirm", 0)) != 0) {
                return;
            }
            this.GUIToEnvelope();
            PropertyArray propertyArray = this.getPropertyArray();
            Properties properties = propertyArray.toProperties(false);
            if (!properties.isEmpty() && this.getPresets().setPreset(string, properties) != null) {
                if (!bl) {
                    jComboBox.addItem(string);
                }
                jComboBox.setSelectedItem(string);
                Component component = this.gui.getItemObj(3);
                if (component != null) {
                    component.setEnabled(true);
                }
            }
        }
    }

    private void removePreset() {
        String string;
        JComboBox jComboBox = (JComboBox)this.gui.getItemObj(1);
        if (jComboBox != null && (string = jComboBox.getSelectedItem().toString()) != null) {
            if (string.equals("(default)")) {
                JOptionPane.showMessageDialog(this.enc_this, "Cannot delete defaults!");
                return;
            }
            if (this.getPresets().removePreset(string) != null) {
                Component component;
                jComboBox.removeItem(string);
                if ((jComboBox.getItemCount() == 0 || jComboBox.getSelectedItem().equals("(default)")) && (component = this.gui.getItemObj(3)) != null) {
                    component.setEnabled(false);
                }
            }
        }
    }

    public Envelope getEnvelope() {
        if (this.choice) {
            return this.pr.envl[0];
        }
        return null;
    }

    public void setJComboBox(boolean bl) {
        this.choice = bl;
    }

    private class EditEnvDlgListener
    implements ActionListener,
    AdjustmentListener,
    ItemListener,
    MouseListener,
    ParamListener {
        private EditEnvDlg dlg;
        private CurvePanel curvePanel = null;

        public EditEnvDlgListener(EditEnvDlg editEnvDlg2) {
            this.dlg = editEnvDlg2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditEnvDlg.this.gui.getItemID(actionEvent);
            String string = actionEvent.getActionCommand();
            switch (n) {
                case 13: 
                case 14: 
                case 15: {
                    Component component = EditEnvDlg.this.gui.getItemObj(19);
                    Component component2 = EditEnvDlg.this.gui.getItemObj(20);
                    if (component != null && component2 != null) {
                        if (string.equals("PointSelect") || string.equals("PointMoved")) {
                            ParamSpace paramSpace;
                            DoublePoint doublePoint = ((CurvePanel)actionEvent.getSource()).getPoint();
                            if (doublePoint == null) break;
                            if (this.curvePanel != actionEvent.getSource()) {
                                paramSpace = ((CurvePanel)actionEvent.getSource()).getHSpace();
                                ParamSpace[] paramSpaceArray = new ParamSpace[]{paramSpace};
                                ((ParamField)component).setSpaces(paramSpaceArray);
                            }
                            paramSpace = ((ParamField)component).getSpace();
                            Param param = new Param(doublePoint.x, paramSpace.unit);
                            ParamSpace paramSpace2 = ((ParamField)component2).getSpace();
                            Param param2 = new Param(doublePoint.y, paramSpace2.unit);
                            component.setEnabled(true);
                            ((ParamField)component).setParam(param);
                            component2.setEnabled(true);
                            ((ParamField)component2).setParam(param2);
                        } else if (string.equals("PointDeselect")) {
                            component.setEnabled(false);
                            component2.setEnabled(false);
                        } else if (string.equals("SpaceChange")) {
                            ParamSpace paramSpace = ((CurvePanel)actionEvent.getSource()).getHSpace();
                            ParamSpace[] paramSpaceArray = new ParamSpace[]{paramSpace};
                            ((ParamField)component).setSpaces(paramSpaceArray);
                        }
                    }
                    this.curvePanel = (CurvePanel)actionEvent.getSource();
                    break;
                }
                case 30: {
                    this.dlg.GUIToEnvelope();
                    this.dlg.setJComboBox(true);
                }
                case 31: {
                    this.dlg.closeMe();
                    break;
                }
            }
        }

        @Override
        public void paramChanged(ParamEvent paramEvent) {
            int n = EditEnvDlg.this.gui.getItemID((EventObject)((Object)paramEvent));
            switch (n) {
                case 16: 
                case 17: 
                case 18: {
                    int n2 = n - 16 + 13;
                    Component component = EditEnvDlg.this.gui.getItemObj(n2);
                    if (component == null) break;
                    ParamSpace paramSpace = ((ParamField)paramEvent.getSource()).getSpace();
                    Param param = ((ParamField)paramEvent.getSource()).getParam();
                    paramSpace = new ParamSpace(0.0, param.value, paramSpace.inc, paramSpace.unit);
                    ((CurvePanel)component).rescale(paramSpace, null);
                    break;
                }
                case 19: 
                case 20: {
                    Component component = EditEnvDlg.this.gui.getItemObj(19);
                    Component component2 = EditEnvDlg.this.gui.getItemObj(20);
                    if (component == null || component2 == null || this.curvePanel == null) break;
                    Param param = ((ParamField)component).getParam();
                    Param param2 = ((ParamField)component2).getParam();
                    DoublePoint doublePoint = new DoublePoint(param.value, param2.value);
                    this.curvePanel.setPoint(doublePoint);
                    break;
                }
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = EditEnvDlg.this.gui.getItemID(itemEvent);
            switch (n) {
                case 10: 
                case 11: 
                case 12: {
                    int n2 = n - 10 + 13;
                    int n3 = n - 10 + 16;
                    Component component = EditEnvDlg.this.gui.getItemObj(n2);
                    Component component2 = EditEnvDlg.this.gui.getItemObj(n3);
                    if (component == null || component2 == null) break;
                    component.setEnabled(((JCheckBox)itemEvent.getSource()).isSelected());
                    component2.setEnabled(((JCheckBox)itemEvent.getSource()).isSelected());
                    break;
                }
                case 1: {
                    String string;
                    Component component = EditEnvDlg.this.gui.getItemObj(1);
                    if (component == null || (string = ((JComboBox)component).getSelectedItem().toString()) == null) break;
                    PropertyArray propertyArray = this.dlg.getPropertyArray();
                    Properties properties = this.dlg.getPresets().getPreset(string);
                    propertyArray.fromProperties(false, properties);
                    this.dlg.envelopeToGUI();
                    component = EditEnvDlg.this.gui.getItemObj(3);
                    if (component == null) break;
                    component.setEnabled(!string.equals("(default)"));
                    break;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

