/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FreqModDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_MODFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_QUALITY = 3;
    private static final int PR_SOURCE = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_OSCFREQ = 1;
    private static final int PR_RATEMODDEPTH = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_MODFILE = "ModFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_SOURCE = "Source";
    private static final String PRN_OSCFREQ = "OscFreq";
    private static final String PRN_RATEMODDEPTH = "RateModDepth";
    private static final int QUAL_MEDIUM = 0;
    private static final int QUAL_GOOD = 1;
    private static final int QUAL_VERYGOOD = 2;
    private static final String[] QUAL_NAMES = new String[]{"Medium", "Good", "Very good"};
    private static final int SRC_FILE = 0;
    private static final int SRC_SINE = 1;
    private static final int SRC_TRI = 2;
    private static final String[] SRC_NAMES = new String[]{"Soundfile", "Sine", "Triangle"};
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "ModFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 1, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Quality", "Source"};
    private static final Param[] prPara = new Param[]{null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "OscFreq", "RateModDepth"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_MODFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_QUALITY = 259;
    private static final int GG_SOURCE = 260;
    private static final int GG_OSCFREQ = 513;
    private static final int GG_RATEMODDEPTH = 514;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public FreqModDlg() {
        super("Frequency Modulation");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            FreqModDlg.static_pr.text = prText;
            FreqModDlg.static_pr.textName = prTextName;
            FreqModDlg.static_pr.intg = prIntg;
            FreqModDlg.static_pr.intgName = prIntgName;
            FreqModDlg.static_pr.para = prPara;
            FreqModDlg.static_pr.para[1] = new Param(2000.0, 3);
            FreqModDlg.static_pr.para[2] = new Param(3.0, 547);
            FreqModDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(FreqModDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(FreqModDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = FreqModDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 260: {
                        ((FreqModDlg)FreqModDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        FreqModDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = FreqModDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        FreqModDlg.this.setInput(((PathField)pathEvent.getSource()).getPath().getPath());
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select carrier file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Carrier input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(16, "Select modulator file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Modulator input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1026, pathListener);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0FM$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1025, pathListener);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Modulation", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < SRC_NAMES.length; ++n) {
            jComboBox.addItem(SRC_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_SOURCE, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 260, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < QUAL_NAMES.length; ++n) {
            jComboBox2.addItem(QUAL_NAMES[n]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_QUALITY, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 259, itemListener);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[19], Constants.spaces[20], Constants.spaces[18]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mod. depth", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 514, null);
        ParamField paramField2 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Osc. freq.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 513, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block49: {
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            floatFileArray = null;
            fileArray = null;
            float[][] fArray = null;
            float[][] fArray2 = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            int n2 = 0;
            double d = 1.0;
            float f2 = 0.0f;
            try {
                int n3;
                float f3;
                float f4;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile3.getDescr();
                int n4 = audioFileDescr.channels;
                int n5 = (int)audioFileDescr.length;
                double d2 = audioFileDescr.rate;
                if (n5 * n4 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block49;
                int n6 = n4;
                int n7 = 1;
                switch (this.pr.intg[4]) {
                    case 0: {
                        audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[2]));
                        audioFileDescr2 = audioFile2.getDescr();
                        n7 = audioFileDescr2.channels;
                        n2 = (int)audioFileDescr2.length;
                        n6 = Math.max(n7, n4);
                        if (n2 * n7 < 1) {
                            throw new EOFException("File is empty");
                        }
                        if (this.threadRunning) break;
                        break block49;
                    }
                    case 1: 
                    case 2: {
                        d = this.pr.para[1].value / d2;
                    }
                }
                Param param2 = new Param(d2, 3);
                Param param3 = this.pr.para[2];
                int n8 = 4096;
                switch (this.pr.intg[3]) {
                    case 0: {
                        f4 = 0.7f;
                        f3 = 6.5f;
                        n3 = 5;
                        break;
                    }
                    case 1: {
                        f4 = 0.8f;
                        f3 = 7.0f;
                        n3 = 9;
                        break;
                    }
                    case 2: {
                        f4 = 0.86f;
                        f3 = 7.5f;
                        n3 = 15;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(this.pr.intg[3]));
                    }
                }
                int n9 = (int)((float)(n8 * n3) / f4 + 0.5f);
                float[] fArray3 = new float[n9];
                float[] fArray4 = null;
                float f5 = Filter.createAntiAliasFilter(fArray3, fArray4, n9, n8, f4, f3);
                float[][] fArrayArray = new float[][]{fArray3, fArray4, new float[2]};
                fArrayArray[2][0] = n8;
                fArrayArray[2][1] = f5;
                int n10 = 32768 / n4;
                double d3 = 0.0;
                long l = 0L;
                long l2 = (long)n5 * 2L;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr3);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                if (!this.threadRunning) break block49;
                double d4 = param2.value;
                d4 = Math.min(d4, Param.transform((Param)param3, (int)3, (Param)param2, null).value);
                d4 = Math.min(d4, Param.transform((Param)new Param((double)(-param3.value), (int)param3.unit), (int)3, (Param)param2, null).value);
                double d5 = (double)n8 * (d4 /= d2);
                int n11 = (int)((double)n9 / d5) + 1;
                int n12 = (n11 << 1) + n10;
                int n13 = (int)((double)n10 / d4) + 1;
                fArray = new float[n4][n12];
                fArray2 = new float[Math.max(n7, n6)][n13];
                double[] dArray = new double[n13];
                Util.clear(fArray);
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n6];
                    floatFileArray = new FloatFile[n6];
                    for (n = 0; n < n6; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n6; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n5;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block49;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = n11;
                boolean bl = false;
                block19: while (true) {
                    int n19;
                    double d6;
                    double d7;
                    int n20;
                    int n21;
                    float[] fArray5;
                    int n22;
                    int n23;
                    block51: {
                        block52: {
                            block50: {
                                if (!this.threadRunning || bl) break block50;
                                n23 = Math.min(n5 - n15, n12 - n18);
                                n22 = n18 + n23;
                                audioFile3.readFrames(fArray, n18, n23);
                                n15 += n23;
                                this.setProgression((float)(l += (long)n23) / (float)l2);
                                if (!this.threadRunning) break;
                                if (n22 >= n12) break block51;
                                break block52;
                            }
                            if (!this.threadRunning) break;
                            audioFile3.close();
                            audioFile3 = null;
                            audioFileDescr = null;
                            if (audioFile2 != null) {
                                audioFile2.close();
                                audioFile2 = null;
                                audioFileDescr2 = null;
                            }
                            if (this.pr.intg[2] == 0) {
                                f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                                this.normalizeAudioFile(floatFileArray, audioFile, fArray2, f, 1.0f);
                                for (n = 0; n < n6; ++n) {
                                    floatFileArray[n].cleanUp();
                                    floatFileArray[n] = null;
                                    fileArray[n].delete();
                                    fileArray[n] = null;
                                }
                            }
                            audioFile.close();
                            audioFile = null;
                            this.handleClipping(f2 *= f);
                            break;
                        }
                        for (n = 0; n < n4; ++n) {
                            fArray5 = fArray[n];
                            for (n21 = n22; n21 < n12; ++n21) {
                                fArray5[n21] = 0.0f;
                            }
                        }
                        if ((n22 += n11) <= n12) {
                            bl = true;
                        } else {
                            n22 = n12;
                        }
                    }
                    switch (this.pr.intg[4]) {
                        case 0: {
                            int n24;
                            n21 = Math.min(n2 - n16, n13 - n17);
                            audioFile2.readFrames(fArray2, 0, n21);
                            n16 += n21;
                            this.setProgression((float)l / (float)l2);
                            if (!this.threadRunning) break block19;
                            fArray5 = fArray2[0];
                            n20 = n17 + n21;
                            while (n20 < n13) {
                                dArray[n20++] = 1.0;
                            }
                            n20 = n17;
                            for (n24 = 0; n24 < n21; ++n20, ++n24) {
                                dArray[n20] = Param.transform((Param)new Param((double)(param3.value * (double)fArray5[n24]), (int)param3.unit), (int)3, (Param)param2, null).value / d2;
                            }
                            break;
                        }
                        case 1: {
                            int n24;
                            n21 = n13 - n17;
                            n20 = n17;
                            for (n24 = 0; n24 < n21; ++n20, ++n24) {
                                d7 = Math.sin((double)n16++ * d);
                                dArray[n20] = Param.transform((Param)new Param((double)(param3.value * d7), (int)param3.unit), (int)3, (Param)param2, null).value / d2;
                            }
                            break;
                        }
                        case 2: {
                            throw new IOException("Not yet implemented!");
                        }
                    }
                    double d8 = (double)n11 + d3;
                    d7 = (double)n22 - (double)n11;
                    double d9 = d8;
                    for (n19 = 0; d9 < d7 && n19 < n13; d9 += d6, ++n19) {
                        d6 = 1.0 / dArray[n19];
                    }
                    for (n = 0; n < n6; ++n) {
                        fArray5 = fArray2[n];
                        this.resample(fArray[n % n4], d8, fArray5, 0, n19, dArray, fArrayArray);
                        for (n20 = 0; n20 < n19; ++n20) {
                            if (!(Math.abs(fArray5[n20]) > f2)) continue;
                            f2 = Math.abs(fArray5[n20]);
                        }
                    }
                    d8 = d9;
                    if (floatFileArray != null) {
                        for (n = 0; n < n6; ++n) {
                            floatFileArray[n].writeFloats(fArray2[n], 0, n19);
                        }
                    } else {
                        for (n = 0; n < n6; ++n) {
                            Util.mult(fArray2[n], 0, n19, f);
                        }
                        audioFile.writeFrames(fArray2, 0, n19);
                    }
                    n14 += n19;
                    n21 = (int)(d8 - (double)n11);
                    n20 = n22 - n21;
                    d3 = d8 % 1.0;
                    n18 = n20;
                    for (n = 0; n < n4; ++n) {
                        System.arraycopy(fArray[n], n21, fArray[n], 0, n20);
                    }
                    n17 = n13 - n19;
                    System.arraycopy(dArray, n19, dArray, 0, n17);
                    this.setProgression((float)(l += (long)n23) / (float)l2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr3 = null;
                audioFileDescr2 = null;
                fArray = null;
                fArray2 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected void resample(float[] fArray, double d, float[] fArray2, int n, int n2, double[] dArray, float[][] fArray3) {
        double d2 = d;
        float[] fArray4 = fArray3[0];
        double d3 = fArray3[2][0];
        double d4 = fArray3[2][1];
        int n3 = fArray4.length;
        int n4 = fArray.length;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            double d5;
            double d6;
            double d7 = dArray[n5];
            if (d7 < 1.0) {
                d6 = d3 * d7;
                d5 = d4;
            } else {
                d6 = d3;
                d5 = d4 / d7;
            }
            double d8 = d2 % 1.0;
            double d9 = 0.0;
            double d10 = d8 * d6 + 0.5;
            int n7 = (int)d10;
            for (n6 = (int)d2; n7 < n3 && n6 >= 0; --n6) {
                d9 += (double)fArray[n6] * (double)fArray4[n7];
                n7 = (int)(d10 += d6);
            }
            d10 = (1.0 - d8) * d6;
            n7 = (int)d10;
            for (n6 = (int)d2 + 1; n7 < n3 && n6 < n4; ++n6) {
                d9 += (double)fArray[n6] * (double)fArray4[n7];
                n7 = (int)(d10 += d6);
            }
            fArray2[n++] = (float)(d9 * d5);
            ++n5;
            d2 += 1.0 / d7;
        }
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            Param param = new Param(audioFileDescr.rate, 3);
            ParamField paramField = (ParamField)this.gui.getItemObj(514);
            if (paramField != null) {
                paramField.setReference(param);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1026);
        if (component != null) {
            component.setEnabled(this.pr.intg[4] == 0);
        }
        if ((component = this.gui.getItemObj(513)) != null) {
            component.setEnabled(this.pr.intg[4] != 0);
        }
    }
}

