/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.gui.PathField;
import de.sciss.gui.PathListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GUISupport
extends JPanel {
    private final Hashtable<Integer, Component> hObj = new Hashtable();
    private final Hashtable<Object, Integer> hID = new Hashtable();
    protected final GridBagLayout lay = new GridBagLayout();
    protected final GridBagConstraints con = new GridBagConstraints();
    private int type;

    public GUISupport(int n) {
        this.setLayout(this.lay);
        this.setType(n);
    }

    public GUISupport() {
        this(-1);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public GridBagLayout getGridBagLayout() {
        return this.lay;
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.con;
    }

    public int getItemID(EventObject eventObject) {
        Integer n = this.hID.get(eventObject.getSource());
        if (n != null) {
            return n;
        }
        return -1;
    }

    public Component getItemObj(int n) {
        return this.hObj.get(new Integer(n));
    }

    public void addLabel(JLabel jLabel) {
        this.lay.setConstraints(jLabel, this.con);
        this.add(jLabel);
    }

    public void addLabel(GroupLabel groupLabel) {
        this.lay.setConstraints(groupLabel, this.con);
        this.add(groupLabel);
    }

    public void addButton(JButton jButton, int n, ActionListener actionListener) {
        this.addGadget(jButton, n);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
    }

    public void addCanvas(JComponent jComponent, int n, MouseListener mouseListener) {
        this.addGadget(jComponent, n);
        if (mouseListener != null) {
            jComponent.addMouseListener(mouseListener);
        }
    }

    public void addCheckbox(JCheckBox jCheckBox, int n, ItemListener itemListener) {
        this.addGadget(jCheckBox, n);
        if (itemListener != null) {
            jCheckBox.addItemListener(itemListener);
        }
    }

    public void addChoice(JComboBox jComboBox, int n, ItemListener itemListener) {
        this.addGadget(jComboBox, n);
        if (itemListener != null) {
            jComboBox.addItemListener(itemListener);
        }
    }

    public void addScrollbar(Scrollbar scrollbar, int n, AdjustmentListener adjustmentListener) {
        this.addGadget(scrollbar, n);
        if (adjustmentListener != null) {
            scrollbar.addAdjustmentListener(adjustmentListener);
        }
    }

    public void addScrollPane(JScrollPane jScrollPane, int n, AdjustmentListener adjustmentListener) {
        this.addGadget(jScrollPane, n);
    }

    public void addTextField(JTextField jTextField, int n, ActionListener actionListener) {
        this.addGadget(jTextField, n);
        if (actionListener != null) {
            jTextField.addActionListener(actionListener);
        }
    }

    public void addParamField(ParamField paramField, int n, ParamListener paramListener) {
        this.addGadget(paramField, n);
        if (paramListener != null) {
            paramField.addParamListener(paramListener);
        }
    }

    public void addPathField(PathField pathField, int n, PathListener pathListener) {
        this.addGadget(pathField, n);
        if (pathListener != null) {
            pathField.addPathListener(pathListener);
        }
    }

    public void addGadget(Component component, int n) {
        this.lay.setConstraints(component, this.con);
        this.add(component);
        this.registerGadget(component, n);
    }

    public void registerGadget(Component component, int n) {
        Integer n2 = new Integer(n);
        this.hObj.put(n2, component);
        this.hID.put(component, n2);
    }

    public static void addItemsToChoice(String[] stringArray, JComboBox jComboBox) {
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
    }

    public static void addItemsToChoice(Enumeration enumeration, JComboBox jComboBox, boolean bl) {
        if (bl) {
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String string2 = string.toUpperCase();
                for (n = 0; n < jComboBox.getItemCount() && string2.compareTo(jComboBox.getItemAt(n).toString().toUpperCase()) >= 0; ++n) {
                }
                jComboBox.insertItemAt(string, n);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                jComboBox.addItem(string);
            }
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void rubberGlide(Rectangle rectangle, Rectangle rectangle2, Graphics graphics) {
        for (int i = 0; i < 17; ++i) {
            int n = 16 - i;
            int n2 = rectangle.x * n + rectangle2.x * i >> 4;
            int n3 = rectangle.y * n + rectangle2.y * i >> 4;
            int n4 = (rectangle.x + rectangle.width) * n + (rectangle2.x + rectangle2.width) * i >> 4;
            int n5 = (rectangle.y + rectangle.height) * n + (rectangle2.y + rectangle2.height) * i >> 4;
            long l = System.currentTimeMillis();
            graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
            while (System.currentTimeMillis() - l < 12L) {
            }
            graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
        }
    }

    public static void fontToJTextField(Font font, JTextField jTextField) {
        jTextField.setText(font.getName() + " (" + font.getSize() + " pt)");
        jTextField.setFont(font);
    }

    public JCheckBox stringToCheckbox(String string, int n) {
        JCheckBox jCheckBox = (JCheckBox)this.getItemObj(n);
        if (jCheckBox != null) {
            try {
                boolean bl = Boolean.valueOf(string);
                jCheckBox.setSelected(bl);
                return jCheckBox;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public JComboBox stringToChoice(String string, int n) {
        JComboBox jComboBox = (JComboBox)this.getItemObj(n);
        if (jComboBox != null) {
            try {
                int n2 = Integer.parseInt(string);
                jComboBox.setSelectedIndex(n2);
                return jComboBox;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Scrollbar stringToScrollbar(String string, int n) {
        Scrollbar scrollbar = (Scrollbar)this.getItemObj(n);
        if (scrollbar != null) {
            try {
                int n2 = Integer.parseInt(string);
                scrollbar.setValue(n2);
                return scrollbar;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public JTextField stringToJTextField(String string, int n) {
        JTextField jTextField = (JTextField)this.getItemObj(n);
        if (jTextField != null) {
            jTextField.setText(string);
            return jTextField;
        }
        return null;
    }

    public PathField stringToPathField(String string, int n) {
        PathField pathField = (PathField)this.getItemObj(n);
        if (pathField != null) {
            pathField.setPath(new File(string));
            return pathField;
        }
        return null;
    }

    public ParamField stringToParamField(String string, int n) {
        ParamField paramField = (ParamField)this.getItemObj(n);
        if (paramField != null) {
            return paramField;
        }
        return null;
    }

    public String checkboxToString(int n) {
        JCheckBox jCheckBox = (JCheckBox)this.getItemObj(n);
        if (jCheckBox != null) {
            return String.valueOf(jCheckBox.isSelected());
        }
        return null;
    }

    public String choiceToString(int n) {
        JComboBox jComboBox = (JComboBox)this.getItemObj(n);
        if (jComboBox != null) {
            return String.valueOf(jComboBox.getSelectedIndex());
        }
        return null;
    }

    public String scrollbarToString(int n) {
        Scrollbar scrollbar = (Scrollbar)this.getItemObj(n);
        if (scrollbar != null) {
            return String.valueOf(scrollbar.getValue());
        }
        return null;
    }

    public String textFieldToString(int n) {
        JTextField jTextField = (JTextField)this.getItemObj(n);
        if (jTextField != null) {
            return jTextField.getText();
        }
        return null;
    }

    public String pathFieldToString(int n) {
        PathField pathField = (PathField)this.getItemObj(n);
        if (pathField != null) {
            return pathField.getPath().getPath();
        }
        return null;
    }

    public String paramFieldToString(int n) {
        return null;
    }
}

