/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.EnvIcon;
import de.sciss.fscape.gui.FilterBox;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class HilbertDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_REOUTPUTFILE = 1;
    private static final int PR_IMOUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_MODE = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_FREQ = 1;
    private static final int PR_FREQMODDEPTH = 2;
    private static final int PR_ANTIALIAS = 0;
    private static final int PR_FREQMOD = 1;
    private static final int PR_FREQENV = 0;
    private static final int MODE_UNTOUCHED = 0;
    private static final int MODE_UPSHIFT = 1;
    private static final int MODE_DOWNSHIFT = 2;
    private static final int MODE_ENVELOPE = 3;
    private static final String[] modeStr = new String[]{"Untouched", "Shift up (re+im)", "Shift down (re-im)", "Envelope (re^2+im^2)"};
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_REOUTPUTFILE = "ReOutFile";
    private static final String PRN_IMOUTPUTFILE = "ImOutFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_MODE = "Mode";
    private static final String PRN_FREQ = "Freq";
    private static final String PRN_FREQMODDEPTH = "FreqModDepth";
    private static final String PRN_ANTIALIAS = "AntiAlias";
    private static final String PRN_FREQMOD = "FreqMod";
    private static final String PRN_FREQENV = "FreqEnv";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "ReOutFile", "ImOutFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Mode"};
    private static final boolean[] prBool = new boolean[]{true, false};
    private static final String[] prBoolName = new String[]{"AntiAlias", "FreqMod"};
    private static final Param[] prPara = new Param[]{null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "Freq", "FreqModDepth"};
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"FreqEnv"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_REOUTPUTFILE = 1025;
    private static final int GG_IMOUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_MODE = 259;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_FREQ = 513;
    private static final int GG_FREQMODDEPTH = 514;
    private static final int GG_ANTIALIAS = 0;
    private static final int GG_FREQMOD = 1;
    private static final int GG_FREQENV = 1792;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public HilbertDlg() {
        super("Hilbert Filter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            HilbertDlg.static_pr.text = prText;
            HilbertDlg.static_pr.textName = prTextName;
            HilbertDlg.static_pr.intg = prIntg;
            HilbertDlg.static_pr.intgName = prIntgName;
            HilbertDlg.static_pr.bool = prBool;
            HilbertDlg.static_pr.boolName = prBoolName;
            HilbertDlg.static_pr.para = prPara;
            HilbertDlg.static_pr.para[1] = new Param(200.0, 3);
            HilbertDlg.static_pr.para[2] = new Param(12.0, 547);
            HilbertDlg.static_pr.paraName = prParaName;
            HilbertDlg.static_pr.envl = prEnvl;
            HilbertDlg.static_pr.envl[0] = Envelope.createBasicEnvelope(0);
            HilbertDlg.static_pr.envlName = prEnvlName;
            this.fillDefaultAudioDescr(HilbertDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(HilbertDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = HilbertDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 259: {
                        ((HilbertDlg)HilbertDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        HilbertDlg.this.reflectPropertyChanges();
                        break;
                    }
                    case 1: {
                        ((HilbertDlg)HilbertDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        HilbertDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output for real part");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output [Real]", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField pathField3 = new PathField(1, "Select output for imaginary part");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output [Imaginary]", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        PathField[] pathFieldArray = new PathField[]{pathField};
        PathField[] pathFieldArray2 = new PathField[]{pathField2};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Hlb$E");
        pathField3.deriveFrom(pathFieldArray2, "$D0$F0i$X0");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Post processing", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < modeStr.length; ++i) {
            jComboBox.addItem(modeStr[i]);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Operation", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, itemListener);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Antialiasing", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Shift amount", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[19], Constants.spaces[20], Constants.spaces[18]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        paramField2.setReference(paramField);
        JCheckBox jCheckBox2 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        this.gui.addCheckbox(jCheckBox2, 1, itemListener);
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 514, null);
        EnvIcon envIcon = new EnvIcon(this.getComponent());
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addGadget(envIcon, 1792);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        File[] fileArray2;
        FloatFile[] floatFileArray;
        FloatFile[] floatFileArray2;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block61: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[] fArray4;
            float[] fArray5;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr3 = null;
            floatFileArray2 = null;
            floatFileArray = null;
            fileArray2 = null;
            fileArray = null;
            float[][] fArray6 = null;
            float[][] fArray7 = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            try {
                float f3;
                double d;
                int n2;
                double d2;
                double d3;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr2 = audioFile3.getDescr();
                int n3 = audioFileDescr2.channels;
                int n4 = (int)audioFileDescr2.length;
                if (n4 * n3 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block61;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr2);
                pathField.fillStream(audioFileDescr);
                audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (this.pr.intg[3] == 0) {
                    audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                    audioFileDescr3.file = new File(this.pr.text[2]);
                    audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                }
                if (!this.threadRunning) break block61;
                boolean bl = this.pr.intg[3] == 1 || this.pr.intg[3] == 2;
                double d4 = this.pr.para[1].value;
                double d5 = d3 = audioFileDescr2.rate * 0.245;
                if (bl && this.pr.bool[0]) {
                    d2 = Math.max(0.0, d3 - d4 * 0.5);
                    d5 = this.pr.intg[3] == 1 ? d2 : (d5 += d3 - d2);
                    d3 = d2;
                }
                d5 *= Math.PI * 2 / audioFileDescr2.rate;
                d4 *= Math.PI * 2 / audioFileDescr2.rate;
                FilterBox filterBox = new FilterBox();
                filterBox.filterType = 1;
                filterBox.cutOff = new Param(d3, 3);
                Point point = filterBox.calcLength(audioFileDescr2, 3);
                int n5 = point.x * 2;
                int n6 = (point.x + point.y) * 2 - 1;
                int n7 = n6 + n6 - 1;
                for (n2 = 2; n2 < n7; n2 <<= 1) {
                }
                int n8 = n2 - n6 - 1;
                fArray5 = new float[n2 << 1];
                fArray4 = new float[n2 << 1];
                fArray3 = new float[n3][n2 + 2];
                float[][] fArray8 = new float[n3][n2 - n8];
                if (audioFile != null) {
                    fArray6 = new float[n3][n2];
                    fArray7 = new float[n3][n2 - n8];
                }
                filterBox.calcIR(audioFileDescr2, 3, 1, fArray5, point);
                Fourier.realTransform(fArray5, n2, 1);
                for (n6 = 0; n6 <= n2; n6 += 2) {
                    n7 = n6 + 1;
                    d2 = fArray5[n6];
                    d = fArray5[n7];
                    fArray5[n6] = (float)(d2 * d2 - d * d);
                    fArray5[n7] = (float)(2.0 * d2 * d);
                }
                Fourier.realTransform(fArray5, n2, -1);
                n6 = n2 - 1;
                int n9 = n6 - point.x;
                n7 = fArray5.length - 1;
                while (n6 >= 0) {
                    d2 = -d5 * (double)n9;
                    fArray5[n7--] = (float)((double)fArray5[n6] * Math.sin(d2));
                    fArray5[n7--] = (float)((double)fArray5[n6] * Math.cos(d2));
                    --n6;
                    --n9;
                }
                Fourier.complexTransform(fArray5, n2, 1);
                long l = 0L;
                long l2 = (long)n4 * (long)(2 + n3);
                if (this.pr.intg[2] == 0) {
                    fileArray2 = new File[n3];
                    floatFileArray2 = new FloatFile[n3];
                    for (n = 0; n < n3; ++n) {
                        fileArray2[n] = null;
                        floatFileArray2[n] = null;
                    }
                    for (n = 0; n < n3; ++n) {
                        fileArray2[n] = IOUtil.createTempFile();
                        floatFileArray2[n] = new FloatFile(fileArray2[n], 1);
                    }
                    if (audioFile != null) {
                        fileArray = new File[n3];
                        floatFileArray = new FloatFile[n3];
                        for (n = 0; n < n3; ++n) {
                            fileArray[n] = null;
                            floatFileArray[n] = null;
                        }
                        for (n = 0; n < n3; ++n) {
                            fileArray[n] = IOUtil.createTempFile();
                            floatFileArray[n] = new FloatFile(fileArray[n], 1);
                        }
                    }
                    l2 += (long)n4;
                } else {
                    d2 = 2.0;
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block61;
                int n10 = 0;
                int n11 = 0;
                while (this.threadRunning && n11 < n4) {
                    int n12;
                    int n13;
                    int n14 = Math.min(n8, n4 - n10);
                    for (n12 = 0; this.threadRunning && n12 < n14; n12 += n13) {
                        n13 = Math.min(8192, n14 - n12);
                        audioFile3.readFrames(fArray3, n12, n13);
                        this.setProgression((float)(l += (long)n13) / (float)l2);
                    }
                    if (!this.threadRunning) break block61;
                    for (n = 0; n < n3; ++n) {
                        fArray2 = fArray3[n];
                        for (n6 = n14; n6 < fArray2.length; ++n6) {
                            fArray2[n6] = 0.0f;
                        }
                    }
                    block19: for (n = 0; this.threadRunning && n < n3; ++n) {
                        fArray2 = fArray3[n];
                        Fourier.realTransform(fArray2, n2, 1);
                        System.arraycopy(fArray2, 0, fArray4, 0, n2);
                        n6 = n2;
                        n7 = n2;
                        while (n6 > 0) {
                            fArray4[n7] = fArray4[n6];
                            fArray4[n7 + 1] = -fArray4[n6 + 1];
                            n6 -= 2;
                            n7 += 2;
                        }
                        Fourier.complexMult(fArray5, 0, fArray4, 0, fArray4, 0, n2 << 1);
                        Fourier.complexTransform(fArray4, n2, -1);
                        this.setProgression((float)(l += (long)n14) / (float)l2);
                        if (this.threadRunning) {
                            switch (this.pr.intg[3]) {
                                case 1: {
                                    n7 = 0;
                                    n9 = n10;
                                    for (n6 = 0; n6 < n2; ++n6) {
                                        d2 = d4 * (double)n9++;
                                        fArray2[n6] = (float)((double)fArray4[n7++] * Math.cos(d2) + (double)fArray4[n7++] * Math.sin(d2));
                                    }
                                    continue block19;
                                }
                                case 2: {
                                    n7 = 0;
                                    n9 = n10;
                                    for (n6 = 0; n6 < n2; ++n6) {
                                        d2 = d4 * (double)n9++;
                                        fArray2[n6] = (float)((double)fArray4[n7++] * Math.cos(d2) - (double)fArray4[n7++] * Math.sin(d2));
                                    }
                                    continue block19;
                                }
                                case 3: {
                                    n7 = 0;
                                    for (n6 = 0; n6 < n2; ++n6) {
                                        d2 = fArray4[n7++];
                                        d = fArray4[n7++];
                                        fArray2[n6] = (float)Math.sqrt(d2 * d2 + d * d);
                                    }
                                    continue block19;
                                }
                                default: {
                                    fArray = fArray6[n];
                                    n7 = 0;
                                    for (n6 = 0; n6 < n2; ++n6) {
                                        fArray2[n6] = fArray4[n7++];
                                        fArray[n6] = fArray4[n7++];
                                    }
                                }
                            }
                            continue;
                        }
                        break block61;
                    }
                    n10 += n14;
                    for (n = 0; n < n3; ++n) {
                        Util.add(fArray8[n], 0, fArray3[n], 0, n2 - n8);
                        System.arraycopy(fArray3[n], n14, fArray8[n], 0, n2 - n8);
                        if (fArray6 == null) continue;
                        Util.add(fArray7[n], 0, fArray6[n], 0, n2 - n8);
                        System.arraycopy(fArray6[n], n14, fArray7[n], 0, n2 - n8);
                    }
                    n14 = Math.min(n8, n4 - n11);
                    if (floatFileArray2 != null) {
                        n12 = n5;
                        while (this.threadRunning && n12 < n14) {
                            n13 = Math.min(8192, n14 - n12);
                            for (n = 0; n < n3; ++n) {
                                floatFileArray2[n].writeFloats(fArray3[n], n12, n13);
                                if (floatFileArray == null) continue;
                                floatFileArray[n].writeFloats(fArray6[n], n12, n13);
                            }
                            n12 += n13;
                            n11 += n13;
                            this.setProgression((float)(l += (long)n13) / (float)l2);
                        }
                    } else {
                        for (n = 0; n < n3; ++n) {
                            Util.mult(fArray3[n], 0, n14, f);
                        }
                        n12 = n5;
                        while (this.threadRunning && n12 < n14) {
                            n13 = Math.min(8192, n14 - n12);
                            audioFile2.writeFrames(fArray3, n12, n13);
                            if (audioFile != null) {
                                audioFile.writeFrames(fArray6, n12, n13);
                            }
                            n12 += n13;
                            n11 += n13;
                            this.setProgression((float)(l += (long)n13) / (float)l2);
                        }
                    }
                    if (this.threadRunning) {
                        for (n = 0; n < n3; ++n) {
                            fArray2 = fArray3[n];
                            for (n6 = n5; n6 < n14; ++n6) {
                                f3 = Math.abs(fArray2[n6]);
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                            }
                            if (fArray6 == null) continue;
                            fArray2 = fArray6[n];
                            for (n6 = n5; n6 < n14; ++n6) {
                                f3 = Math.abs(fArray2[n6]);
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                            }
                        }
                        if (n5 <= 0) continue;
                        n5 = Math.max(0, n5 - n14);
                        continue;
                    }
                    break block61;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        Param param2 = new Param(f2, 1);
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / param2.value), (int)param2.unit), null).value;
                        f3 = audioFile != null ? (1.0f + this.getProgression()) / 2.0f : 1.0f;
                        this.normalizeAudioFile(floatFileArray2, audioFile2, fArray3, f, f3);
                        if (audioFile != null) {
                            this.normalizeAudioFile(floatFileArray, audioFile, fArray3, f, 1.0f);
                        }
                        f2 *= f;
                        for (n = 0; n < n3; ++n) {
                            floatFileArray2[n].cleanUp();
                            floatFileArray2[n] = null;
                            fileArray2[n].delete();
                            fileArray2[n] = null;
                            if (floatFileArray == null) continue;
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr = null;
                        if (audioFile != null) {
                            audioFile.close();
                            audioFile = null;
                            audioFileDescr3 = null;
                        }
                        audioFile3.close();
                        audioFile3 = null;
                        audioFileDescr2 = null;
                        fArray5 = null;
                        fArray4 = null;
                        fArray3 = null;
                        fArray6 = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr2 = null;
                audioFileDescr = null;
                audioFileDescr3 = null;
                fArray3 = null;
                fArray6 = null;
                fArray5 = null;
                fArray4 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
            audioFile3 = null;
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray2 != null) {
            for (n = 0; n < floatFileArray2.length; ++n) {
                if (floatFileArray2[n] != null) {
                    floatFileArray2[n].cleanUp();
                    floatFileArray2[n] = null;
                }
                if (fileArray2[n] == null) continue;
                fileArray2[n].delete();
                fileArray2[n] = null;
            }
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
                fileArray[n] = null;
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        boolean bl;
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1026);
        if (component != null) {
            component.setEnabled(this.pr.intg[3] == 0);
        }
        component = this.gui.getItemObj(513);
        boolean bl2 = bl = this.pr.intg[3] == 1 || this.pr.intg[3] == 2;
        if (component != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(1)) != null) {
            component.setEnabled(bl);
        }
        if ((component = this.gui.getItemObj(514)) != null) {
            component.setEnabled(bl && this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(1792)) != null) {
            component.setEnabled(bl && this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(0)) != null) {
            component.setEnabled(bl);
        }
    }
}

