/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.Dragable;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.spect.SpectStreamSlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Vector;
import javax.swing.JPanel;

public class OpConnector
extends JPanel
implements Dragable {
    private static final int ibWidth = 19;
    private static final int ibHeight = 19;
    public static final String OBJ_NAME = "OpConnector";
    public static final int ARROW_WIDTH = 19;
    public static final int ARROW_HEIGHT = 19;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SELECTED = 3;
    private static final Path2D shpArrow = new Path2D.Float(1, 5);
    private static final AffineTransform rotateArrow = new AffineTransform();
    private static final int STATE_UNKNOWN = -1;
    private int state = -1;
    private SpectStreamSlot origin;
    private OpIcon srcIcon;
    private OpIcon destIcon;
    private Point srcLoc;
    private Point destLoc;
    private int anchor;
    private Point srcP;
    private Point destP;
    private Point thisP;
    private String labName = null;
    private int width;
    private int height;
    private FontMetrics fntMetr;

    public OpConnector(SpectStreamSlot spectStreamSlot) {
        this.setOpaque(true);
        this.origin = spectStreamSlot;
        SpectStreamSlot spectStreamSlot2 = spectStreamSlot.getLinked();
        Operator operator = spectStreamSlot.getOwner();
        this.srcIcon = (OpIcon)operator.getIcon();
        String string = spectStreamSlot.toString();
        if (string.equals("out")) {
            string = "";
        }
        Operator operator2 = spectStreamSlot2.getOwner();
        this.destIcon = (OpIcon)operator2.getIcon();
        String string2 = spectStreamSlot2.toString();
        if (string2.equals("in")) {
            string2 = "";
        }
        if (string.length() > 0 || string2.length() > 0) {
            this.labName = string + '>' + string2;
            this.newVisualProps();
        } else {
            this.width = 8;
            this.height = 8;
        }
        Vector<SpectStreamSlot> vector = operator.getSlots(32);
        this.anchor = vector.size() > 1 ? -1 : 0;
        vector = operator2.getSlots(16);
        this.anchor += vector.size() > 1 ? 1 : 0;
        this.srcLoc = this.srcIcon.getLocation();
        Dimension dimension = this.srcIcon.getSize();
        this.srcP = new Point(this.srcLoc.x + (dimension.width >> 1), this.srcLoc.y + (dimension.height >> 1));
        this.destLoc = this.destIcon.getLocation();
        dimension = this.destIcon.getSize();
        this.destP = new Point(this.destLoc.x + (dimension.width >> 1), this.destLoc.y + (dimension.height >> 1));
        this.thisP = new Point(this.destP.x + this.srcP.x - this.width >> 1, this.destP.y + this.srcP.y - this.height >> 1);
        this.setSize(this.width, this.height);
        this.setLocation(this.thisP.x, this.thisP.y);
        this.setSelected(0);
        this.setVisible(this.labName != null);
        this.newVisualProps();
        this.enableEvents(4L);
        this.enableEvents(16L);
        this.setFocusable(false);
    }

    @Override
    public String toString() {
        return OBJ_NAME;
    }

    public SpectStreamSlot getOrigin() {
        return this.origin;
    }

    public int setSelected(int n) {
        int n2 = this.state;
        this.state = n;
        if (n2 != n) {
            if (n == 0) {
                this.setForeground(SystemColor.control);
                this.setBackground(SystemColor.control);
            } else {
                this.setForeground(OpIcon.selectColor);
                this.setBackground(OpIcon.selectColor);
            }
            this.repaint();
        }
        return n2;
    }

    public int isSelected() {
        return this.state;
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.isVisible()) {
            OpConnector.calcArrow(this.srcIcon, this, this.srcP, this.thisP, 2, 0);
            OpConnector.calcArrow(this, this.destIcon, this.thisP, this.destP, 0, 2);
        } else {
            OpConnector.calcArrow(this.srcIcon, this, this.srcP, this.thisP, 2, 0);
            OpConnector.calcArrow(this.srcIcon, this.destIcon, this.srcP, this.destP, 2, 2);
        }
    }

    public void adjustLocation() {
        Point point = this.getLocation();
        Point point2 = this.srcIcon.getLocation();
        Point point3 = this.destIcon.getLocation();
        switch (this.anchor) {
            case -1: {
                point.translate(point2.x - this.srcLoc.x, point2.y - this.srcLoc.y);
                break;
            }
            case 1: {
                point.translate(point3.x - this.destLoc.x, point3.y - this.destLoc.y);
                break;
            }
            default: {
                point.translate(point2.x - this.srcLoc.x + point3.x - this.destLoc.x >> 1, point2.y - this.srcLoc.y + point3.y - this.destLoc.y >> 1);
            }
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.srcLoc = point2;
        this.destLoc = point3;
        this.setLocation(point.x, point.y);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.clearRect(0, 0, n, n2);
        graphics.draw3DRect(1, 1, this.width - 3, this.height - 3, true);
        graphics.setColor(Color.black);
        if (this.labName != null) {
            graphics.drawString(this.labName, 2, this.fntMetr.getAscent());
        }
    }

    public void drawArrowCorrect(Graphics2D graphics2D) {
        if (this.isVisible()) {
            graphics2D.drawLine(this.srcP.x, this.srcP.y, this.thisP.x, this.thisP.y);
            OpConnector.drawArrow(graphics2D, this.thisP.x, this.thisP.y, this.destP.x, this.destP.y, true);
        } else {
            OpConnector.drawArrow(graphics2D, this.srcP.x, this.srcP.y, this.destP.x, this.destP.y, true);
        }
    }

    public void drawArrow(boolean bl) {
        Container container = this.getParent();
        if (container != null) {
            Point point;
            Graphics2D graphics2D = (Graphics2D)container.getGraphics();
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(bl ? Color.black : container.getBackground());
                if (this.isVisible()) {
                    graphics2D.drawLine(this.srcP.x, this.srcP.y, this.thisP.x, this.thisP.y);
                    OpConnector.drawArrow(graphics2D, this.thisP.x, this.thisP.y, this.destP.x, this.destP.y, bl);
                } else {
                    OpConnector.drawArrow(graphics2D, this.srcP.x, this.srcP.y, this.destP.x, this.destP.y, bl);
                }
                graphics2D.dispose();
            }
            if ((graphics2D = (Graphics2D)this.srcIcon.getGraphics()) != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                point = this.isVisible() ? this.thisP : this.destP;
                graphics2D.setColor(bl ? Color.black : container.getBackground());
                graphics2D.drawLine(this.srcP.x - this.srcLoc.x, this.srcP.y - this.srcLoc.y, point.x - this.srcLoc.x, point.y - this.srcLoc.y);
                graphics2D.dispose();
            }
            if ((graphics2D = (Graphics2D)this.destIcon.getGraphics()) != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                point = this.isVisible() ? this.thisP : this.srcP;
                graphics2D.setColor(bl ? Color.black : container.getBackground());
                OpConnector.drawArrow(graphics2D, point.x - this.destLoc.x, point.y - this.destLoc.y, this.destP.x - this.destLoc.x, this.destP.y - this.destLoc.y, bl);
                graphics2D.dispose();
                if (!bl) {
                    this.destIcon.repaint();
                }
            }
        }
    }

    public static void drawArrow(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        graphics2D.drawLine(n, n2, n3, n4);
        if (bl) {
            double d = Math.atan2(n3 - n, -n4 + n2);
            rotateArrow.setToRotation(d);
            Shape shape = rotateArrow.createTransformedShape(shpArrow);
            graphics2D.translate(n3, n4);
            graphics2D.fill(shape);
            graphics2D.translate(-n3, -n4);
        } else {
            graphics2D.fillRect(n3 - 9, n4 - 9, 19, 19);
        }
    }

    public static void calcArrow(Component component, Component component2, Point point, Point point2, int n, int n2) {
        double d;
        String string;
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = component2.getBounds();
        point.setLocation(rectangle.x + (rectangle.width >> 1), rectangle.y + (rectangle.height >> 1));
        point2.setLocation(rectangle2.x + (rectangle2.width >> 1), rectangle2.y + (rectangle2.height >> 1));
        double d2 = Math.atan2(point2.x - point.x, -point2.y + point.y) - 1.5707963267948966;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        if (n > 0) {
            string = component.toString();
            if (string.equals("OpIcon")) {
                point.translate((int)((double)((rectangle.width >> 1) + n) * d3), (int)((double)((rectangle.height >> 1) + n) * d4));
            } else {
                d = d3 == 0.0 ? (double)(point.y - rectangle.y) : (d4 == 0.0 ? (double)(point.x - rectangle.x) : Math.min((double)(d3 < 0.0 ? rectangle.x - point.x : rectangle.x + rectangle.width - point.x) / d3, (double)(d4 > 0.0 ? point.y - rectangle.y : point.y - rectangle.y - rectangle.height) / d4));
                point.translate((int)((d + (double)n) * d3), (int)((d + (double)n) * d4));
            }
        }
        if (n2 > 0) {
            string = component2.toString();
            if (string.equals("OpIcon")) {
                Rectangle rectangle3;
                point2.translate((int)(-((double)((rectangle2.width >> 1) + n2 + 9) * d3)), (int)(-((double)((rectangle2.height >> 1) + n2 + 9) * d4)));
                if (!(d2 >= 0.0) && !(d2 <= -Math.PI) && (rectangle3 = ((OpIcon)component2).getLabel().getBounds()).contains(point2.x + (int)((d = (double)(rectangle3.y + (rectangle3.height >> 1) - point2.y) - 4.0 * d4) / Math.tan(d2)), point2.y + (int)d)) {
                    point2.translate((int)((d += (double)((rectangle3.height >> 1) + 9)) / Math.tan(d2)), (int)d);
                }
            } else {
                d = d3 == 0.0 ? (double)(point2.y - rectangle2.y) : (d4 == 0.0 ? (double)(point2.x - rectangle2.x) : Math.min((double)(d3 < 0.0 ? rectangle2.x - point2.x : rectangle2.x + rectangle2.width - point2.x) / d3, (double)(d4 > 0.0 ? point2.y - rectangle2.y : point2.y - rectangle2.y - rectangle2.height) / d4));
                point2.translate((int)(-((d + (double)n2) * d3)), (int)(-((d + (double)n2) * d4)));
            }
        }
    }

    public static int getDistance(OpConnector opConnector, int n, int n2) {
        Point[] pointArray;
        Point[] pointArray2;
        Rectangle rectangle = new Rectangle();
        int n3 = -1;
        if (opConnector.isVisible()) {
            pointArray2 = new Point[2];
            pointArray = new Point[2];
            pointArray2[0] = opConnector.srcP;
            pointArray2[1] = opConnector.thisP;
            pointArray[0] = opConnector.thisP;
            pointArray[1] = opConnector.destP;
        } else {
            pointArray2 = new Point[1];
            pointArray = new Point[1];
            pointArray2[0] = opConnector.srcP;
            pointArray[0] = opConnector.destP;
        }
        for (int i = 0; i < pointArray2.length; ++i) {
            int n4 = Math.min(pointArray2[i].x, pointArray[i].x);
            int n5 = Math.min(pointArray2[i].y, pointArray[i].y);
            int n6 = Math.max(pointArray2[i].x, pointArray[i].x);
            int n7 = Math.max(pointArray2[i].y, pointArray[i].y);
            rectangle.setBounds(n4 - 4, n5 - 4, n6 - n4 + 8, n7 - n5 + 8);
            if (!rectangle.contains(n, n2)) continue;
            double d = Math.sqrt((n - pointArray2[i].x) * (n - pointArray2[i].x) + (n2 - pointArray2[i].y) * (n2 - pointArray2[i].y));
            double d2 = Math.atan2(pointArray[i].x - pointArray2[i].x, -pointArray[i].y + pointArray2[i].y) - 1.5707963267948966;
            double d3 = (double)pointArray2[i].x + d * Math.cos(d2);
            double d4 = (double)pointArray2[i].y + d * Math.sin(d2);
            d = Math.sqrt((d3 - (double)n) * (d3 - (double)n) + (d4 - (double)n2) * (d4 - (double)n2));
            if (n3 != -1 && !(d < (double)n3)) continue;
            n3 = (int)d;
        }
        return n3;
    }

    @Override
    public void paintScheme(Graphics graphics, int n, int n2, boolean bl) {
        graphics.drawRect(n - (this.width >> 1), n2 - (this.height >> 1), this.width - 1, this.height - 1);
    }

    private void newVisualProps() {
        if (this.labName != null) {
            Font font = this.getFont();
            this.fntMetr = this.getFontMetrics(font);
            this.width = this.fntMetr.stringWidth(this.labName) + 4;
            this.height = this.fntMetr.getHeight();
            if (this.isVisible()) {
                this.repaint();
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.requestFocus();
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            this.setSelected(3);
        } else if (focusEvent.getID() == 1005) {
            this.setSelected(0);
        }
        super.processFocusEvent(focusEvent);
    }

    static {
        shpArrow.moveTo(-4.0, 0.0);
        shpArrow.lineTo(0.0, -8.0);
        shpArrow.lineTo(4.0, 0.0);
        shpArrow.closePath();
    }
}

