/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.IconBitmap;
import de.sciss.fscape.gui.IconicComponent;
import de.sciss.fscape.gui.OpIconLabel;
import de.sciss.fscape.op.Operator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JComponent;

public class OpIcon
extends IconicComponent {
    private static final int ibWidth = 45;
    private static final int ibHeight = 45;
    private static IconBitmap opib = null;
    private static IconicComponent[] basicIcons;
    private static DataFlavor[] flavors;
    public static final String OBJ_NAME = "OpIcon";
    public static DataFlavor op_flavor;
    public static final int ICON_WIDTH = 45;
    public static final int ICON_HEIGHT = 45;
    public static final int ID_INPUT = 8;
    public static final int ID_OUTPUT = 9;
    public static final int ID_FOLDER = 10;
    public static final int ID_FLIPTIME = 11;
    public static final int ID_FLIPFREQ = 12;
    public static final int ID_SHARED = 13;
    public static final int ID_UNITOR = 14;
    public static final int ID_SPLITTER = 15;
    public static final int ID_MONO2STEREO = 16;
    public static final int ID_SMEAR = 17;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_FRIENDLY = 4;
    public static final int STATE_BYPASS = 5;
    public static Color progColor;
    public static Color normalColor;
    public static Color selectColor;
    private static final int STATE_UNKNOWN = -1;
    private static final int STATE_SELECTED = 3;
    private Operator op;
    private OpIconLabel lab;
    private int opFlags;
    private int state = -1;
    private int statePlus = 0;

    public OpIcon(Operator operator, int n, String string) {
        super(OpIcon.getIconBitmap(), n);
        this.op = operator;
        if (op_flavor == null) {
            op_flavor = new DataFlavor(this.getClass(), "Operator Icon");
        }
        this.lab = new OpIconLabel(this, string);
        this.opFlags = ~operator.getFlags();
        this.operatorFlagsChanged(~this.opFlags);
        this.setSize(this.getPreferredSize());
        this.setLocation(0, 0);
        this.enableEvents(4L);
        this.enableEvents(16L);
    }

    public OpIcon(Operator operator) {
        this(operator, -1, "Untitled");
    }

    protected static synchronized IconBitmap getIconBitmap() {
        if (opib == null) {
            Image image = Toolkit.getDefaultToolkit().getImage(OpIcon.class.getResource("op.png"));
            opib = new IconBitmap(image, 45, 45);
            basicIcons = new IconicComponent[5];
            for (int i = 0; i < basicIcons.length; ++i) {
                OpIcon.basicIcons[i] = new IconicComponent(opib, i);
            }
        }
        return opib;
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.lab.updateLocation();
    }

    public Rectangle getUnionBounds() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.lab.getBounds();
        Rectangle rectangle3 = new Rectangle(Math.min(rectangle.x, rectangle2.x), rectangle.y, Math.max(rectangle.width, rectangle2.width), rectangle.height + rectangle2.height);
        return rectangle3;
    }

    public void addTo(JComponent jComponent) {
        jComponent.add(this);
        jComponent.add(this.lab);
        jComponent.revalidate();
        jComponent.repaint();
    }

    public void removeFrom(JComponent jComponent) {
        jComponent.remove(this);
        jComponent.remove(this.lab);
        jComponent.revalidate();
        jComponent.repaint();
    }

    public Operator getOperator() {
        return this.op;
    }

    public OpIconLabel getLabel() {
        return this.lab;
    }

    @Override
    public void setName(String string) {
        this.lab.setName(string);
    }

    @Override
    public String getName() {
        return this.lab.getName();
    }

    @Override
    public String toString() {
        return OBJ_NAME;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        basicIcons[this.state + this.statePlus].paint(graphics);
        opib.paint(graphics, this.ID, 0, 0);
        if (!this.op.threadDead) {
            this.paintProgress(graphics);
        }
    }

    public void paintProgress(Graphics graphics) {
        Graphics graphics2;
        int n = (int)(this.op.getProgress() * 360.0f);
        Graphics graphics3 = graphics2 = graphics != null ? graphics : this.getGraphics();
        if (graphics2 != null) {
            graphics2.setColor(progColor);
            graphics2.drawArc(1, 1, 43, 43, 90, n);
            graphics2.drawArc(2, 2, 41, 41, 90, n);
            if (graphics == null) {
                graphics2.dispose();
            }
        }
    }

    public int setSelected(int n) {
        int n2 = this.state;
        this.state = n;
        if (n2 != n) {
            this.repaint();
            this.lab.repaint();
        }
        return n2;
    }

    public int isSelected() {
        return this.state;
    }

    public void operatorFlagsChanged(int n) {
        if (((n ^ this.opFlags) & 2) != 0) {
            this.setSelected((n & 2) == 0 ? 0 : 5);
        }
        this.opFlags = n;
        this.lab.operatorFlagsChanged(n);
    }

    @Override
    public void paintScheme(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n2 - 22;
        Dimension dimension = this.lab.getSize();
        graphics.drawOval(n - 22, n3, 44, 44);
        graphics.drawRect(n - (dimension.width >> 1), n3 + 45, dimension.width - 1, dimension.height - 1);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (flavors == null) {
            DataFlavor[] dataFlavorArray = super.getTransferDataFlavors();
            flavors = new DataFlavor[dataFlavorArray.length + 1];
            OpIcon.flavors[0] = op_flavor;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                OpIcon.flavors[i + 1] = dataFlavorArray[i];
            }
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(op_flavor)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.getName();
        }
        return super.getTransferData(dataFlavor);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.requestFocus();
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = this.statePlus;
        if (focusEvent.getID() == 1004) {
            this.lab.setFocus(true);
            this.statePlus = this.state == 0 ? 3 : 0;
        } else if (focusEvent.getID() == 1005) {
            this.lab.setFocus(false);
            this.statePlus = 0;
        }
        if (this.statePlus != n) {
            this.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    static {
        flavors = null;
        op_flavor = null;
        progColor = new Color(255, 160, 0);
        normalColor = new Color(152, 179, 132);
        selectColor = new Color(100, 115, 162);
    }
}

