/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.OpIcon;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class OpIconLabel
extends JComponent {
    public static final String OBJ_NAME = "OpIconLabel";
    private String labName;
    private int labNameWidth = 0;
    private int opFlags;
    private OpIcon icon;

    public OpIconLabel(OpIcon opIcon, String string) {
        this.icon = opIcon;
        this.labName = string;
        this.opFlags = opIcon.getOperator().getFlags();
        this.setFont(UIManager.getFont("Label.font"));
        this.newVisualProps();
        this.setFocus(false);
    }

    @Override
    public void setName(String string) {
        this.labName = string;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.labNameWidth = fontMetrics.stringWidth(string);
            this.setSize(this.getPreferredSize());
            this.updateLocation();
        }
    }

    @Override
    public String getName() {
        return this.labName;
    }

    public void operatorFlagsChanged(int n) {
        if (((n ^ this.opFlags) & 1) != 0) {
            this.opFlags = n;
            this.newVisualProps();
        } else {
            this.opFlags = n;
        }
    }

    public void setFocus(boolean bl) {
    }

    @Override
    public String toString() {
        return OBJ_NAME;
    }

    public OpIcon getOpIcon() {
        return this.icon;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.labName, 2, fontMetrics.getAscent());
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension(this.labNameWidth + 4, fontMetrics.getHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void updateLocation() {
        Point point = this.icon.getLocation();
        this.setLocation(point.x + (45 - this.labNameWidth >> 1) - 2, point.y + 45);
    }

    private void newVisualProps() {
        Font font = this.getFont();
        if ((this.opFlags & 1) != 0) {
            font = new Font(font.getName(), 2, font.getSize());
        }
        this.setName(this.labName);
        if (this.isVisible()) {
            this.repaint();
        }
    }
}

