/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SedimentDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_PATTERNFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_CHANTYPE = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_WINSIZE = 1;
    private static final int PR_MAXBOOST = 2;
    private static final int PR_TIMESCALE = 3;
    private static final int PR_MINGRAINLEN = 4;
    private static final int PR_MAXGRAINLEN = 5;
    private static final int PR_CLUMP = 6;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_PATTERNFILE = "PtrnFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_WINSIZE = "WinSize";
    private static final String PRN_MAXBOOST = "MaxBoost";
    private static final String PRN_TIMESCALE = "TimeScale";
    private static final String PRN_CHANTYPE = "ChanType";
    private static final String PRN_MINGRAINLEN = "MinGrainLen";
    private static final String PRN_MAXGRAINLEN = "MaxGrainLen";
    private static final String PRN_CLUMP = "Clump";
    private static final int CHAN_MIN = 0;
    private static final int CHAN_MAX = 1;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "PtrnFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "ChanType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "WinSize", "MaxBoost", "TimeScale", "MinGrainLen", "MaxGrainLen", "Clump"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_PATTERNFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_CHANTYPE = 259;
    private static final int GG_GAIN = 512;
    private static final int GG_WINSIZE = 513;
    private static final int GG_MAXBOOST = 514;
    private static final int GG_TIMESCALE = 515;
    private static final int GG_MINGRAINLEN = 516;
    private static final int GG_MAXGRAINLEN = 517;
    private static final int GG_CLUMP = 518;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHANNELS = "Input + pattern must share\nsame # of channels!";
    private static final boolean checkNaN = false;
    private static final boolean verbose = false;

    public SedimentDlg() {
        super("Sediment");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SedimentDlg.static_pr.text = prText;
            SedimentDlg.static_pr.textName = prTextName;
            SedimentDlg.static_pr.intg = prIntg;
            SedimentDlg.static_pr.intgName = prIntgName;
            SedimentDlg.static_pr.para = prPara;
            SedimentDlg.static_pr.para[1] = new Param(20.0, 18);
            SedimentDlg.static_pr.para[2] = new Param(20.0, 785);
            SedimentDlg.static_pr.para[3] = new Param(100.0, 18);
            SedimentDlg.static_pr.para[4] = new Param(100.0, 2);
            SedimentDlg.static_pr.para[5] = new Param(1000.0, 2);
            SedimentDlg.static_pr.para[6] = new Param(1.0, 0);
            SedimentDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SedimentDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(SedimentDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Control input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select matching pattern file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Pattern input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Sedi$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Plot output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Plotter settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[10]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Time scale", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 515, null);
        ParamField paramField2 = new ParamField(new ParamSpace(1.0, 65536.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_CLUMP, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 518, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        ParamField paramField3 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min. grain length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 516, null);
        ParamField paramField4 = new ParamField(new ParamSpace[]{Constants.spaces[5], Constants.spaces[7]});
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Max boost", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 514, null);
        ParamField paramField5 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max. grain length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 517, null);
        ParamField paramField6 = new ParamField(Constants.spaces[11]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Win size", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField6, 513, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Minimum");
        jComboBox.addItem("Maximum");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 3;
        this.gui.addLabel(new JLabel("Multichannel correlation", 4));
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 259, itemListener);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block43: {
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            double d = this.pr.para[1].value / 100.0;
            double d2 = this.pr.para[3].value / 100.0;
            int n = this.pr.intg[3];
            float f3 = (float)Param.transform((Param)this.pr.para[2], (int)1, (Param)param, null).value;
            double d3 = Math.min(this.pr.para[4].value, this.pr.para[5].value);
            double d4 = Math.max(this.pr.para[4].value, this.pr.para[5].value);
            double d5 = d4 / d3;
            Random random = new Random();
            try {
                int n2;
                int n3;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                AudioFileDescr audioFileDescr = audioFile3.getDescr();
                int n4 = audioFileDescr.channels;
                long l = audioFileDescr.length;
                if (l < 1L || n4 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block43;
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                AudioFileDescr audioFileDescr2 = audioFile.getDescr();
                int n5 = audioFileDescr2.channels;
                long l2 = audioFileDescr2.length;
                if (l2 < 1L || n5 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block43;
                if (n4 != n5) {
                    throw new IOException(ERR_CHANNELS);
                }
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr3);
                audioFileDescr3.channels = n3 = n4;
                audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                AudioFile audioFile4 = this.createTempFile(audioFileDescr3);
                if (!this.threadRunning) break block43;
                int n6 = (int)this.pr.para[6].value;
                float[][] fArray = new float[n6][n4];
                long[][] lArray = new long[n6][n4];
                boolean[][] blArray = new boolean[n6][n4];
                int n7 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d4) + 0.5);
                int n8 = Util.nextPowerOfTwo(n7 + n7 - 1);
                int n9 = Math.max(8192, n8 + 2);
                float[][] fArray2 = new float[n4][n9];
                float[][][] fArray3 = new float[n6][n4][n8 + 2];
                float[][][] fArray4 = new float[n6][n4][n7];
                float[] fArray5 = new float[n6];
                boolean[] blArray2 = new boolean[n6];
                long[] lArray2 = new long[n6];
                float[] fArray6 = new float[n6];
                float[] fArray7 = new float[n6];
                boolean[] blArray3 = new boolean[n6];
                long[] lArray3 = new long[n6];
                float[] fArray8 = new float[n6];
                float[] fArray9 = new float[n8 + 2];
                long l3 = (long)((double)l * d2 + 0.5) + (long)n7;
                long l4 = l2 + l2 * l + l3 * 3L;
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                block7: while (this.threadRunning && l7 < l2) {
                    float f4;
                    double d6;
                    int n10;
                    int n11 = Math.max(2, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)(Math.pow(d5, random.nextFloat()) * d3)) + 0.5) & 0xFFFFFFFE);
                    int n12 = n11 >> 1;
                    int n13 = Util.nextPowerOfTwo(n11 + n11 - 1);
                    int n14 = Math.max(2, (int)((double)n11 * d + 0.5) & 0xFFFFFFFE);
                    int n15 = n14 >> 1;
                    float[] fArray10 = Filter.createFullWindow(n14, 7);
                    int n16 = 0;
                    long l8 = 0L;
                    int n17 = 0;
                    while (this.threadRunning && n17 < n6 && l7 < l2) {
                        n2 = (int)Math.min(l2 - l7, (long)n11);
                        audioFile.readFrames(fArray4[n17], 0, n2);
                        l7 += (long)n2;
                        if (n2 < n11) {
                            Util.clear(fArray4[n17], n2, n11 - n2);
                        }
                        Util.mult(fArray10, 0, fArray4[n17], 0, n15);
                        Util.mult(fArray10, n15, fArray4[n17], n11 - n15, n15);
                        Util.copy(fArray4[n17], 0, fArray3[n17], 0, n2);
                        Util.clear(fArray3[n17], n2, n13 - n2);
                        Util.reverse(fArray3[n17], 0, n11);
                        fArray6[n17] = 0.0f;
                        for (n10 = 0; n10 < n5; ++n10) {
                            Util.removeDC(fArray3[n17][n10], 0, n11);
                            d6 = Math.sqrt(Filter.calcEnergy(fArray3[n17][n10], 0, n2));
                            if (!((d6 *= (double)(1000 * n11)) > 0.0)) continue block7;
                            Util.mult(fArray3[n17][n10], 0, n2, (float)(1.0 / d6));
                            Fourier.realTransform(fArray3[n17][n10], n13, 1);
                            int n18 = n17;
                            fArray6[n18] = fArray6[n18] + (float)d6;
                        }
                        fArray7[n17] = 0.0f;
                        lArray3[n17] = 0L;
                        blArray3[n17] = false;
                        fArray8[n17] = fArray6[n17];
                        l8 += (long)n2;
                        this.setProgression((float)(l5 += (long)n2) / (float)l4);
                        ++n17;
                        ++n16;
                    }
                    if (!this.threadRunning) break block43;
                    long l9 = 0L;
                    long l10 = l5;
                    long l11 = 0L;
                    block10: while (this.threadRunning && l11 < l) {
                        float f5;
                        n2 = (int)Math.min(l - l11, (long)n11);
                        audioFile3.seekFrame(l9);
                        audioFile3.readFrames(fArray2, 0, n2);
                        Util.clear(fArray2, n2, n13 - n2);
                        Util.mult(fArray10, 0, fArray2, 0, n15);
                        Util.mult(fArray10, n15, fArray2, n11 - n15, n15);
                        float f6 = 0.0f;
                        for (n17 = 0; n17 < n4; ++n17) {
                            Util.removeDC(fArray2[n17], 0, n2);
                            d6 = Math.sqrt(Filter.calcEnergy(fArray2[n17], 0, n2));
                            if (!((d6 *= (double)(1000 * n11)) > 0.0)) {
                                l11 = l9 + (long)n2;
                                l9 = Math.min(l9 + (long)n12, l);
                                l5 += (long)n2 * l8;
                                continue block10;
                            }
                            Util.mult(fArray2[n17], 0, n2, (float)(1.0 / d6));
                            f6 += (float)d6;
                            Fourier.realTransform(fArray2[n17], n13, 1);
                        }
                        for (n17 = 0; n17 < n16; ++n17) {
                            fArray5[n17] = 0.0f;
                            lArray2[n17] = 0L;
                            blArray2[n17] = false;
                        }
                        for (n17 = 0; n17 < n4; ++n17) {
                            for (n10 = 0; n10 < n16; ++n10) {
                                Fourier.complexMult(fArray3[n10][n17], 0, fArray2[n17], 0, fArray9, 0, n13 + 2);
                                Fourier.realTransform(fArray9, n13, -1);
                                f5 = 0.0f;
                                boolean bl = false;
                                long l12 = l9;
                                for (int i = 0; i < n2; ++i) {
                                    f4 = fArray9[i];
                                    if (f4 < 0.0f) {
                                        if (!(-f4 > f5)) continue;
                                        f5 = -f4;
                                        bl = true;
                                        l12 = l9 + (long)i;
                                        continue;
                                    }
                                    if (!(f4 > f5)) continue;
                                    f5 = f4;
                                    bl = false;
                                    l12 = l9 + (long)i;
                                }
                                fArray[n10][n17] = f5;
                                lArray[n10][n17] = l12;
                                blArray[n10][n17] = bl;
                            }
                            l5 = l10 + l8 * l11 / (long)n4;
                            this.setProgression((float)l5 / (float)l4);
                        }
                        switch (n) {
                            case 0: {
                                int n19;
                                for (n17 = 0; n17 < n16; ++n17) {
                                    f4 = fArray[n17][0];
                                    n19 = 0;
                                    for (n10 = 1; n10 < n4; ++n10) {
                                        f5 = fArray[n17][n10];
                                        if (!(f5 < f4)) continue;
                                        f4 = f5;
                                        n19 = n10;
                                    }
                                    fArray5[n17] = fArray[n17][n19];
                                    lArray2[n17] = lArray[n17][n19];
                                    blArray2[n17] = blArray[n17][n19];
                                }
                                break;
                            }
                            case 1: {
                                int n19;
                                for (n17 = 0; n17 < n16; ++n17) {
                                    f4 = fArray[n17][0];
                                    n19 = 0;
                                    for (n10 = 1; n10 < n4; ++n10) {
                                        f5 = fArray[n17][n10];
                                        if (!(f5 > f4)) continue;
                                        f4 = f5;
                                        n19 = n10;
                                    }
                                    fArray5[n17] = fArray[n17][n19];
                                    lArray2[n17] = lArray[n17][n19];
                                    blArray2[n17] = blArray[n17][n19];
                                }
                                break;
                            }
                            default: {
                                assert (false) : n;
                                break;
                            }
                        }
                        for (n17 = 0; n17 < n16; ++n17) {
                            if (!(fArray5[n17] > fArray7[n17])) continue;
                            fArray7[n17] = fArray5[n17];
                            lArray3[n17] = (long)((double)lArray2[n17] * d2 + 0.5);
                            blArray3[n17] = blArray2[n17];
                            fArray8[n17] = f6;
                        }
                        l11 = l9 + (long)n2;
                        l9 = Math.min(l9 + (long)n12, l);
                        this.setProgression((float)l5 / (float)l4);
                    }
                    if (!this.threadRunning) break block43;
                    l5 = l10 + l * l8;
                    for (n17 = 0; this.threadRunning && n17 < n16; ++n17) {
                        f4 = Math.min(f3, fArray8[n17] / fArray6[n17]) * (float)(blArray3[n17] ? -1 : 1);
                        Util.mult(fArray4[n17], 0, n11, f4);
                        if (l6 < lArray3[n17]) {
                            Util.clear(fArray2);
                            audioFile4.seekFrame(l6);
                            while (this.threadRunning && l6 < lArray3[n17]) {
                                n2 = (int)Math.min((long)n9, lArray3[n17] - l6);
                                audioFile4.writeFrames(fArray2, 0, n2);
                                l6 += (long)n2;
                                this.setProgression((float)l5 / (float)l4);
                            }
                            if (!this.threadRunning) {
                                break block43;
                            }
                        } else {
                            audioFile4.seekFrame(lArray3[n17]);
                        }
                        if ((n2 = (int)Math.min(l6 - lArray3[n17], (long)n11)) > 0) {
                            audioFile4.readFrames(fArray2, 0, n2);
                            Util.add(fArray2, 0, fArray4[n17], 0, n2);
                            audioFile4.seekFrame(lArray3[n17]);
                        }
                        audioFile4.writeFrames(fArray4[n17], 0, n11);
                        n2 = (int)Math.max(0L, lArray3[n17] + (long)n11 - l6);
                        l6 += (long)n2;
                        this.setProgression((float)(l5 += (long)n2) / (float)l4);
                    }
                    if (this.threadRunning) continue;
                    break block43;
                }
                this.setProgression((float)l5 / (float)l4);
                Util.clear(fArray2);
                audioFile4.seekFrame(l6);
                while (this.threadRunning && l6 < l3) {
                    n2 = (int)Math.min((long)n9, l3 - l6);
                    audioFile4.writeFrames(fArray2, 0, n2);
                    l6 += (long)n2;
                    this.setProgression((float)(l5 += (long)n2) / (float)l4);
                }
                if (this.threadRunning) {
                    audioFile4.seekFrame(0L);
                    for (l7 = 0L; this.threadRunning && l7 < l3; l7 += (long)n2) {
                        n2 = (int)Math.min((long)n9, l3 - l7);
                        audioFile4.readFrames(fArray2, 0, n2);
                        f2 = Math.max(f2, Util.maxAbs(fArray2, 0, n2));
                        this.setProgression((float)(l5 += (long)n2) / (float)l4);
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFile3.close();
                        audioFile3 = null;
                        f = this.pr.intg[2] == 0 ? (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value : (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                        this.normalizeAudioFile(audioFile4, audioFile2, fArray2, f, 1.0f);
                        this.deleteTempFile(audioFile4);
                        if (this.threadRunning) {
                            audioFile2.close();
                            audioFile2 = null;
                            f2 *= f;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    private static void checkForNaN(float[] fArray, String string) {
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) {
                System.err.println("!!!!! NaN (" + string + ") at " + i);
                return;
            }
            if (!Float.isInfinite(fArray[i])) continue;
            System.err.println("!!!!! inf (" + string + ") at " + i);
            return;
        }
    }
}

