/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;

public class SelectPathButton
extends JButton
implements EventManager.Processor {
    private File path = null;
    private final int type;
    private String dlgTxt;
    private final EventManager elm = new EventManager((EventManager.Processor)this);
    private FilenameFilter filter = null;
    protected static final DataFlavor[] supportedFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};

    public SelectPathButton() {
        this(0);
    }

    public SelectPathButton(int n) {
        super("\u2026");
        this.type = n;
        this.setToolTipText("Choose File...");
        this.setTransferHandler(new PathTransferHandler());
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private MouseEvent dndInit = null;
            private boolean dndStarted = false;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.dndInit = mouseEvent;
                this.dndStarted = false;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!this.dndStarted && SelectPathButton.this.contains(mouseEvent.getPoint())) {
                    SelectPathButton.this.showFileChooser();
                }
                this.dndInit = null;
                this.dndStarted = false;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!(this.dndStarted || this.dndInit == null || Math.abs(mouseEvent.getX() - this.dndInit.getX()) <= 5 && Math.abs(mouseEvent.getY() - this.dndInit.getY()) <= 5)) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    jComponent.getTransferHandler().exportAsDrag(jComponent, mouseEvent, 1);
                    this.dndStarted = true;
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    public SelectPathButton(int n, String string) {
        this(n);
        this.setDialogText(string);
    }

    public void setDialogText(String string) {
        this.dlgTxt = string;
    }

    public void setPath(File file) {
        this.path = file;
    }

    protected void setPathAndDispatchEvent(File file) {
        this.setPath(file);
        this.elm.dispatchEvent((BasicEvent)new PathEvent((Object)this, 0, System.currentTimeMillis(), file));
    }

    public File getPath() {
        return this.path;
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void addPathListener(PathListener pathListener) {
        this.elm.addListener((Object)pathListener);
    }

    public void removePathListener(PathListener pathListener) {
        this.elm.removeListener((Object)pathListener);
    }

    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            PathListener pathListener = (PathListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    pathListener.pathChanged((PathEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    protected void showDialog(Dialog dialog) {
        dialog.setVisible(true);
    }

    protected void showFileChooser() {
        FileDialog fileDialog;
        Container container = this;
        while (!(container instanceof Frame)) {
            if ((container = SwingUtilities.getWindowAncestor(container)) != null) continue;
            return;
        }
        File file = this.getPath();
        switch (this.type & 0xF) {
            case 0: {
                fileDialog = new FileDialog((Frame)container, this.dlgTxt, 0);
                break;
            }
            case 1: {
                fileDialog = new FileDialog((Frame)container, this.dlgTxt, 1);
                break;
            }
            case 2: {
                fileDialog = new FileDialog((Frame)container, this.dlgTxt, 1);
                break;
            }
            default: {
                fileDialog = null;
                assert (false) : this.type & 0xF;
                break;
            }
        }
        if (file != null) {
            fileDialog.setFile(file.getName());
            fileDialog.setDirectory(file.getParent());
        }
        if (this.filter != null) {
            fileDialog.setFilenameFilter(this.filter);
        }
        this.showDialog(fileDialog);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if ((this.type & 0xF) != 2 && string == null) {
            string = "";
        }
        if (string2 != null && string != null) {
            file = (this.type & 0xF) == 2 ? new File(string) : new File(string + string2);
            this.setPathAndDispatchEvent(file);
        }
        fileDialog.dispose();
    }

    private static class PathTransferable
    implements Transferable {
        private final File f;

        protected PathTransferable(File file) {
            this.f = file;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < supportedFlavors.length; ++i) {
                if (!supportedFlavors[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.f == null) {
                throw new IOException();
            }
            if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                ArrayList<File> arrayList = new ArrayList<File>(1);
                arrayList.add(this.f);
                return arrayList;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.f.getAbsolutePath();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    private class PathTransferHandler
    extends TransferHandler {
        protected PathTransferHandler() {
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            File file = null;
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list;
                    Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (object instanceof List && !(list = (List)object).isEmpty()) {
                        object = list.get(0);
                        file = object instanceof File ? (File)object : new File(object.toString());
                    }
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    file = new File((String)transferable.getTransferData(DataFlavor.stringFlavor));
                }
                if (file != null) {
                    SelectPathButton.this.setPathAndDispatchEvent(file);
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return new PathTransferable(SelectPathButton.this.getPath());
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                for (int j = 0; j < supportedFlavors.length; ++j) {
                    if (!dataFlavorArray[i].equals(supportedFlavors[j])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

