/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SerialKillaDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_NOUTPUTFILE = 1;
    private static final int PR_TOUTPUTFILE = 2;
    private static final int PR_EOUTPUTFILE = 3;
    private static final int PR_NOUTPUTTYPE = 0;
    private static final int PR_NOUTPUTRES = 1;
    private static final int PR_TOUTPUTTYPE = 2;
    private static final int PR_TOUTPUTRES = 3;
    private static final int PR_EOUTPUTTYPE = 4;
    private static final int PR_EOUTPUTRES = 5;
    private static final int PR_FRAMESIZE = 7;
    private static final int PR_OVERLAP = 8;
    private static final int PR_OUTNOISE = 0;
    private static final int PR_OUTTILT = 1;
    private static final int PR_OUTENERGY = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_NOUTPUTFILE = "NOutputFile";
    private static final String PRN_NOUTPUTTYPE = "NOutputType";
    private static final String PRN_NOUTPUTRES = "NOutputReso";
    private static final String PRN_TOUTPUTFILE = "TOutputFile";
    private static final String PRN_TOUTPUTTYPE = "TOutputType";
    private static final String PRN_TOUTPUTRES = "TOutputReso";
    private static final String PRN_EOUTPUTFILE = "EOutputFile";
    private static final String PRN_EOUTPUTTYPE = "EOutputType";
    private static final String PRN_EOUTPUTRES = "EOutputReso";
    private static final String PRN_OUTNOISE = "OutNoise";
    private static final String PRN_OUTTILT = "OutTilt";
    private static final String PRN_OUTENERGY = "OutEnergy";
    private static final String PRN_FRAMESIZE = "FrameSize";
    private static final String PRN_OVERLAP = "Overlap";
    private static final String[] prText = new String[]{"", "", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "NOutputFile", "TOutputFile", "EOutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 2};
    private static final String[] prIntgName = new String[]{"NOutputType", "NOutputReso", "TOutputType", "TOutputReso", "EOutputType", "EOutputReso", "GainType", "FrameSize", "Overlap"};
    private static final boolean[] prBool = new boolean[]{true, false, false};
    private static final String[] prBoolName = new String[]{"OutNoise", "OutTilt", "OutEnergy"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_NOUTPUTFILE = 1025;
    private static final int GG_NOUTPUTTYPE = 256;
    private static final int GG_NOUTPUTRES = 257;
    private static final int GG_TOUTPUTFILE = 1026;
    private static final int GG_TOUTPUTTYPE = 258;
    private static final int GG_TOUTPUTRES = 259;
    private static final int GG_EOUTPUTFILE = 1027;
    private static final int GG_EOUTPUTTYPE = 260;
    private static final int GG_EOUTPUTRES = 261;
    private static final int GG_FRAMESIZE = 263;
    private static final int GG_OVERLAP = 264;
    private static final int GG_OUTNOISE = 0;
    private static final int GG_OUTTILT = 1;
    private static final int GG_OUTENERGY = 2;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_NOOUTPUT = "No outputs checked!";
    private static final String PTRN_NOISE = "Mean noise  : {0,number,#,##0.0}%";
    private static final String PTRN_TILT = "Mean tilt   : {0,number,#,##0.0} Hz";
    private static final String PTRN_ENERGY = "Mean energy : {0,number,#,##0.0} dB";

    public SerialKillaDlg() {
        super("Serial Killer");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SerialKillaDlg.static_pr.text = prText;
            SerialKillaDlg.static_pr.textName = prTextName;
            SerialKillaDlg.static_pr.intg = prIntg;
            SerialKillaDlg.static_pr.intgName = prIntgName;
            SerialKillaDlg.static_pr.bool = prBool;
            SerialKillaDlg.static_pr.boolName = prBoolName;
            this.fillDefaultAudioDescr(SerialKillaDlg.static_pr.intg, 0);
            this.fillDefaultAudioDescr(SerialKillaDlg.static_pr.intg, 2);
            this.fillDefaultAudioDescr(SerialKillaDlg.static_pr.intg, 4);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = SerialKillaDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ((SerialKillaDlg)SerialKillaDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        SerialKillaDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0SKNoise$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        JCheckBox jCheckBox = new JCheckBox("Noise output");
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        pathField3.deriveFrom(pathFieldArray, "$D0$F0SKTilt$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        JCheckBox jCheckBox2 = new JCheckBox("Tilt output");
        this.gui.addCheckbox(jCheckBox2, 1, itemListener);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 258);
        this.gui.registerGadget(pathField3.getResGadget(), 259);
        PathField pathField4 = new PathField(49, "Select output file");
        pathField4.handleTypes(GenericFile.TYPES_SOUND);
        pathField4.deriveFrom(pathFieldArray, "$D0$F0SKEnergy$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        JCheckBox jCheckBox3 = new JCheckBox("Energy output");
        this.gui.addCheckbox(jCheckBox3, 2, itemListener);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField4, 1027, null);
        this.gui.registerGadget(pathField4.getTypeGadget(), 260);
        this.gui.registerGadget(pathField4.getResGadget(), 261);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 32; n <= 32768; n <<= 1) {
            jComboBox.addItem(String.valueOf(n));
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Frame size [smp]", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 263, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < 8; ++n) {
            jComboBox2.addItem((1 << n) + "x");
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_OVERLAP, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 264, itemListener);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        AudioFile audioFile4;
        block53: {
            audioFile4 = null;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            AudioFileDescr audioFileDescr4 = null;
            float[][] fArray = null;
            float[][] fArray2 = null;
            float[][] fArray3 = null;
            float[][] fArray4 = null;
            Object[] objectArray = new Object[1];
            try {
                float f;
                int n;
                PathField pathField;
                audioFile4 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile4.getDescr();
                int n2 = audioFileDescr.channels;
                int n3 = (int)audioFileDescr.length;
                if (n3 * n2 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block53;
                int n4 = n2;
                boolean bl = this.pr.bool[0];
                boolean bl2 = this.pr.bool[1];
                boolean bl3 = this.pr.bool[2];
                if (!(bl || bl2 || bl3)) {
                    throw new IOException(ERR_NOOUTPUT);
                }
                if (bl) {
                    pathField = (PathField)this.gui.getItemObj(1025);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                    audioFileDescr2.channels = n4;
                    pathField.fillStream(audioFileDescr2);
                    audioFile3 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                    if (!this.threadRunning) break block53;
                }
                if (bl2) {
                    pathField = (PathField)this.gui.getItemObj(1026);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                    audioFileDescr3.channels = n4;
                    pathField.fillStream(audioFileDescr3);
                    audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                    if (!this.threadRunning) break block53;
                }
                if (bl3) {
                    pathField = (PathField)this.gui.getItemObj(1027);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    audioFileDescr4 = new AudioFileDescr(audioFileDescr);
                    audioFileDescr4.channels = n4;
                    pathField.fillStream(audioFileDescr4);
                    audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr4);
                    if (!this.threadRunning) break block53;
                }
                int n5 = 32 << this.pr.intg[7];
                int n6 = n5 << 1;
                int n7 = n5 >> this.pr.intg[8];
                int n8 = n5 >> 7;
                int n9 = (n3 + n7 - 1) / n7;
                fArray = new float[n2][n5];
                fArray2 = new float[n4][8];
                fArray3 = new float[n4][8];
                fArray4 = new float[n4][8];
                float[] fArray5 = new float[n6 + 2];
                float[] fArray6 = Filter.createFullWindow(n5, 0);
                float[] fArray7 = new float[n5];
                float[] fArray8 = new float[n8];
                int[] nArray = new int[n8];
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                System.arraycopy(fArray6, 0, fArray5, 0, n5);
                int n10 = n5;
                while (n10 < n6) {
                    fArray5[n10++] = 0.0f;
                }
                Fourier.realTransform(fArray5, n6, 1);
                double d4 = 0.0;
                n10 = 0;
                int n11 = 0;
                while (n10 <= n6) {
                    n = n10++;
                    fArray5[n] = f = fArray5[n] * fArray5[n] + fArray5[n10] * fArray5[n10];
                    d4 += (double)f;
                    fArray5[n10++] = 0.0f;
                }
                Fourier.realTransform(fArray5, n6, -1);
                Util.mult(fArray5, 0, n5, 1.0f / fArray5[0]);
                f = fArray5[0];
                for (n10 = 1; n10 < n5 && !((f = (float)(n5 - n10) / (float)n5 / fArray5[n10]) > 500.0f); ++n10) {
                    fArray7[n10] = f;
                }
                while (n10 < n5) {
                    fArray7[n10] = 500.0f;
                    ++n10;
                }
                float[] fArray9 = new float[n5 + 1];
                f = (float)audioFileDescr.rate / 2.0f;
                for (n10 = 0; n10 <= n5; ++n10) {
                    fArray9[n10] = (float)n10 / (float)n5 * f;
                }
                Filter.getDBAweights(fArray9, fArray9, n5 + 1);
                for (n10 = 0; n10 <= n5; ++n10) {
                    int n12 = n10;
                    fArray9[n12] = fArray9[n12] * fArray9[n10];
                }
                long l = 0L;
                long l2 = (long)n3 + (long)n9;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                while (this.threadRunning && n13 < n9) {
                    int n16 = Math.min(n3 - n14, n5 - n15);
                    int n17 = n16 + n15;
                    audioFile4.readFrames(fArray, n15, n16);
                    n14 += n16;
                    this.setProgression((float)(l += (long)n16) / (float)l2);
                    if (this.threadRunning) {
                        float[] fArray10;
                        int n18;
                        if (n17 < n5) {
                            for (n18 = 0; n18 < n2; ++n18) {
                                fArray10 = fArray[n18];
                                for (n10 = n17; n10 < n5; ++n10) {
                                    fArray10[n10] = 0.0f;
                                }
                            }
                        }
                        for (n18 = 0; n18 < n2; ++n18) {
                            fArray10 = fArray[n18];
                            System.arraycopy(fArray10, 0, fArray5, 0, n5);
                            Util.mult(fArray6, 0, fArray5, 0, n5);
                            n10 = n5;
                            while (n10 < n6) {
                                fArray5[n10++] = 0.0f;
                            }
                            Fourier.realTransform(fArray5, n6, 1);
                            d4 = 0.0;
                            double d5 = 0.0;
                            n10 = 0;
                            n11 = 0;
                            while (n10 <= n6) {
                                n = n10++;
                                f = (fArray5[n] * fArray5[n] + fArray5[n10] * fArray5[n10]) * fArray9[n11];
                                d5 += (double)f;
                                if (bl2) {
                                    d4 += (double)(f * (float)n11);
                                }
                                fArray5[n] = f;
                                fArray5[n10++] = 0.0f;
                                ++n11;
                            }
                            if (bl2) {
                                f = d5 > 0.0 ? (float)(d4 / (d5 * (double)n5)) : 0.5f;
                                fArray3[n18][0] = f;
                                d += (double)f;
                            }
                            if (bl3) {
                                fArray4[n18][0] = f = Math.min(1.0f, (float)(Math.sqrt(d5) / (double)n5));
                                d3 += (double)f;
                            }
                            if (!bl) continue;
                            Fourier.realTransform(fArray5, n6, -1);
                            f = fArray5[0];
                            if (f > 0.0f) {
                                Util.mult(fArray5, 0, n5, 1.0f / f);
                                Util.mult(fArray7, 0, fArray5, 0, n5);
                                Util.clear(fArray8);
                                for (n10 = 0; n10 < n8; ++n10) {
                                    nArray[n10] = n5;
                                }
                                fArray5[n6] = 0.0f;
                                float f2 = 1.1f;
                                d4 = 0.0;
                                for (n10 = 0; n10 < n5; ++n10) {
                                    float f3 = fArray5[n10];
                                    if (f3 > f2 && f3 > fArray5[n10 + 1] && f3 > 0.0f && f3 > fArray8[0]) {
                                        for (n = 1; n < n8 && !(f3 <= fArray8[n]); ++n) {
                                        }
                                        --n;
                                        for (n11 = 0; n11 < n; ++n11) {
                                            fArray8[n11] = fArray8[n11 + 1];
                                            nArray[n11] = nArray[n11 + 1];
                                        }
                                        fArray8[n] = f3;
                                        nArray[n] = n10;
                                    }
                                    f2 = f3;
                                }
                                d4 += (double)(fArray8[0] / 2.0f * (float)(n5 - nArray[0]));
                                f = 1.0f;
                                n = 0;
                                while (true) {
                                    int n19 = -1;
                                    n11 = n5;
                                    for (n10 = 0; n10 < n8; ++n10) {
                                        if (nArray[n10] >= n11) continue;
                                        n11 = nArray[n10];
                                        n19 = n10;
                                    }
                                    if (n19 < 0) break;
                                    d4 += (double)((f + fArray8[n19]) / 2.0f * (float)(nArray[n19] - n));
                                    n = nArray[n19];
                                    f = fArray8[n19];
                                    nArray[n19] = n5;
                                }
                                f = 1.13f - (float)d4 * 2.1f / (float)n5;
                                f = Math.min(1.0f, Math.max(0.0f, f * f));
                            } else {
                                f = 0.0f;
                            }
                            fArray2[n18][0] = f;
                            d2 += (double)f;
                        }
                        if (bl2) {
                            audioFile2.writeFrames(fArray3, 0, 1);
                        }
                        if (bl) {
                            audioFile3.writeFrames(fArray2, 0, 1);
                        }
                        if (bl3) {
                            audioFile.writeFrames(fArray4, 0, 1);
                        }
                        ++n13;
                        this.setProgression((float)(++l) / (float)l2);
                        if (this.threadRunning) {
                            n15 = n5 - n7;
                            for (n18 = 0; n18 < n2; ++n18) {
                                System.arraycopy(fArray[n18], n7, fArray[n18], 0, n15);
                            }
                            continue;
                        }
                    }
                    break block53;
                }
                if (this.threadRunning) {
                    MessageFormat messageFormat;
                    if (bl) {
                        objectArray[0] = new Double(d2 / (double)(n9 * n4) * 100.0);
                        messageFormat = new MessageFormat(PTRN_NOISE);
                        messageFormat.setLocale(Locale.US);
                        messageFormat.applyPattern(PTRN_NOISE);
                        System.out.println(messageFormat.format(objectArray));
                    }
                    if (bl2) {
                        objectArray[0] = new Double(d / (double)(n9 * n4) * (audioFileDescr.rate / 2.0));
                        messageFormat = new MessageFormat(PTRN_TILT);
                        messageFormat.setLocale(Locale.US);
                        messageFormat.applyPattern(PTRN_TILT);
                        System.out.println(messageFormat.format(objectArray));
                    }
                    if (bl3) {
                        objectArray[0] = new Double(20.0 * Math.log(d3 / (double)(n9 * n4)) / 2.302585092994046);
                        messageFormat = new MessageFormat(PTRN_ENERGY);
                        messageFormat.setLocale(Locale.US);
                        messageFormat.applyPattern(PTRN_ENERGY);
                        System.out.println(messageFormat.format(objectArray));
                    }
                    audioFile4.close();
                    audioFile4 = null;
                    audioFileDescr = null;
                    if (audioFile3 != null) {
                        audioFile3.close();
                        audioFile3 = null;
                    }
                    if (audioFile2 != null) {
                        audioFile2.close();
                        audioFile2 = null;
                    }
                    if (audioFile != null) {
                        audioFile.close();
                        audioFile = null;
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                audioFileDescr3 = null;
                fArray = null;
                fArray2 = null;
                fArray3 = null;
                fArray4 = null;
                Object var33_27 = null;
                Object var34_43 = null;
                Object var35_29 = null;
                Object var36_31 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile4 != null) {
            audioFile4.cleanUp();
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1025);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(1026)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(1027)) != null) {
            component.setEnabled(this.pr.bool[2]);
        }
    }
}

