/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class TestDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_GAIN = 0;
    private static final int PR_CALCLEN = 1;
    private static final int PR_STEPSIZE = 2;
    private static final int PR_LPORDER = 3;
    private static final int PR_RESIDUAL = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_CALCLEN = "CalcLen";
    private static final String PRN_STEPSIZE = "StepSize";
    private static final String PRN_LPORDER = "LPOrder";
    private static final String PRN_RESIDUAL = "Residual";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "CalcLen", "StepSize", "LPOrder"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Residual"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_CALCLEN = 513;
    private static final int GG_STEPSIZE = 514;
    private static final int GG_LPORDER = 515;
    private static final int GG_RESIDUAL = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    protected static final float EXPECTEDERROR2 = 4.0E-6f;
    protected static final float EXPECTEDERROR = 1.0E-7f;
    protected static final int MR = 8;
    protected static final int MT = 10;
    protected static final int MAXITER = 80;
    protected static final float[] frac = new float[]{0.0f, 0.5f, 0.25f, 0.75f, 0.13f, 0.38f, 0.62f, 0.88f, 1.0f};

    public TestDlg() {
        super("Sample Duplication");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            TestDlg.static_pr.text = prText;
            TestDlg.static_pr.textName = prTextName;
            TestDlg.static_pr.intg = prIntg;
            TestDlg.static_pr.intgName = prIntgName;
            TestDlg.static_pr.bool = prBool;
            TestDlg.static_pr.boolName = prBoolName;
            TestDlg.static_pr.para = prPara;
            TestDlg.static_pr.para[1] = new Param(32.0, 2);
            TestDlg.static_pr.para[2] = new Param(8.0, 2);
            TestDlg.static_pr.para[3] = new Param(10.0, 0);
            TestDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(TestDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(TestDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Pre$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("LP Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Calc. Interval", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamField paramField2 = new ParamField(new ParamSpace(2.0, 100000.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("LP Order", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 515, null);
        ParamField paramField3 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Step Size", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 514, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_RESIDUAL, 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        block26: {
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            FloatFile[] floatFileArray = null;
            File[] fileArray = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                int n;
                int n2;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n3 = audioFileDescr.channels;
                int n4 = (int)audioFileDescr.length;
                if (n4 * n3 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block26;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block26;
                int n5 = n4 << 1;
                int n6 = 4096;
                int n7 = n6 << 1;
                float[][] fArray = new float[n3][n6];
                float[][] fArray2 = new float[n3][n7];
                long l = 0L;
                long l2 = (long)n4 + (long)n5;
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n3];
                    floatFileArray = new FloatFile[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        fileArray[n2] = null;
                        floatFileArray[n2] = null;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        fileArray[n2] = IOUtil.createTempFile();
                        floatFileArray[n2] = new FloatFile(fileArray[n2], 1);
                    }
                    l2 += (long)n4;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block26;
                int n8 = 0;
                for (int i = 0; this.threadRunning && i < n5; i += n) {
                    n = Math.min(n6, n4 - n8);
                    audioFile2.readFrames(fArray, 0, n);
                    n8 += n;
                    this.setProgression((float)(l += (long)n) / (float)l2);
                    if (this.threadRunning) {
                        int n9;
                        float[] fArray3;
                        for (n2 = 0; n2 < n3; ++n2) {
                            fArray3 = fArray[n2];
                            float[] fArray4 = fArray2[n2];
                            n9 = 0;
                            int n10 = 0;
                            while (n9 < n) {
                                fArray4[n10++] = fArray3[n9];
                                fArray4[n10++] = fArray3[n9++];
                            }
                        }
                        this.setProgression((float)(l += (long)n) / (float)l2);
                        if (this.threadRunning) {
                            float f3;
                            n <<= 1;
                            if (floatFileArray != null) {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    fArray3 = fArray2[n2];
                                    for (n9 = 0; n9 < n; ++n9) {
                                        f3 = Math.abs(fArray3[n9]);
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                    floatFileArray[n2].writeFloats(fArray3, 0, n);
                                }
                            } else {
                                for (n2 = 0; n2 < n3; ++n2) {
                                    fArray3 = fArray2[n2];
                                    for (n9 = 0; n9 < n; ++n9) {
                                        f3 = Math.abs(fArray3[n9]);
                                        int n11 = n9;
                                        fArray3[n11] = fArray3[n11] * f;
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                                audioFile.writeFrames(fArray2, 0, n);
                            }
                            this.setProgression((float)(l += (long)n) / (float)l2);
                            continue;
                        }
                    }
                    break block26;
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray, f, 1.0f);
                        for (n2 = 0; n2 < n3; ++n2) {
                            floatFileArray[n2].cleanUp();
                            floatFileArray[n2] = null;
                            fileArray[n2].delete();
                            fileArray[n2] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        this.handleClipping(f2 *= f);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                float[][] fArray = null;
                float[][] fArray5 = null;
                Object var18_30 = null;
                Object var19_32 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }

    protected static void lpFilter(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int n4) {
        int n5 = n3;
        int n6 = n - 1;
        int n7 = n3 + n4;
        while (n5 < n7) {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                f += fArray2[i] * fArray[n6 - i];
            }
            fArray3[n5++] = f;
            ++n6;
        }
    }

    protected static void linearPrediction(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int n4) {
        float[] fArray4 = new float[n2];
        int n5 = 0;
        int n6 = n;
        while (n5 < n2) {
            fArray4[n5++] = fArray[--n6];
        }
        int n7 = n3 + n4;
        for (n5 = n3; n5 < n7; ++n5) {
            float f = 0.0f;
            for (n6 = 0; n6 < n2; ++n6) {
                f += fArray2[n6] * fArray4[n6];
            }
            System.arraycopy(fArray4, 0, fArray4, 1, n2 - 1);
            fArray4[0] = f;
            fArray3[n5] = f;
        }
    }

    protected static float lpCoeffs(float[] fArray, int n, int n2, float[] fArray2, int n3) {
        int n4;
        float[] fArray3 = new float[n2 - 1];
        float[] fArray4 = new float[n2 - 1];
        float[] fArray5 = new float[n3 - 1];
        int n5 = n2 + n;
        float f = 0.0f;
        for (n4 = n2; n4 < n5; ++n4) {
            f += fArray[n4] * fArray[n4];
        }
        float f2 = f / (float)n2;
        fArray3[0] = fArray[0];
        fArray4[n2 - 2] = fArray[n2 - 1];
        System.arraycopy(fArray, n, fArray3, 0, n2 - 1);
        System.arraycopy(fArray, n + 1, fArray4, 0, n2 - 1);
        int n6 = 0;
        block1: while (true) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            n5 = n2 - n6 - 1;
            for (n4 = 0; n4 < n5; ++n4) {
                f3 += fArray3[n4] * fArray4[n4];
                f4 += fArray3[n4] * fArray3[n4] + fArray4[n4] * fArray4[n4];
            }
            f = f4 > 0.0f ? 2.0f * f3 / f4 : 1.0f;
            fArray2[n6] = f;
            f2 *= 1.0f - f * f;
            for (n5 = 0; n5 < n6; ++n5) {
                fArray2[n5] = fArray5[n5] - f * fArray5[n6 - n5 - 1];
            }
            if (++n6 == n3) {
                return f2;
            }
            System.arraycopy(fArray2, 0, fArray5, 0, n6);
            n4 = 0;
            n5 = n2 - n6 - 1;
            while (true) {
                if (n4 >= n5) continue block1;
                int n7 = n4;
                fArray3[n7] = fArray3[n7] - f * fArray4[n4];
                fArray4[n4] = fArray4[n4 + 1] - f * fArray3[n4 + 1];
                ++n4;
            }
            break;
        }
    }

    protected static void fixRoots(float[] fArray, int n) {
        int n2 = n << 1;
        float[] fArray2 = new float[n2 + 2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[2];
        fArray2[n2] = 1.0f;
        fArray2[n2 + 1] = 0.0f;
        int n3 = 0;
        int n4 = n2;
        while (n4 > 0) {
            fArray2[--n4] = 0.0f;
            fArray2[--n4] = -fArray[n3++];
        }
        TestDlg.zRoots(fArray2, n, fArray3, true);
        for (n4 = 0; n4 < n2; n4 += 2) {
            float f = TestDlg.complexAbs(fArray3[n4], fArray3[n4 + 1]);
            if (!(f > 1.0f)) continue;
            TestDlg.complexDiv(1.0f, 0.0f, fArray3[n4], -fArray3[n4 + 1], fArray4);
            fArray3[n4] = fArray4[0];
            fArray3[n4 + 1] = fArray4[1];
        }
        fArray2[0] = -fArray3[0];
        fArray2[1] = -fArray3[1];
        fArray2[2] = 1.0f;
        fArray2[3] = 0.0f;
        for (n4 = 2; n4 < n2; n4 += 2) {
            fArray2[n4 + 2] = 1.0f;
            fArray2[n4 + 3] = 0.0f;
            float f = fArray3[n4];
            float f2 = fArray3[n4 + 1];
            for (n3 = n4; n3 >= 2; n3 -= 2) {
                fArray2[n3] = fArray2[n3 - 2] - (f * fArray2[n3] - f2 * fArray2[n3 + 1]);
                fArray2[n3 + 1] = fArray2[n3 - 1] - (f2 * fArray2[n3] + f * fArray2[n3 + 1]);
            }
            fArray2[0] = -f * fArray2[0] + f2 * fArray2[1];
            fArray2[1] = -f2 * fArray2[0] - f * fArray2[1];
        }
        n3 = n;
        for (n4 = 0; n4 < n2; n4 += 2) {
            fArray[--n3] = -fArray2[n4];
        }
    }

    protected static void zRoots(float[] fArray, int n, float[] fArray2, boolean bl) {
        int n2;
        int n3;
        int n4 = n << 1;
        float[] fArray3 = new float[n4 + 2];
        float[] fArray4 = new float[2];
        System.arraycopy(fArray, 0, fArray3, 0, n4 + 2);
        for (n3 = n4; n3 >= 2; n3 -= 2) {
            int n5 = n3 - 2;
            fArray4[0] = 0.0f;
            fArray4[1] = 0.0f;
            n2 = TestDlg.laguerre(fArray3, n3 >> 1, fArray4);
            if (Math.abs(fArray4[1]) <= 4.0E-6f * Math.abs(fArray4[0])) {
                fArray4[1] = 0.0f;
            }
            fArray2[n5] = fArray4[0];
            fArray2[n5 + 1] = fArray4[1];
            float f = fArray3[n3];
            float f2 = fArray3[n3 + 1];
            while (n5 >= 0) {
                float f3 = fArray3[n5];
                float f4 = fArray3[n5 + 1];
                fArray3[n5] = f;
                fArray3[n5 + 1] = f2;
                f = fArray4[0] * f - fArray4[1] * f2 + f3;
                f2 = fArray4[1] * f + fArray4[0] * f2 + f4;
                n5 -= 2;
            }
        }
        if (bl) {
            n3 = 0;
            while (n3 < n4) {
                fArray4[0] = fArray2[n3];
                fArray4[1] = fArray2[n3 + 1];
                TestDlg.laguerre(fArray, n, fArray4);
                fArray2[n3++] = fArray4[0];
                fArray2[n3++] = fArray4[1];
            }
        }
        for (n3 = 2; n3 < n4; n3 += 2) {
            fArray4[0] = fArray2[n3];
            fArray4[1] = fArray2[n3 + 1];
            for (n2 = n3 - 2; n2 >= 2 && !(fArray2[n2] <= fArray4[0]); n2 -= 2) {
                fArray2[n2 + 2] = fArray2[n2];
                fArray2[n2 + 3] = fArray2[n2 + 1];
            }
            fArray2[n2 + 2] = fArray4[0];
            fArray2[n2 + 3] = fArray4[1];
        }
    }

    protected static int laguerre(float[] fArray, int n, float[] fArray2) {
        float[] fArray3 = new float[2];
        int n2 = n << 1;
        for (int i = 1; i <= 80; ++i) {
            float f;
            float f2;
            float f3;
            float f4 = fArray[n2];
            float f5 = fArray[n2 + 1];
            float f6 = f3 = TestDlg.complexAbs(f4, f5);
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = TestDlg.complexAbs(fArray2[0], fArray2[1]);
            int n3 = n2;
            while (n3 > 0) {
                f9 = fArray2[0] * f9 - fArray2[1] * f10 + f4;
                f10 = fArray2[1] * f9 + fArray2[0] * f10 + f5;
                f5 = fArray2[1] * f4 + fArray2[0] * f5 + fArray[--n3];
                f4 = fArray2[0] * f4 - fArray2[1] * f5 + fArray[--n3];
                f3 = TestDlg.complexAbs(f4, f5);
                f6 = f3 + f11 * f6;
            }
            if (f3 <= (f6 *= 1.0E-7f)) {
                return i;
            }
            TestDlg.complexDiv(f9, f10, f4, f5, fArray3);
            float f12 = fArray3[0];
            float f13 = fArray3[1];
            float f14 = f12 * f12 - f13 * f13;
            float f15 = f13 * f12 * 2.0f;
            TestDlg.complexDiv(f7, f8, f4, f5, fArray3);
            float f16 = f14 - 2.0f * fArray3[0];
            float f17 = f15 - 2.0f * fArray3[1];
            float f18 = (float)(n - 1) * ((float)n * f16 - f14);
            float f19 = (float)(n - 1) * ((float)n * f17 - f15);
            TestDlg.complexSqrt(f18, f19, fArray3);
            f18 = fArray3[0];
            f19 = fArray3[1];
            float f20 = f12 + f18;
            float f21 = f13 + f19;
            float f22 = f12 - f18;
            float f23 = f13 - f19;
            float f24 = TestDlg.complexAbs(f20, f21);
            float f25 = TestDlg.complexAbs(f22, f23);
            if (f24 < f25) {
                f20 = f22;
                f21 = f23;
            }
            if (f24 > 0.0f || f25 > 0.0f) {
                TestDlg.complexDiv(n, 0.0f, f20, f21, fArray3);
                f2 = fArray3[0];
                f = fArray3[1];
            } else {
                float f26 = 1.0f + f11;
                f2 = f26 * (float)Math.cos(i);
                f = f26 * (float)Math.sin(i);
            }
            float f27 = fArray2[0] - f2;
            float f28 = fArray2[1] - f;
            if (f2 == 0.0f && f == 0.0f) {
                return i;
            }
            if (i % 10 != 0) {
                fArray2[0] = f27;
                fArray2[1] = f28;
                continue;
            }
            int n4 = i / 10;
            fArray2[0] = fArray2[0] - frac[n4] * f2;
            fArray2[1] = fArray2[1] - frac[n4] * f;
        }
        return 0;
    }

    protected static float complexAbs(float f, float f2) {
        if (f == 0.0f) {
            return Math.abs(f2);
        }
        if (f2 == 0.0f) {
            return Math.abs(f);
        }
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    protected static void complexDiv(float f, float f2, float f3, float f4, float[] fArray) {
        if (Math.abs(f3) >= Math.abs(f4)) {
            float f5 = f4 / f3;
            float f6 = f3 + f5 * f4;
            fArray[0] = (f + f5 * f2) / f6;
            fArray[1] = (f2 - f5 * f) / f6;
        } else {
            float f7 = f3 / f4;
            float f8 = f4 + f7 * f3;
            fArray[0] = (f * f7 + f2) / f8;
            fArray[1] = (f2 * f7 - f) / f8;
        }
    }

    protected static void complexSqrt(float f, float f2, float[] fArray) {
        if (f == 0.0f && f2 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            float f3;
            float f4;
            float f5 = Math.abs(f);
            if (f5 >= (f4 = Math.abs(f2))) {
                float f6 = f4 / f5;
                f3 = (float)(Math.sqrt(f5) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0f + f6 * f6))));
            } else {
                float f7 = f5 / f4;
                f3 = (float)(Math.sqrt(f4) * Math.sqrt(0.5 * ((double)f7 + Math.sqrt(1.0f + f7 * f7))));
            }
            if ((double)f >= 0.0) {
                fArray[0] = f3;
                fArray[1] = f2 / (2.0f * f3);
            } else {
                fArray[1] = f2 >= 0.0f ? f3 : -f3;
                fArray[0] = f2 / (2.0f * fArray[1]);
            }
        }
    }
}

