/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.IconBitmap;
import de.sciss.fscape.gui.IconicComponent;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ToolIcon
extends IconicComponent {
    protected int state;
    private int basicID;
    protected boolean clicked = false;
    public static final int ID_ADDPRESET = 0;
    public static final int ID_DELPRESET = 1;
    public static final int ID_CHOOSEFILE = 2;
    public static final int ID_START = 3;
    public static final int ID_PAUSE = 4;
    public static final int ID_STOP = 5;
    public static final int ID_CHOOSEFONT = 6;
    public static final int ID_ZOOMOUT = 7;
    public static final int ID_ZOOMIN = 8;
    public static final int ID_EDITENV = 10;
    public static final int ID_ADDSAMPLE = 11;
    public static final int ID_DELSAMPLE = 12;
    protected static final int ID_WHEEL = 9;
    protected static final int STATE_NORMAL = 0;
    protected static final int STATE_SELECTED = 1;
    protected static final int STATE_DISABLED = 2;
    private static final int STATE_FACTOR = 3;
    protected static final int ibWidth = 32;
    protected static final int ibHeight = 32;
    protected static IconBitmap toolib;

    public ToolIcon(int n, String string) {
        super(toolib, n);
        this.setToolTipText(string);
        this.enableEvents(16L);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ToolIcon.this.setSelected(ToolIcon.this.isEnabled() ? 0 : 2);
            }
        });
    }

    @Override
    public void setID(int n) {
        this.basicID = n;
        super.setID(n * 3 + this.state);
        this.repaint();
    }

    @Override
    public int getID() {
        return this.basicID;
    }

    protected void setSelected(int n) {
        super.setID(this.basicID * 3 + n);
        this.state = n;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.setSelected(1);
                    this.clicked = true;
                    break;
                }
                case 504: {
                    if (!this.clicked) break;
                    this.setSelected(1);
                    break;
                }
                case 502: {
                    this.setSelected(0);
                    this.clicked = false;
                    break;
                }
                case 505: {
                    if (!this.clicked) break;
                    this.setSelected(0);
                    break;
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void passMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    static {
        Image image = Toolkit.getDefaultToolkit().getImage(ToolIcon.class.getResource("tools.png"));
        toolib = new IconBitmap(image, 32, 32);
    }
}

