/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class VoocooderDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_MODFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTERLEN = 3;
    private static final int PR_KOMBINATION = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_LOFREQ = 1;
    private static final int PR_HIFREQ = 2;
    private static final int PR_DRYMIX = 3;
    private static final int PR_WETMIX = 4;
    private static final int PR_ROLLOFF = 5;
    private static final int PR_BANDSPEROCT = 6;
    private static final int FLT_SHORT = 0;
    private static final int KMB_MULTIPLY = 0;
    private static final int KMB_MODULO = 1;
    private static final int KMB_MIN = 2;
    private static final int KMB_MAX = 3;
    private static final int KMB_VOCODER = 4;
    private static final String[] KMB_NAMES = new String[]{"Multiply", "Modulo", "Min", "Max", "Vocoder"};
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_MODFILE = "ModFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTERLEN = "FilterLen";
    private static final String PRN_KOMBINATION = "Kombi";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_DRYMIX = "DryMix";
    private static final String PRN_WETMIX = "WetMix";
    private static final String PRN_ROLLOFF = "RollOff";
    private static final String PRN_BANDSPEROCT = "BandsPerOct";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "ModFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FilterLen", "Kombi"};
    private static final Param[] prPara = new Param[7];
    private static final String[] prParaName = new String[]{"Gain", "LoFreq", "HiFreq", "DryMix", "WetMix", "RollOff", "BandsPerOct"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_MODFILE = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FILTERLEN = 259;
    private static final int GG_KOMBINATION = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_LOFREQ = 513;
    private static final int GG_HIFREQ = 514;
    private static final int GG_BANDSPEROCT = 518;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHAN = "Input 2 must not have\nmore channels than input 1";

    public VoocooderDlg() {
        super("Voocooder");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            VoocooderDlg.static_pr.text = prText;
            VoocooderDlg.static_pr.textName = prTextName;
            VoocooderDlg.static_pr.intg = prIntg;
            VoocooderDlg.static_pr.intgName = prIntgName;
            VoocooderDlg.static_pr.para = prPara;
            VoocooderDlg.static_pr.para[1] = new Param(400.0, 3);
            VoocooderDlg.static_pr.para[2] = new Param(9000.0, 3);
            VoocooderDlg.static_pr.para[3] = new Param(100.0, 17);
            VoocooderDlg.static_pr.para[4] = new Param(25.0, 17);
            VoocooderDlg.static_pr.para[5] = new Param(12.0, 547);
            VoocooderDlg.static_pr.para[6] = new Param(12.0, 0);
            VoocooderDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(VoocooderDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(VoocooderDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select first input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input 1", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select second input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input 2", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Vcd$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Voodoo Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Low Freq", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[15], Constants.spaces[18], Constants.spaces[19]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        paramField2.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("High Freq", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(new ParamSpace(1.0, 256.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Bands per Oct.", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 518, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Short");
        jComboBox.addItem("Medium");
        jComboBox.addItem("Long");
        jComboBox.addItem("Very long");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Filter length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 259, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (int i = 0; i < KMB_NAMES.length; ++i) {
            jComboBox2.addItem(KMB_NAMES[i]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Combination", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox2, 260, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block103: {
            float[] fArray;
            float[] fArray2;
            float[][][] fArray3;
            float[][][] fArray4;
            float[][] fArray5;
            float[][] fArray6;
            float[][] fArray7;
            float[][] fArray8;
            float[][] fArray9;
            float[][] fArray10;
            float[] fArray11;
            float[] fArray12;
            float[] fArray13;
            float[][] fArray14;
            float[] fArray15;
            float[][][] fArray16;
            float[][][] fArray17;
            float[][] fArray18;
            float[][] fArray19;
            Object object;
            float[] fArray20;
            float[] fArray21;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            AudioFileDescr audioFileDescr3;
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            float[][] fArray22 = null;
            float[] fArray23 = null;
            try {
                float f3;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr3 = audioFile3.getDescr();
                int n11 = audioFileDescr3.channels;
                int n12 = (int)audioFileDescr3.length;
                if (n12 * n11 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block103;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                audioFileDescr2 = audioFile2.getDescr();
                int n13 = audioFileDescr2.channels;
                n12 = (int)Math.min((long)n12, audioFileDescr2.length);
                int n14 = Math.max(n13, n11);
                if (n12 < 1) {
                    throw new EOFException("File is empty");
                }
                if (n13 > n11) {
                    throw new IOException(ERR_CHAN);
                }
                if (!this.threadRunning) break block103;
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr3);
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = n14;
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block103;
                double d = Param.transform((Param)this.pr.para[1], (int)3, null, null).value;
                double d2 = Param.transform((Param)this.pr.para[2], (int)3, (Param)this.pr.para[1], null).value;
                double d3 = Math.pow(2.0, 1.0 / this.pr.para[6].value);
                int n15 = (int)(Math.log(d2 / d) / Math.log(d3));
                float[] fArray24 = new float[n15 + 1];
                float[] fArray25 = new float[n15 + 1];
                int[] nArray = new int[n15];
                double d4 = d;
                double d5 = d4 * d3;
                float f4 = (float)(audioFileDescr3.rate * 0.5);
                for (n10 = 0; n10 <= n15; ++n10) {
                    fArray24[n10] = (float)d4;
                    fArray25[n10] = (float)(Math.sqrt(d5 * d4) - d4);
                    d4 = d5;
                    if (!((d5 = d4 * d3) > (double)f4)) continue;
                    n15 = n10;
                    break;
                }
                d2 = fArray24[n15];
                int n16 = 6;
                int n17 = Math.max(1, (int)((double)n16 * audioFileDescr3.rate / d + 0.5));
                double d6 = Math.PI * 2 / audioFileDescr3.rate;
                double d7 = 0.4052847345693511;
                int n18 = n17 + n17;
                int n19 = n18 + n18 - 1;
                for (n9 = 2; n9 < n19; n9 <<= 1) {
                }
                int n20 = n9 - n18 + 1;
                int n21 = n9 - n20;
                int n22 = Math.max(1, (int)((double)n16 * audioFileDescr3.rate / d2 + 0.5));
                float[] fArray26 = Filter.createFullWindow(n22 << 1, 1);
                double d8 = d6 * (audioFileDescr3.rate / 2.0);
                fArray21 = new float[n9 + 2];
                Util.clear(fArray21);
                fArray21[n17] = (float)d8;
                d8 = d6 * d2 * 0.8;
                double d9 = d6 * d2 * 0.04;
                double d10 = d9 * d9;
                for (n19 = 1; n19 < n22; ++n19) {
                    d4 = Math.sin(d8 * (double)n19) / (double)n19;
                    d5 = d7 * d10 * (double)n19 * (double)n19;
                    int n23 = n17 + n19;
                    fArray21[n23] = fArray21[n23] - (float)(d4 *= Math.cos(d9 * (double)n19) / (1.0 - d5));
                    int n24 = n17 - n19;
                    fArray21[n24] = fArray21[n24] - (float)d4;
                }
                int n25 = n17;
                fArray21[n25] = fArray21[n25] - (float)d8;
                Util.mult(fArray26, 0, fArray21, n17 - n22, fArray26.length);
                Fourier.realTransform(fArray21, n9, 1);
                Util.mult(fArray21, 0, fArray21.length, 0.31830987f);
                fArray26 = Filter.createFullWindow(n18, 1);
                d8 = d6 * (audioFileDescr3.rate / 2.0);
                fArray20 = new float[n9 + 2];
                Util.clear(fArray20);
                fArray20[n17] = (float)(Math.PI - d8);
                d8 = d6 * d * 1.2;
                d9 = d6 * d * 0.04;
                d10 = d9 * d9;
                for (n19 = 1; n19 < n17; ++n19) {
                    d4 = Math.sin(d8 * (double)n19) / (double)n19;
                    d5 = d7 * d10 * (double)n19 * (double)n19;
                    fArray20[n17 + n19] = (float)(d4 *= Math.cos(d9 * (double)n19) / (1.0 - d5));
                    fArray20[n17 - n19] = (float)d4;
                }
                int n26 = n17;
                fArray20[n26] = fArray20[n26] + (float)d8;
                Util.mult(fArray26, 0, fArray20, 0, n18);
                Fourier.realTransform(fArray20, n9, 1);
                Util.mult(fArray20, 0, fArray20.length, 0.31830987f);
                int n27 = 3 << this.pr.intg[3];
                int n28 = Math.max(1, (int)((double)n27 * audioFileDescr3.rate / (double)fArray24[0] + 0.5));
                int n29 = Math.max(1, (int)((double)n27 * audioFileDescr3.rate / (double)fArray24[n15 - 1] + 0.5));
                n10 = n29 + n29;
                n19 = n10 + n10 - 1;
                for (n8 = 2; n8 < n19; n8 <<= 1) {
                }
                n10 = n28 + n28;
                n19 = n10 + n10 - 1;
                for (n7 = 2; n7 < n19; n7 <<= 1) {
                }
                int n30 = 1;
                n10 = n8;
                while (n10 < n7) {
                    n10 <<= 1;
                    ++n30;
                }
                int[] nArray2 = new int[n30];
                int[] nArray3 = new int[n30];
                int[] nArray4 = new int[n30];
                object = new float[n15][];
                fArray19 = new float[n11][n7 + 2];
                fArray18 = new float[n13][n7 + 2];
                fArray17 = new float[n11][n15][];
                fArray16 = new float[n13][n15][];
                int n31 = -1;
                int n32 = -1;
                nArray2[0] = n31;
                nArray3[0] = 0;
                n10 = n7 - (n28 << 1) + 1;
                nArray4[0] = (n20 + n10 - 1) / n10;
                int n33 = n28;
                float[] fArray27 = Filter.createFullWindow(n33 << 1, 1);
                for (n6 = 0; n6 < n15; ++n6) {
                    n5 = n33;
                    float[] fArray28 = fArray27;
                    nArray[n6] = n5;
                    n33 = Math.max(1, (int)((double)n27 * audioFileDescr3.rate / (double)fArray24[n6 + 1] + 0.5));
                    fArray27 = Filter.createFullWindow(n33 << 1, 1);
                    n19 = (n5 + n5 << 1) - 1;
                    for (n22 = 2; n22 < n19; n22 <<= 1) {
                    }
                    fArray15 = new float[n22 + 2];
                    object[n6] = fArray15;
                    if (n22 != n31) {
                        n31 = n22;
                        nArray2[++n32] = n31;
                        n19 = n31 - (n5 << 1) + 1;
                        nArray4[n32] = (n20 + n19 - 1) / n19;
                    }
                    int n34 = n32;
                    nArray3[n34] = nArray3[n34] + 1;
                    n2 = n31 - (n5 << 1) + 1;
                    n4 = n31 - n2;
                    for (n = 0; n < n11; ++n) {
                        fArray17[n][n6] = new float[n4];
                    }
                    for (n = 0; n < n13; ++n) {
                        fArray16[n][n6] = new float[n4];
                    }
                    if (n6 < n15 - 1) {
                        d8 = d6 * (double)fArray24[n6 + 1];
                        d9 = d6 * (double)fArray25[n6 + 1];
                        d10 = d9 * d9;
                        for (n19 = 1; n19 < n33; ++n19) {
                            d4 = Math.sin(d8 * (double)n19) / (double)n19;
                            d5 = d7 * d10 * (double)n19 * (double)n19;
                            fArray15[n5 + n19] = (float)(d4 *= Math.cos(d9 * (double)n19) / (1.0 - d5)) * fArray27[n33 + n19];
                            fArray15[n5 - n19] = (float)d4 * fArray27[n33 - n19];
                        }
                        fArray15[n5] = (float)d8 * fArray27[n33];
                    } else {
                        Util.clear(fArray15);
                        fArray15[n5] = (float)Math.PI * fArray27[n33];
                    }
                    if (n6 > 0) {
                        d8 = d6 * (double)fArray24[n6];
                        d9 = d6 * (double)fArray25[n6];
                        d10 = d9 * d9;
                        for (n19 = 1; n19 < n5; ++n19) {
                            d4 = Math.sin(d8 * (double)n19) / (double)n19;
                            d5 = d7 * d10 * (double)n19 * (double)n19;
                            int n35 = n5 + n19;
                            fArray15[n35] = fArray15[n35] - (float)(d4 *= Math.cos(d9 * (double)n19) / (1.0 - d5)) * fArray28[n5 + n19];
                            int n36 = n5 - n19;
                            fArray15[n36] = fArray15[n36] - (float)d4 * fArray28[n5 - n19];
                        }
                        int n37 = n5;
                        fArray15[n37] = fArray15[n37] - (float)d8 * fArray28[n5];
                        for (n19 = n5 << 1; n19 < n31; ++n19) {
                            fArray15[n19] = 0.0f;
                        }
                    }
                    Fourier.realTransform(fArray15, n31, 1);
                    Util.mult(fArray15, 0, fArray15.length, 0.31830987f);
                }
                n30 = n32 + 1;
                fArray14 = new float[n14][n28 + n20];
                fArray13 = new float[n9 + 2];
                fArray12 = new float[n9 + 2];
                fArray11 = new float[n9 + 2];
                fArray10 = new float[n11][n21];
                fArray9 = new float[n13][n21];
                fArray8 = new float[n11][n21];
                fArray7 = new float[n13][n21];
                fArray6 = new float[n11][n20 + n17];
                fArray5 = new float[n13][n20 + n17];
                fArray4 = new float[n11][nArray4[n30 - 1]][n7 + 2];
                fArray3 = new float[n11][nArray4[n30 - 1]][n7 + 2];
                Util.clear(fArray6);
                Util.clear(fArray5);
                switch (this.pr.intg[4]) {
                    case 4: {
                        fArray22 = new float[n14][n15];
                        fArray23 = new float[n15];
                        Util.clear(fArray22);
                        for (n6 = 0; n6 < n15; ++n6) {
                            f3 = (float)audioFileDescr3.rate / fArray24[n6];
                            fArray23[n6] = f3 = (float)Math.pow(0.125, 1.0 / (double)(f3 * 4.0f));
                        }
                        break;
                    }
                }
                long l = 0L;
                long l2 = (long)n12 * 4L;
                float f5 = 0.0f;
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n11];
                    floatFileArray = new FloatFile[n11];
                    for (n = 0; n < n11; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n11; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n12;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block103;
                int n38 = 0;
                int n39 = 0;
                int n40 = n17 + n28;
                while (this.threadRunning && n39 < n12) {
                    int n41;
                    int n42;
                    int n43 = Math.min(n20, n12 - n38);
                    int n44 = Math.min(n20, n12 - n39);
                    for (n41 = 0; this.threadRunning && n41 < n43; n41 += n42) {
                        n42 = Math.min(8192, n43 - n41);
                        audioFile3.readFrames(fArray6, n41 + n17, n42);
                        audioFile2.readFrames(fArray5, n41 + n17, n42);
                        n38 += n42;
                        this.setProgression((float)(l += (long)n42) / (float)l2);
                    }
                    if (this.threadRunning) {
                        for (n = 0; this.threadRunning && n < n11; ++n) {
                            fArray15 = fArray14[n];
                            fArray2 = fArray6[n];
                            System.arraycopy(fArray2, n17, fArray13, 0, n43);
                            for (n10 = n43; n10 < n9; ++n10) {
                                fArray13[n10] = 0.0f;
                            }
                            Fourier.realTransform(fArray13, n9, 1);
                            Fourier.complexMult(fArray20, 0, fArray13, 0, fArray12, 0, fArray20.length);
                            Fourier.realTransform(fArray12, n9, -1);
                            Util.add(fArray10[n], 0, fArray12, 0, n21);
                            System.arraycopy(fArray12, n20, fArray10[n], 0, n21);
                            Fourier.complexMult(fArray21, 0, fArray13, 0, fArray11, 0, fArray21.length);
                            Fourier.realTransform(fArray11, n9, -1);
                            Util.add(fArray8[n], 0, fArray11, 0, n21);
                            System.arraycopy(fArray11, n20, fArray8[n], 0, n21);
                            Util.sub(fArray12, 0, fArray2, 0, n20);
                            Util.sub(fArray11, 0, fArray2, 0, n20);
                            System.arraycopy(fArray12, 0, fArray15, n28, n20);
                            Util.add(fArray11, 0, fArray15, n28, n20);
                            Util.mult(fArray15, n28, n20, f5);
                        }
                        if (this.threadRunning) {
                            for (n = 0; this.threadRunning && n < n13; ++n) {
                                fArray2 = fArray5[n];
                                System.arraycopy(fArray2, n17, fArray13, 0, n43);
                                for (n10 = n43; n10 < n9; ++n10) {
                                    fArray13[n10] = 0.0f;
                                }
                                Fourier.realTransform(fArray13, n9, 1);
                                Fourier.complexMult(fArray20, 0, fArray13, 0, fArray12, 0, fArray20.length);
                                Fourier.realTransform(fArray12, n9, -1);
                                Util.add(fArray9[n], 0, fArray12, 0, n21);
                                System.arraycopy(fArray12, n20, fArray9[n], 0, n21);
                                Fourier.complexMult(fArray21, 0, fArray13, 0, fArray11, 0, fArray21.length);
                                Fourier.realTransform(fArray11, n9, -1);
                                Util.add(fArray7[n], 0, fArray11, 0, n21);
                                System.arraycopy(fArray11, n20, fArray7[n], 0, n21);
                                Util.sub(fArray12, 0, fArray2, 0, n20);
                                Util.sub(fArray11, 0, fArray2, 0, n20);
                            }
                            if (this.threadRunning) {
                                n32 = -1;
                                int n45 = 0;
                                for (n6 = 0; this.threadRunning && n6 < n15; ++n6) {
                                    n5 = nArray[n6];
                                    if (n45 == 0) {
                                        n45 = nArray3[++n32];
                                        n31 = nArray2[n32];
                                        n2 = n31 - (n5 << 1) + 1;
                                        n3 = nArray4[n32];
                                        n41 = 0;
                                        for (n10 = 0; n10 < n3; ++n10) {
                                            n42 = Math.min(n2, n20 - n41);
                                            for (n = 0; n < n11; ++n) {
                                                fArray = fArray4[n][n10];
                                                fArray2 = fArray6[n];
                                                System.arraycopy(fArray2, n41, fArray, 0, n42);
                                                for (n19 = n42; n19 < n31; ++n19) {
                                                    fArray[n19] = 0.0f;
                                                }
                                                Fourier.realTransform(fArray, n31, 1);
                                            }
                                            for (n = 0; n < n13; ++n) {
                                                fArray = fArray3[n][n10];
                                                fArray2 = fArray5[n];
                                                System.arraycopy(fArray2, n41, fArray, 0, n42);
                                                for (n19 = n42; n19 < n31; ++n19) {
                                                    fArray[n19] = 0.0f;
                                                }
                                                Fourier.realTransform(fArray, n31, 1);
                                            }
                                            n41 += n42;
                                        }
                                    }
                                    --n45;
                                    n4 = (n5 << 1) - 1;
                                    int n46 = n28 - n5;
                                    n41 = 0;
                                    for (n10 = 0; n10 < n3; ++n10) {
                                        n42 = Math.min(n2, n20 - n41);
                                        for (n = 0; n < n11; ++n) {
                                            Fourier.complexMult(object[n6], 0, fArray4[n][n10], 0, fArray19[n], 0, object[n6].length);
                                            Fourier.realTransform(fArray19[n], n31, -1);
                                            Util.add(fArray17[n][n6], 0, fArray19[n], 0, n4);
                                            System.arraycopy(fArray19[n], n42, fArray17[n][n6], 0, n4);
                                        }
                                        for (n = 0; n < n13; ++n) {
                                            Fourier.complexMult(object[n6], 0, fArray3[n][n10], 0, fArray18[n], 0, object[n6].length);
                                            Fourier.realTransform(fArray18[n], n31, -1);
                                            Util.add(fArray16[n][n6], 0, fArray18[n], 0, n4);
                                            System.arraycopy(fArray18[n], n42, fArray16[n][n6], 0, n4);
                                        }
                                        switch (this.pr.intg[4]) {
                                            case 0: {
                                                for (n = 0; n < n14; ++n) {
                                                    fArray15 = fArray14[n];
                                                    fArray2 = fArray19[n % n11];
                                                    fArray = fArray18[n % n13];
                                                    n22 = n41 + n46;
                                                    for (n19 = 0; n19 < n42; ++n19) {
                                                        int n47 = n22++;
                                                        fArray15[n47] = fArray15[n47] + fArray2[n19] * fArray[n19] * (float)n15;
                                                    }
                                                }
                                                break;
                                            }
                                            case 1: {
                                                for (n = 0; n < n14; ++n) {
                                                    fArray15 = fArray14[n];
                                                    fArray2 = fArray19[n % n11];
                                                    fArray = fArray18[n % n13];
                                                    n22 = n41 + n46;
                                                    for (n19 = 0; n19 < n42; ++n19) {
                                                        int n48 = n22++;
                                                        fArray15[n48] = fArray15[n48] + fArray2[n19] % fArray[n19];
                                                    }
                                                }
                                                break;
                                            }
                                            case 2: {
                                                float f6;
                                                for (n = 0; n < n14; ++n) {
                                                    fArray15 = fArray14[n];
                                                    fArray2 = fArray19[n % n11];
                                                    fArray = fArray18[n % n13];
                                                    n19 = 0;
                                                    n22 = n41 + n46;
                                                    while (n19 < n42) {
                                                        f3 = fArray2[n19];
                                                        f6 = fArray[n19];
                                                        if (f3 > 0.0f) {
                                                            if (f6 < 0.0f) {
                                                                int n49 = n22;
                                                                fArray15[n49] = fArray15[n49] + (-f6 > f3 ? f3 : f6);
                                                            } else {
                                                                int n50 = n22;
                                                                fArray15[n50] = fArray15[n50] + (f6 > f3 ? f3 : f6);
                                                            }
                                                        } else if (f6 < 0.0f) {
                                                            int n51 = n22;
                                                            fArray15[n51] = fArray15[n51] + (f6 < f3 ? f3 : f6);
                                                        } else {
                                                            int n52 = n22;
                                                            fArray15[n52] = fArray15[n52] + (f6 > -f3 ? f3 : f6);
                                                        }
                                                        ++n19;
                                                        ++n22;
                                                    }
                                                }
                                                break;
                                            }
                                            case 3: {
                                                float f6;
                                                for (n = 0; n < n14; ++n) {
                                                    fArray15 = fArray14[n];
                                                    fArray2 = fArray19[n % n11];
                                                    fArray = fArray18[n % n13];
                                                    n19 = 0;
                                                    n22 = n41 + n46;
                                                    while (n19 < n42) {
                                                        f3 = fArray2[n19];
                                                        f6 = fArray[n19];
                                                        if (f3 > 0.0f) {
                                                            if (f6 < 0.0f) {
                                                                int n53 = n22;
                                                                fArray15[n53] = fArray15[n53] + (-f6 > f3 ? f6 : f3);
                                                            } else {
                                                                int n54 = n22;
                                                                fArray15[n54] = fArray15[n54] + (f6 > f3 ? f6 : f3);
                                                            }
                                                        } else if (f6 < 0.0f) {
                                                            int n55 = n22;
                                                            fArray15[n55] = fArray15[n55] + (f6 < f3 ? f6 : f3);
                                                        } else {
                                                            int n56 = n22;
                                                            fArray15[n56] = fArray15[n56] + (f6 > -f3 ? f6 : f3);
                                                        }
                                                        ++n19;
                                                        ++n22;
                                                    }
                                                }
                                                break;
                                            }
                                            case 4: {
                                                float f6;
                                                for (n = 0; n < n14; ++n) {
                                                    fArray15 = fArray14[n];
                                                    fArray2 = fArray19[n % n11];
                                                    fArray = fArray18[n % n13];
                                                    f6 = fArray22[n][n6];
                                                    float f7 = fArray23[n6];
                                                    float f8 = (1.0f - f7) * (float)n15;
                                                    n22 = n41 + n46;
                                                    for (n19 = 0; n19 < n42; ++n19) {
                                                        f3 = fArray[n19];
                                                        f6 = Math.abs(f3) * f8 + f7 * f6;
                                                        int n57 = n22++;
                                                        fArray15[n57] = fArray15[n57] + fArray2[n19] * f6;
                                                    }
                                                    fArray22[n][n6] = f6;
                                                }
                                                break;
                                            }
                                        }
                                        n41 += n42;
                                    }
                                }
                                if (this.threadRunning) {
                                    for (n = 0; n < n11; ++n) {
                                        fArray2 = fArray6[n];
                                        System.arraycopy(fArray2, n20, fArray2, 0, n17);
                                    }
                                    for (n = 0; n < n13; ++n) {
                                        fArray2 = fArray5[n];
                                        System.arraycopy(fArray2, n20, fArray2, 0, n17);
                                    }
                                    this.setProgression((float)(l += (long)(n44 + n44)) / (float)l2);
                                    if (this.threadRunning) {
                                        for (n41 = n40; this.threadRunning && n41 < n44; n41 += n42) {
                                            n42 = Math.min(8192, n44 - n41);
                                            if (floatFileArray != null) {
                                                for (n = 0; n < n14; ++n) {
                                                    floatFileArray[n].writeFloats(fArray14[n], n41, n42);
                                                }
                                            } else {
                                                for (n = 0; n < n14; ++n) {
                                                    Util.mult(fArray14[n], n41, n42, f);
                                                }
                                                audioFile.writeFrames(fArray14, n41, n42);
                                            }
                                            this.setProgression((float)(l += (long)n42) / (float)l2);
                                        }
                                        for (n = 0; n < n14; ++n) {
                                            fArray15 = fArray14[n];
                                            for (n41 = n40; n41 < n44; ++n41) {
                                                f3 = Math.abs(fArray15[n41]);
                                                if (!(f3 > f2)) continue;
                                                f2 = f3;
                                            }
                                            System.arraycopy(fArray15, n20, fArray15, 0, n28);
                                        }
                                        if (n40 > 0) {
                                            n39 += Math.max(0, n44 - n40);
                                            n40 = Math.max(0, n40 - n44);
                                            continue;
                                        }
                                        n39 += n44;
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                    break block103;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        f3 = 1.0f;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray14, f, f3);
                        f2 *= f;
                        for (n = 0; n < n11; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr = null;
                        audioFile3.close();
                        audioFile3 = null;
                        audioFileDescr3 = null;
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr2 = null;
                        object = null;
                        fArray10 = null;
                        fArray9 = null;
                        fArray8 = null;
                        fArray7 = null;
                        fArray4 = null;
                        fArray3 = null;
                        fArray17 = null;
                        fArray16 = null;
                        fArray15 = null;
                        fArray2 = null;
                        fArray = null;
                        fArray6 = null;
                        fArray5 = null;
                        fArray14 = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr3 = null;
                audioFileDescr2 = null;
                audioFileDescr = null;
                fArray20 = null;
                fArray21 = null;
                fArray11 = null;
                fArray12 = null;
                fArray13 = null;
                fArray19 = null;
                fArray18 = null;
                object = null;
                fArray10 = null;
                fArray9 = null;
                fArray8 = null;
                fArray7 = null;
                fArray4 = null;
                fArray3 = null;
                fArray17 = null;
                fArray16 = null;
                fArray15 = null;
                fArray2 = null;
                fArray = null;
                fArray6 = null;
                fArray5 = null;
                fArray14 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
            audioFile3 = null;
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
                fileArray[n] = null;
            }
        }
    }
}

