/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.net;

import de.sciss.fscape.net.OSCRoot;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.net.SocketAddress;

public class RoutedOSCMessage {
    public final OSCMessage msg;
    public final SocketAddress addr;
    public final long when;
    public final OSCRoot server;
    private final String[] path;
    private final int pathIdx;

    public RoutedOSCMessage(OSCMessage oSCMessage, SocketAddress socketAddress, long l, OSCRoot oSCRoot, String[] stringArray, int n) {
        this.msg = oSCMessage;
        this.addr = socketAddress;
        this.when = l;
        this.server = oSCRoot;
        this.path = stringArray;
        this.pathIdx = n;
    }

    public int getPathIndex() {
        return this.pathIdx;
    }

    public int getPathCount() {
        return this.path.length;
    }

    public String getPathComponent(int n) {
        return this.path[n];
    }

    public String getPathComponent() {
        return this.path[this.pathIdx];
    }

    public String getNextPathComponent() {
        return this.getNextPathComponent(1);
    }

    public String getNextPathComponent(int n) {
        return this.path[this.pathIdx + n];
    }

    public boolean hasNext() {
        return this.hasNext(1);
    }

    public boolean hasNext(int n) {
        return this.pathIdx + n < this.path.length;
    }

    public RoutedOSCMessage next() {
        return this.next(1);
    }

    public RoutedOSCMessage next(int n) {
        return new RoutedOSCMessage(this.msg, this.addr, this.when, this.server, this.path, this.pathIdx + n);
    }

    public void reply(String string, Object[] objectArray) throws IOException {
        this.server.send((OSCPacket)new OSCMessage(string, objectArray), this.addr);
    }

    public void tryReplyFailed(int n) {
        try {
            this.replyFailed(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void replyFailed(int n) throws IOException {
        Object[] objectArray = new Object[n + 1];
        objectArray[0] = this.msg.getName();
        for (int i = 0; i < n; ++i) {
            objectArray[i + 1] = this.msg.getArg(i);
        }
        this.server.send((OSCPacket)new OSCMessage("/failed", objectArray), this.addr);
    }

    public void tryReplyDone(int n, Object[] objectArray) {
        try {
            this.replyDone(n, objectArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void replyDone(int n, Object[] objectArray) throws IOException {
        int n2;
        Object[] objectArray2 = new Object[n + objectArray.length + 1];
        int n3 = 0;
        objectArray2[n3++] = this.msg.getName();
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n3++] = this.msg.getArg(n2);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray2[n3++] = objectArray[n2];
        }
        this.server.send((OSCPacket)new OSCMessage("/done", objectArray2), this.addr);
    }
}

