/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import java.io.EOFException;
import java.io.IOException;

public class ContrastOp
extends Operator {
    protected static final String defaultName = "Contrast";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_CONTRAST = 0;
    private static final int PR_MAXBOOST = 1;
    private static final String PRN_CONTRAST = "Contrast";
    private static final String PRN_MAXBOOST = "MaxBoost";
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Contrast", "MaxBoost"};

    public ContrastOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), ContrastOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ContrastOp.static_pr.para = prPara;
            ContrastOp.static_pr.para[0] = new Param(24.0, 785);
            ContrastOp.static_pr.para[1] = new Param(36.0, 785);
            ContrastOp.static_pr.paraName = prParaName;
            ContrastOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "ContrastOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, "Contrast");
    }

    @Override
    public void run() {
        block19: {
            this.runInit();
            Param param = new Param(1.0, 1);
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block19;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                int n = spectStream.bands;
                int n2 = n - 1;
                int n3 = n2 >> 1;
                float[] fArray = Filter.createFullWindow(n2, 1);
                int n4 = n - 1;
                int n5 = n4 << 1;
                float[] fArray2 = new float[n5 + 2];
                double d = Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value - 1.0;
                float f = (float)Param.transform((Param)this.pr.para[1], (int)1, (Param)param, null).value;
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        float[] fArray3 = spectFrame.data[i];
                        float[] fArray4 = spectFrame2.data[i];
                        fArray2[0] = 1.0f;
                        fArray2[1] = 0.0f;
                        int n6 = 2;
                        while (n6 < n5) {
                            float f2 = fArray3[n6 - 2] + fArray3[n6 + 2];
                            float f3 = f2 > 0.0f ? (float)Math.min((double)f, Math.pow(2.0f * fArray3[n6] / f2, d)) : (fArray3[n6] == 0.0f ? 1.0f : f);
                            fArray2[n6++] = f3;
                            fArray2[n6++] = 0.0f;
                        }
                        fArray2[n6++] = 1.0f;
                        fArray2[n6++] = 0.0f;
                        Fourier.realTransform(fArray2, n5, -1);
                        Util.mult(fArray, n3, fArray2, 0, n3);
                        n6 = n3;
                        while (n6 < n5 - n3) {
                            fArray2[n6++] = 0.0f;
                        }
                        Util.mult(fArray, 0, fArray2, n6, n3);
                        Fourier.realTransform(fArray2, n5, 1);
                        for (n6 = 0; n6 <= n5; ++n6) {
                            fArray4[n6] = fArray3[n6] * fArray2[n6];
                            fArray4[++n6] = fArray3[n6];
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbContrast;pf7,prContrast\nlbMax.boost;pf7,prMaxBoost\n");
        return propertyGUI;
    }
}

