/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.FilterBox;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFileDescr;
import java.awt.Point;
import java.io.EOFException;
import java.io.IOException;

public class EnvOp
extends Operator {
    protected static final String defaultName = "Envelope";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_GAIN = 0;
    private static final int PR_INVERT = 0;
    private static final String PRN_GAIN = "Gain";
    private static final String PRN_INVERT = "Invert";
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Gain"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"Invert"};

    public EnvOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), EnvOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            EnvOp.static_pr.para = prPara;
            EnvOp.static_pr.para[0] = new Param(0.0, 785);
            EnvOp.static_pr.paraName = prParaName;
            EnvOp.static_pr.bool = prBool;
            EnvOp.static_pr.boolName = prBoolName;
            EnvOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "EnvOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block21: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            Param param = new Param(1.0, 1);
            try {
                double d;
                int n;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block21;
                int n2 = spectStream.bands;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                float f = 2.0f * (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, (SpectStream)spectStream).value;
                double d2 = (double)spectStream.smpRate * 0.245;
                double d3 = 1.5393804002589986;
                FilterBox filterBox = new FilterBox();
                filterBox.filterType = 1;
                filterBox.cutOff = new Param(d2, 3);
                AudioFileDescr audioFileDescr = new AudioFileDescr();
                audioFileDescr.rate = spectStream.smpRate;
                Point point = filterBox.calcLength(audioFileDescr, 3);
                int n3 = point.x;
                int n4 = point.x + point.y;
                int n5 = n4 + n2 - 1;
                for (n = 2; n < n5; n <<= 1) {
                }
                float[] fArray = new float[n << 1];
                float[] fArray2 = new float[n << 1];
                Util.clear(fArray);
                filterBox.calcIR(audioFileDescr, 3, 1, fArray, point);
                n5 = fArray.length - 1;
                for (n4 = n - 1; n4 >= 0; --n4) {
                    d = -d3 * (double)n4;
                    fArray[n5--] = (float)((double)fArray[n4] * Math.sin(d));
                    fArray[n5--] = (float)((double)fArray[n4] * Math.cos(d));
                }
                Fourier.complexTransform(fArray, n, 1);
                this.runSlotsReady();
                block13: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block13;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        float[] fArray3 = spectFrame.data[i];
                        Fourier.polar2Rect(fArray3, 0, fArray2, 0, n2 << 1);
                        for (n4 = n2 << 1; n4 < fArray2.length; ++n4) {
                            fArray2[n4] = 0.0f;
                        }
                        Fourier.complexTransform(fArray2, n, 1);
                        Fourier.complexMult(fArray, 0, fArray2, 0, fArray2, 0, n << 1);
                        Fourier.complexTransform(fArray2, n, -1);
                        fArray3 = spectFrame2.data[i];
                        n4 = 0;
                        n5 = n3 << 1;
                        while (n4 < n2 << 1) {
                            d = fArray2[n5++];
                            double d4 = fArray2[n5++];
                            fArray3[n4++] = f * (float)Math.sqrt(d * d + d4 * d4);
                            fArray3[n4++] = 0.0f;
                        }
                        if (!this.pr.bool[0]) continue;
                        n4 = 0;
                        n5 = 0;
                        while (n4 < n2) {
                            fArray3[n5] = 1.0f - fArray3[n5];
                            ++n4;
                            n5 += 2;
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\ncbInvert,prInvert\nlbGain;pf7,pr" + this.pr.paraName[0]);
        return propertyGUI;
    }
}

