/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.SpectPatch;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Slots;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.rmi.NotBoundException;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class Operator
implements Runnable,
Slots,
Cloneable,
Transferable {
    public static final String PACKAGE = "de.sciss.fscape.op";
    public static DataFlavor flavor = null;
    public static final int GUI_PREFS = 0;
    public static final String PRN_SPECTRO = "Spectrogram";
    public static final int FLAGS_ALIAS = 1;
    public static final int FLAGS_BYPASS = 2;
    public boolean threadDead = true;
    public boolean threadPaused = false;
    public boolean threadPausing = false;
    public SpectPatch owner = null;
    protected OpIcon icon;
    protected Vector<SpectStreamSlot> slots;
    protected Vector<Operator> aliases;
    protected Operator original = null;
    protected static final String ERR_ALIASSYNC = "Original is of different type";
    protected static final String ERR_ALREADYALIAS = "Object is already an alias";
    private static TreeMap<String, String> OPERATORS;
    private static DataFlavor[] flavors;
    protected boolean disposed = false;
    protected static final String ERR_DISPOSED = "Operator disposed";
    protected String opName = null;
    protected Presets presets = null;
    protected Prefs prefs = null;
    protected PropertyArray pr;
    protected static PropertyArray op_static_pr;
    private static final int PR_SPECTRO = 0;
    private static final int PR_FLAGS = 0;
    protected static final String PRN_FLAGS = "Flags";
    private static final boolean[] prBool;
    private static final String[] prBoolName;
    private static final int[] prIntg;
    private static final String[] prIntgName;
    private String threadError = null;
    private float threadProgress = 0.0f;

    public Operator() {
        if (op_static_pr == null) {
            op_static_pr = new PropertyArray();
            Operator.op_static_pr.bool = prBool;
            Operator.op_static_pr.boolName = prBoolName;
            Operator.op_static_pr.intg = prIntg;
            Operator.op_static_pr.intgName = prIntgName;
        }
        this.slots = new Vector();
        this.aliases = new Vector();
        if (flavor == null) {
            flavor = new DataFlavor(this.getClass(), "Operator");
        }
    }

    public static Map getOperators() {
        if (OPERATORS.isEmpty()) {
            OPERATORS.put("Input file", "InputOp");
            OPERATORS.put("Output file", "OutputOp");
            OPERATORS.put("Analyse", "AnalysisOp");
            OPERATORS.put("Synthesize", "SynthesisOp");
            OPERATORS.put("Flip freq", "FlipFreqOp");
            OPERATORS.put("Log freq", "LogFreqOp");
            OPERATORS.put("Splitter", "SplitterOp");
            OPERATORS.put("Unitor", "UnitorOp");
            OPERATORS.put("Mono2Stereo", "Mono2StereoOp");
            OPERATORS.put("Smear", "SmearOp");
            OPERATORS.put("Zoom", "ZoomOp");
            OPERATORS.put("Shrink", "ShrinkOp");
            OPERATORS.put("Envelope", "EnvOp");
            OPERATORS.put("Cepstral", "CepstralOp");
            OPERATORS.put("Convolve", "ConvOp");
            OPERATORS.put("Contrast", "ContrastOp");
            OPERATORS.put("Extrapolate", "ExtrapolateOp");
            OPERATORS.put("Tarnish", "TarnishOp");
            OPERATORS.put("Percussion", "PercussionOp");
            OPERATORS.put("Mindmachine", "MindmachineOp");
            OPERATORS.put("Amp Env", "AmpEnvOp");
        }
        return OPERATORS;
    }

    public PropertyArray getPropertyArray() {
        return this.pr;
    }

    public Presets getPresets() {
        return this.presets;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public int getFlags() {
        return this.pr.superPr.intg[0];
    }

    public void dispose() {
        if (this.original != null) {
            this.original.forgetAlias(this);
        }
        this.disposed = true;
    }

    public Enumeration getAliases() {
        return this.aliases.elements();
    }

    public Operator getOriginal() {
        return this.original;
    }

    public void turnIntoAlias(Operator operator) throws SyncFailedException, SlotAlreadyConnectedException {
        while (operator.getOriginal() != null) {
            operator = operator.getOriginal();
        }
        if (operator.getClass() != this.getClass()) {
            throw new SyncFailedException(ERR_ALIASSYNC);
        }
        if (this.original != null) {
            throw new SlotAlreadyConnectedException(ERR_ALREADYALIAS);
        }
        this.original = operator;
        operator.registerAlias(this);
        this.pr.superPr.intg[0] = this.pr.superPr.intg[0] | 1;
        ((OpIcon)this.getIcon()).operatorFlagsChanged(this.pr.superPr.intg[0]);
    }

    public void turnIntoGenuine() {
        if (this.original != null) {
            PropertyArray propertyArray = this.pr.superPr;
            this.pr = new PropertyArray(this.original.getPropertyArray());
            this.pr.superPr = propertyArray;
            this.original.forgetAlias(this);
            this.original = null;
            this.pr.superPr.intg[0] = this.pr.superPr.intg[0] & 0xFFFFFFFE;
            ((OpIcon)this.getIcon()).operatorFlagsChanged(this.pr.superPr.intg[0]);
        }
    }

    protected void registerAlias(Operator operator) {
        this.aliases.addElement(operator);
    }

    protected void forgetAlias(Operator operator) {
        this.aliases.removeElement(operator);
    }

    public PropertyGUI createGUI(int n) {
        return new PropertyGUI("lbNothing here");
    }

    public Component getIcon() {
        return this.icon;
    }

    public String getError() {
        return this.threadError;
    }

    public void setError(String string) {
        this.threadError = string;
    }

    public float getProgress() {
        return this.threadProgress;
    }

    public void setProgress(float f) {
        this.threadProgress = f;
    }

    protected void runInit() {
        this.setProgress(0.0f);
        if (this.original != null) {
            PropertyArray propertyArray = this.pr.superPr;
            this.pr = new PropertyArray(this.original.getPropertyArray());
            this.pr.superPr = propertyArray;
        }
    }

    protected void runSlotsReady() {
        if (this.pr.superPr.bool[0]) {
            Enumeration<SpectStreamSlot> enumeration = this.getSlots(32).elements();
            while (enumeration.hasMoreElements()) {
                SpectStreamSlot spectStreamSlot = enumeration.nextElement();
                spectStreamSlot.createSpectrogram();
            }
        }
    }

    protected void runQuit(Exception exception) {
        Enumeration<SpectStreamSlot> enumeration = this.getSlots(0).elements();
        this.threadDead = true;
        while (enumeration.hasMoreElements()) {
            SpectStreamSlot spectStreamSlot = enumeration.nextElement();
            spectStreamSlot.cleanUp();
        }
        if (exception == null) {
            this.setProgress(1.0f);
            this.getIcon().repaint();
        } else {
            ((OpIcon)this.getIcon()).setSelected(1);
            this.setError(exception.getMessage());
            System.out.println(this.icon.getName() + ": aborted because of: " + this.threadError);
        }
        this.owner.operatorTerminated(this);
    }

    protected synchronized void runCheckPause() {
        try {
            if (this.threadPaused && !this.threadDead) {
                this.threadPausing = true;
                this.owner.operatorPaused(this);
                while (this.threadPaused && !this.threadDead) {
                    this.wait();
                }
                this.threadPausing = false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.threadPausing = false;
        }
    }

    protected void runFrameDone(SpectStreamSlot spectStreamSlot, SpectFrame spectFrame) {
        float f = SpectStreamSlot.progress(spectStreamSlot);
        if (f - this.getProgress() >= 0.04f) {
            this.setProgress(f);
            ((OpIcon)this.getIcon()).paintProgress(null);
        }
    }

    @Override
    public void run() {
        this.runInit();
        this.runSlotsReady();
        this.runQuit(null);
    }

    public synchronized void runStop() {
        this.threadPaused = false;
        this.threadDead = true;
        this.notify();
    }

    public synchronized void runPause(boolean bl) {
        this.threadPaused = bl;
        this.notify();
    }

    @Override
    public Vector<SpectStreamSlot> getSlots(int n) {
        Vector<SpectStreamSlot> vector = new Vector<SpectStreamSlot>();
        for (int i = 0; i < this.slots.size(); ++i) {
            SpectStreamSlot spectStreamSlot = this.slots.elementAt(i);
            if ((spectStreamSlot.getFlags() & n) != n) continue;
            vector.addElement(spectStreamSlot);
        }
        return vector;
    }

    @Override
    public SpectStreamSlot getSlot(String string) {
        for (int i = 0; i < this.slots.size(); ++i) {
            SpectStreamSlot spectStreamSlot = this.slots.elementAt(i);
            if (!spectStreamSlot.toString().equals(string)) continue;
            return spectStreamSlot;
        }
        return null;
    }

    @Override
    public void linkTo(String string, Slots slots, String string2) throws SyncFailedException, SlotAlreadyConnectedException, NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public void divorceFrom(String string, Slots slots, String string2) throws NotBoundException, NoSuchElementException {
        throw new NoSuchElementException();
    }

    public Object clone() {
        if (this.disposed) {
            return null;
        }
        Operator operator = null;
        try {
            operator = (Operator)this.getClass().newInstance();
            operator.pr = (PropertyArray)this.getPropertyArray().clone();
            if (this.getOriginal() != null) {
                operator.turnIntoAlias(this.getOriginal());
            }
            ((OpIcon)operator.getIcon()).setName(((OpIcon)this.getIcon()).getName());
            return operator;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SyncFailedException syncFailedException) {
            operator.dispose();
        }
        catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
            operator.dispose();
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (flavors == null) {
            DataFlavor[] dataFlavorArray = this.icon.getTransferDataFlavors();
            flavors = new DataFlavor[dataFlavorArray.length + 1];
            Operator.flavors[0] = flavor;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                Operator.flavors[i + 1] = dataFlavorArray[i];
            }
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavor)) {
            if (this.disposed) {
                throw new IOException(ERR_DISPOSED);
            }
            return this;
        }
        return this.icon.getTransferData(dataFlavor);
    }

    protected static Properties getDefaultPrefs() {
        Properties properties = new Properties();
        properties.put("OpEditDimensions", "256,256");
        return properties;
    }

    static {
        flavors = null;
        op_static_pr = null;
        prBool = new boolean[]{false};
        prBoolName = new String[]{PRN_SPECTRO};
        prIntg = new int[]{0};
        prIntgName = new String[]{PRN_FLAGS};
        OPERATORS = new TreeMap();
    }
}

