/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import java.io.EOFException;
import java.io.IOException;

public class PercussionOp
extends Operator {
    protected static final String defaultName = "Percussion";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_CRR = 0;
    private static final int PR_CRI = 1;
    private static final int PR_CLR = 2;
    private static final int PR_CLI = 3;
    private static final int PR_CCR = 4;
    private static final int PR_CCI = 5;
    private static final int PR_CAR = 6;
    private static final int PR_CAI = 7;
    private static final String PRN_CRR = "CRR";
    private static final String PRN_CRI = "CRI";
    private static final String PRN_CLR = "CLR";
    private static final String PRN_CLI = "CLI";
    private static final String PRN_CCR = "CCR";
    private static final String PRN_CCI = "CCI";
    private static final String PRN_CAR = "CAR";
    private static final String PRN_CAI = "CAI";
    private static final int[] prIntg = new int[]{2, 2, 1, 1, 2, 0, 1, 1};
    private static final String[] prIntgName = new String[]{"CRR", "CRI", "CLR", "CLI", "CCR", "CCI", "CAR", "CAI"};

    public PercussionOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), PercussionOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            PercussionOp.static_pr.intg = prIntg;
            PercussionOp.static_pr.intgName = prIntgName;
            PercussionOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "PercussionOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block20: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block20;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                int n = spectStream.bands;
                int n2 = n - 1;
                int n3 = n2 << 1;
                int n4 = n3 << 1;
                float[] fArray = new float[n4];
                int n5 = this.pr.intg[0] - 1;
                int n6 = this.pr.intg[1] - 1;
                int n7 = this.pr.intg[2] - 1;
                int n8 = this.pr.intg[3] - 1;
                int n9 = this.pr.intg[4] - 1;
                int n10 = this.pr.intg[5] - 1;
                int n11 = this.pr.intg[6] - 1;
                int n12 = this.pr.intg[7] - 1;
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        int n13;
                        float[] fArray2 = spectFrame.data[i];
                        float[] fArray3 = spectFrame2.data[i];
                        for (n13 = 0; n13 <= n3; ++n13) {
                            fArray[n13] = (float)Math.log(Math.max(1.0E-24, (double)fArray2[n13]));
                            fArray[++n13] = fArray2[n13];
                        }
                        n13 = n3 + 2;
                        int n14 = n3 - 2;
                        while (n13 < n4) {
                            fArray[n13++] = fArray[n14];
                            fArray[n13++] = -fArray[n14 + 1];
                            n14 -= 2;
                        }
                        Fourier.complexTransform(fArray, n3, -1);
                        fArray[0] = fArray[0] * (float)n5;
                        fArray[1] = fArray[1] * (float)n6;
                        n13 = 2;
                        n14 = n4 - 2;
                        while (n13 < n3) {
                            float f = fArray[n13];
                            float f2 = fArray[n14];
                            fArray[n13] = (float)n5 * f + (float)n9 * f2;
                            fArray[n14] = (float)n7 * f2 + (float)n11 * f;
                            f = fArray[n13 + 1];
                            f2 = fArray[n14 + 1];
                            fArray[n13 + 1] = (float)n6 * f + (float)n10 * f2;
                            fArray[n14 + 1] = (float)n8 * f2 + (float)n12 * f;
                            n13 += 2;
                            n14 -= 2;
                        }
                        int n15 = n13++;
                        fArray[n15] = fArray[n15] * (float)(n9 + n7);
                        int n16 = n13++;
                        fArray[n16] = fArray[n16] * (float)(n10 + n8);
                        Fourier.complexTransform(fArray, n3, 1);
                        for (n13 = 0; n13 <= n3; ++n13) {
                            fArray3[n13] = (float)Math.exp(fArray[n13]);
                            fArray3[++n13] = fArray[n13];
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        String string = ",it -1,it  0,it +1\n";
        PropertyGUI propertyGUI = new PropertyGUI("glCoefficients\nlbRight Wing Real;ch,prCRR" + string + "lbRight Wing Imag;ch,pr" + PRN_CRI + string + "lbLeft Wing Real;ch,pr" + PRN_CLR + string + "lbLeft Wing Imag;ch,pr" + PRN_CLI + string + "lbCausal Real;ch,pr" + PRN_CCR + string + "lbCausal Imag;ch,pr" + PRN_CCI + string + "lbAnticausal Real;ch,pr" + PRN_CAR + string + "lbAnticausal Imag;ch,pr" + PRN_CAI + string);
        return propertyGUI;
    }
}

