/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Modulator;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;

public class SplitterOp
extends Operator {
    protected static final String defaultName = "Splitter";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int NUM_OUTPUT = 6;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_CHANNELS = 0;
    private static final int PR_NORMALIZE = 0;
    private static final int PR_GAINMOD = 1;
    private static final int PR_NORMGAIN = 0;
    private static final int PR_GAIN = 1;
    private static final int PR_GAINMODDEPTH = 7;
    private static final int PR_GAINMODENV = 0;
    private static final int PR_CHANNELS_ALL = 0;
    private static final int PR_CHANNELS_SINGLE = 1;
    private static final String PRN_CHANNELS = "Channels";
    private static final String PRN_GAIN = "Gain";
    private static final String PRN_GAINMOD = "GainMod";
    private static final String PRN_GAINMODDEPTH = "GainModDepth";
    private static final String PRN_GAINMODENV = "GainModEnv";
    private static final String PRN_NORMALIZE = "Normalize";
    private static final String PRN_NORMGAIN = "NormGain";
    private static final int[] prIntg = new int[]{0};
    private static final String[] prIntgName = new String[]{"Channels"};

    public SplitterOp() {
        int n;
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), SplitterOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SplitterOp.static_pr.intg = prIntg;
            SplitterOp.static_pr.intgName = prIntgName;
            SplitterOp.static_pr.bool = new boolean[7];
            SplitterOp.static_pr.boolName = new String[7];
            SplitterOp.static_pr.para = new Param[13];
            SplitterOp.static_pr.paraName = new String[13];
            SplitterOp.static_pr.envl = new Envelope[6];
            SplitterOp.static_pr.envlName = new String[6];
            SplitterOp.static_pr.bool[0] = false;
            SplitterOp.static_pr.boolName[0] = PRN_NORMALIZE;
            SplitterOp.static_pr.para[0] = new Param(0.0, 785);
            SplitterOp.static_pr.paraName[0] = PRN_NORMGAIN;
            for (n = 0; n < 6; ++n) {
                SplitterOp.static_pr.para[1 + n] = new Param(0.0, 785);
                SplitterOp.static_pr.para[7 + n] = new Param(96.0, 785);
                SplitterOp.static_pr.paraName[1 + n] = PRN_GAIN + (n + 1);
                SplitterOp.static_pr.paraName[7 + n] = PRN_GAINMODDEPTH + (n + 1);
                SplitterOp.static_pr.envl[0 + n] = Envelope.createBasicEnvelope(0);
                SplitterOp.static_pr.envlName[0 + n] = PRN_GAINMODENV + (n + 1);
                SplitterOp.static_pr.bool[1 + n] = false;
                SplitterOp.static_pr.boolName[1 + n] = PRN_GAINMOD + (n + 1);
            }
            SplitterOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "SplitterOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        for (n = 0; n < 6; ++n) {
            this.slots.addElement(new SpectStreamSlot(this, 32, "out" + (n + 1)));
        }
        this.icon = new OpIcon(this, 15, defaultName);
    }

    @Override
    public void run() {
        block35: {
            this.runInit();
            SpectStreamSlot[] spectStreamSlotArray = new SpectStreamSlot[6];
            SpectStream spectStream = null;
            SpectStream[] spectStreamArray = new SpectStream[6];
            SpectFrame spectFrame = null;
            SpectFrame[] spectFrameArray = new SpectFrame[6];
            int[] nArray = new int[6];
            int[] nArray2 = new int[6];
            Param param = new Param(1.0, 1);
            Param[] paramArray = new Param[6];
            float[] fArray = new float[6];
            Modulator[] modulatorArray = new Modulator[6];
            int n = 0;
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                int n2 = 0;
                while (n2 == 0 && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        n2 = 1;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block35;
                for (n2 = 0; n2 < 6; ++n2) {
                    spectStreamSlotArray[n] = (SpectStreamSlot)this.slots.elementAt(1 + n2);
                    if (spectStreamSlotArray[n].getLinked() == null) continue;
                    spectStreamArray[n] = new SpectStream(spectStream);
                    if (this.pr.intg[0] == 1) {
                        spectStreamArray[n].setChannels(1);
                        nArray2[n] = n % spectStream.chanNum;
                    } else {
                        nArray2[n] = 0;
                    }
                    spectStreamSlotArray[n].initWriter(spectStreamArray[n]);
                    nArray[n] = n2;
                    ++n;
                }
                double d = Param.transform((Param)this.pr.para[0], (int)1, (Param)param, (SpectStream)spectStream).value;
                for (n2 = 0; n2 < n; ++n2) {
                    paramArray[n2] = Param.transform(this.pr.para[1 + nArray[n2]], 1, param, spectStream);
                    if (!this.pr.bool[1 + nArray[n2]]) continue;
                    modulatorArray[n2] = new Modulator(paramArray[n2], this.pr.para[7 + nArray[n2]], this.pr.envl[0 + nArray[n2]], spectStream);
                }
                int n3 = this.pr.intg[0] == 1 ? 1 : spectStream.chanNum;
                this.runSlotsReady();
                block15: while (!this.threadDead && n > 0) {
                    int n4;
                    n2 = 0;
                    while (n2 == 0 && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            n2 = 1;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block15;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    double d2 = 0.0;
                    for (n2 = 0; n2 < n; ++n2) {
                        fArray[n2] = this.pr.bool[1 + nArray[n2]] ? (float)modulatorArray[n2].calc().value : (float)paramArray[n2].value;
                        d2 += (double)fArray[n2];
                    }
                    if (this.pr.bool[0]) {
                        n2 = 0;
                        while (n2 < n) {
                            int n5 = n2++;
                            fArray[n5] = fArray[n5] * (float)(d / d2);
                        }
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        if (Math.abs(fArray[n2] - 1.0f) < 1.0E-7f && this.pr.intg[0] == 0) {
                            spectFrameArray[n2] = new SpectFrame(spectFrame);
                            fArray[n2] = 1.0f;
                            continue;
                        }
                        spectFrameArray[n2] = spectStreamArray[n2].allocFrame();
                        for (int i = 0; i < n3; ++i) {
                            float[] fArray2 = spectFrame.data[nArray2[n2] + i];
                            float[] fArray3 = spectFrameArray[n2].data[i];
                            if (fArray[n2] < 1.0E-7f) {
                                for (n4 = 0; n4 < fArray3.length; ++n4) {
                                    fArray3[n4] = 0.0f;
                                }
                                continue;
                            }
                            System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
                            if (Math.abs(fArray[n2] - 1.0f) >= 1.0E-7f) {
                                for (n4 = 0; n4 < fArray3.length; n4 += 2) {
                                    int n6 = n4 + 0;
                                    fArray3[n6] = fArray3[n6] * fArray[n2];
                                }
                                continue;
                            }
                            fArray[n2] = 1.0f;
                        }
                    }
                    this.runFrameDone(spectStreamSlot, spectFrame);
                    spectStreamSlot.freeFrame(spectFrame);
                    n2 = 0;
                    while (n2 < n && !this.threadDead) {
                        int n7 = n2;
                        for (int i = 0; i < n; ++i) {
                            block36: {
                                try {
                                    if (spectFrameArray[i] == null) break block36;
                                    int n8 = spectStreamArray[i].framesWriteable();
                                    if (n8 > 0) {
                                        spectStreamSlotArray[i].writeFrame(spectFrameArray[i]);
                                        ++n2;
                                        spectStreamArray[i].freeFrame(spectFrameArray[i]);
                                        spectFrameArray[i] = null;
                                        break block36;
                                    }
                                    if (n8 >= 0) break block36;
                                    ++n2;
                                    this.runFrameDone(spectStreamSlotArray[i], spectFrameArray[i]);
                                    spectStreamArray[i].freeFrame(spectFrameArray[i]);
                                    for (n4 = i + 1; n4 < n; ++n4) {
                                        spectStreamSlotArray[n4] = spectStreamSlotArray[n4 - 1];
                                        spectStreamArray[n4] = spectStreamArray[n4 - 1];
                                        spectFrameArray[n4] = spectFrameArray[n4 - 1];
                                        nArray[n4] = nArray[n4 - 1];
                                        nArray2[n4] = nArray2[n4 - 1];
                                        paramArray[n4] = paramArray[n4 - 1];
                                        fArray[n4] = fArray[n4 - 1];
                                        modulatorArray[n4] = modulatorArray[n4 - 1];
                                    }
                                    --n;
                                    --i;
                                }
                                catch (InterruptedException interruptedException) {
                                    break block15;
                                }
                            }
                            this.runCheckPause();
                        }
                        if (n7 != n2) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                for (n2 = 0; n2 < n; ++n2) {
                    spectStreamArray[n2].closeWriter();
                }
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (n != 0) {
            return null;
        }
        for (int i = 1; i <= 6; ++i) {
            stringBuffer.append("\nlbSlot " + i + ";pf" + 7 + ",id" + (i << 2) + ",pr" + this.pr.paraName[1 + i - 1]);
            stringBuffer2.append("\ncbSlot " + i + " Gain,actrue|" + ((i << 2) + 1) + "|en|" + ((i << 2) + 2) + "|en,acfalse|" + ((i << 2) + 1) + "|di|" + ((i << 2) + 2) + "|di,pr" + PRN_GAINMOD + i + ";pf" + 7 + ",id" + ((i << 2) + 1) + ",pr" + PRN_GAINMODDEPTH + i + ";en,id" + ((i << 2) + 2) + ",pr" + PRN_GAINMODENV + i);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbEach slot carries;ch,prChannels,itAll channels,itOne channel\ncbNormalize sum,actrue|100|en,acfalse|100|di,prNormalize;pf7,id100,prNormGain\nglOutput slot gain" + stringBuffer + "\ngl" + "Modulation" + stringBuffer2);
        return propertyGUI;
    }
}

