/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.MathUtil;
import de.sciss.util.Param;
import java.util.prefs.Preferences;

public class ConstQ {
    public static final String KEY_MINFREQ = "minfreq";
    public static final String KEY_MAXFREQ = "maxfreq";
    public static final String KEY_BANDSPEROCT = "bandsperoct";
    public static final String KEY_MAXTIMERES = "maxtimeres";
    public static final String KEY_MAXFFTSIZE = "maxfftsize";
    private Kernel[] kernels;
    private int numKernels;
    private int fftSize;
    private float[] fftBuf;
    private float minFreq = 55.0f;
    private float maxFreq = 20000.0f;
    private float maxTimeRes = 8.0f;
    private int bandsPerOct = 24;
    private int maxFFTSize = 4096;
    private double fs;

    public int getNumKernels() {
        return this.numKernels;
    }

    public int getFFTSize() {
        return this.fftSize;
    }

    public float[] getFFTBuffer() {
        return this.fftBuf;
    }

    public void setSampleRate(double d) {
        this.fs = d;
    }

    public double getSampleRate() {
        return this.fs;
    }

    public void setMinFreq(float f) {
        this.minFreq = f;
    }

    public float getMinFreq() {
        return this.minFreq;
    }

    public void setMaxFreq(float f) {
        this.maxFreq = f;
    }

    public float getMaxFreq() {
        return this.maxFreq;
    }

    public void setMaxTimeRes(float f) {
        this.maxTimeRes = f;
    }

    public float getMaxTimeRes() {
        return this.maxTimeRes;
    }

    public void setMaxFFTSize(int n) {
        this.maxFFTSize = n;
    }

    public float getMaxFFTSize() {
        return this.maxFFTSize;
    }

    public void setBandsPerOct(int n) {
        this.bandsPerOct = n;
    }

    public int getBandsPerOct() {
        return this.bandsPerOct;
    }

    public void readPrefs(Preferences preferences) {
        String string;
        Param param = Param.fromPrefs((Preferences)preferences, (String)KEY_MINFREQ, null);
        if (param != null) {
            this.minFreq = Math.max(1.0f, (float)param.val);
        }
        if ((param = Param.fromPrefs((Preferences)preferences, (String)KEY_MAXFREQ, null)) != null) {
            this.maxFreq = Math.max(this.minFreq, (float)param.val);
        }
        if ((param = Param.fromPrefs((Preferences)preferences, (String)KEY_BANDSPEROCT, null)) != null) {
            this.bandsPerOct = Math.max(1, (int)param.val);
        }
        if ((param = Param.fromPrefs((Preferences)preferences, (String)KEY_MAXTIMERES, null)) != null) {
            this.maxTimeRes = (float)param.val;
        }
        if ((string = preferences.get(KEY_MAXFFTSIZE, null)) != null) {
            try {
                int n = Integer.parseInt(string);
                this.maxFFTSize = 256;
                while (this.maxFFTSize < n) {
                    this.maxFFTSize <<= 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void writePrefs(Preferences preferences) {
        preferences.put(KEY_MINFREQ, new Param((double)this.minFreq, 83).toString());
        preferences.put(KEY_MAXFREQ, new Param((double)this.maxFreq, 83).toString());
        preferences.put(KEY_BANDSPEROCT, new Param((double)this.bandsPerOct, 0).toString());
        preferences.put(KEY_MAXTIMERES, new Param((double)this.maxTimeRes, 12322).toString());
        preferences.put(KEY_MAXFFTSIZE, String.valueOf(this.maxFFTSize));
    }

    public float getFrequency(int n) {
        return this.kernels[n].freq;
    }

    public void createKernels() {
        this.maxFreq = (float)Math.min((double)this.maxFreq, this.fs / 2.0);
        float f = (float)(1.0 / (Math.pow(2.0, 1.0 / (double)this.bandsPerOct) - 1.0));
        this.numKernels = (int)Math.ceil((double)this.bandsPerOct * MathUtil.log2(this.maxFreq / this.minFreq));
        this.kernels = new Kernel[this.numKernels];
        double d = (double)f * this.fs / (double)this.minFreq;
        this.fftSize = Math.min(this.maxFFTSize, MathUtil.nextPowerOfTwo((int)Math.ceil(d)));
        int n = this.fftSize << 1;
        this.fftBuf = new float[n];
        float f2 = 2.6244E-4f / (float)(this.fftSize * this.fftSize);
        for (int i = 0; i < this.numKernels; ++i) {
            int n2;
            float f3;
            float f4;
            int n3;
            int n4;
            double d2 = d * (double)((float)Math.pow(2.0, (double)(-i) / (double)this.bandsPerOct));
            int n5 = Math.min(this.fftSize, (int)Math.ceil(d2));
            int n6 = n5 & 0xFFFFFFFE;
            float[] fArray = Filter.createFullWindow(n5, 0);
            double d3 = (double)this.minFreq * Math.pow(2.0, (float)i / (float)this.bandsPerOct);
            double d4 = d3 * (Math.PI * -2) / this.fs;
            double d5 = 6.0 / ((d2 + (double)n5) * (double)this.fftSize);
            int n7 = n - n6;
            for (n4 = n6; n4 < n7; ++n4) {
                this.fftBuf[n4] = 0.0f;
            }
            n7 = n - n6;
            for (n4 = 0; n4 < n5; ++n4) {
                double d6 = d4 * (double)n4;
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                d6 = (double)fArray[n4] * d5;
                this.fftBuf[n7++] = (float)(d6 * d7);
                this.fftBuf[n7++] = (float)(d6 * d8);
                if (n7 != n) continue;
                n7 = 0;
            }
            Fourier.complexTransform(this.fftBuf, this.fftSize, 1);
            for (n3 = 0; n3 <= this.fftSize && !((f4 = this.fftBuf[n3]) * f4 + (f3 = this.fftBuf[n3 + 1]) * f3 > f2); n3 += 2) {
            }
            for (n2 = n3; n2 <= this.fftSize && !((f4 = this.fftBuf[n2]) * f4 + (f3 = this.fftBuf[n2 + 1]) * f3 <= f2); n2 += 2) {
            }
            this.kernels[i] = new Kernel(n3, new float[n2 - n3], (float)d3);
            System.arraycopy(this.fftBuf, n3, this.kernels[i].data, 0, n2 - n3);
        }
    }

    public float[] castToFloatArray(Object[] objectArray) {
        float[] fArray = new float[objectArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Number)objectArray[i]).floatValue();
        }
        return fArray;
    }

    public float getArrayElement(float[] fArray, int n) {
        return fArray[n];
    }

    public float[] convolve(float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[this.numKernels];
        }
        int n2 = 0;
        while (n2 < this.numKernels) {
            float[] fArray2 = this.kernels[n2].data;
            float f = 0.0f;
            float f2 = 0.0f;
            int n3 = this.kernels[n2].offset;
            for (int i = 0; i < fArray2.length; i += 2) {
                f += this.fftBuf[n3] * fArray2[i] - this.fftBuf[n3 + 1] * fArray2[i + 1];
                f2 += this.fftBuf[n3] * fArray2[i + 1] + this.fftBuf[n3 + 1] * fArray2[i];
                n3 += 2;
            }
            fArray[n] = f * f + f2 * f2;
            ++n2;
            ++n;
        }
        return fArray;
    }

    public float[] transform(float[] fArray, int n, int n2, float[] fArray2, int n3) {
        int n4;
        if (fArray2 == null) {
            fArray2 = new float[this.numKernels];
        }
        int n5 = this.fftSize >> 1;
        int n6 = Math.min(this.fftSize - n5, n2);
        System.arraycopy(fArray, n, this.fftBuf, n5, n6);
        for (n4 = n5 + n6; n4 < this.fftSize; ++n4) {
            this.fftBuf[n4] = 0.0f;
        }
        int n7 = Math.min(this.fftSize - n6, n2 - n6);
        System.arraycopy(fArray, n + n6, this.fftBuf, 0, n7);
        for (n4 = n7; n4 < n5; ++n4) {
            this.fftBuf[n4] = 0.0f;
        }
        Fourier.realTransform(this.fftBuf, this.fftSize, 1);
        return this.convolve(fArray2, n3);
    }

    private static class Kernel {
        protected final int offset;
        protected final float[] data;
        protected final float freq;

        protected Kernel(int n, float[] fArray, float f) {
            this.offset = n;
            this.data = fArray;
            this.freq = f;
        }
    }
}

