/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.spect;

public class Wavelet {
    public static final int COEFFS_DAUB4 = 0;
    public static final int COEFFS_DAUB6 = 1;
    public static final int COEFFS_DAUB8 = 2;
    public static final int COEFFS_DAUB10 = 3;
    public static final int COEFFS_DAUB12 = 4;
    public static final int COEFFS_DAUB14 = 5;
    public static final int COEFFS_DAUB16 = 6;
    public static final int COEFFS_DAUB18 = 7;
    public static final int COEFFS_DAUB20 = 8;
    public static final int COEFFS_MAX = 8;
    protected static final float daub4_c0 = 0.4829629f;
    protected static final float daub4_c1 = 0.8365163f;
    protected static final float daub4_c2 = 0.22414386f;
    protected static final float daub4_c3 = -0.12940952f;
    protected static final float[][] static_cc = new float[][]{{0.4829629f, 0.8365163f, 0.22414386f, -0.12940952f}, {0.33267054f, 0.8068915f, 0.4598775f, -0.13501102f, -0.08544128f, 0.035226293f}, {0.23037781f, 0.71484655f, 0.6308808f, -0.02798377f, -0.18703482f, 0.030841382f, 0.03288301f, -0.010597402f}, {0.1601024f, 0.60382926f, 0.72430855f, 0.13842815f, -0.2422949f, -0.03224487f, 0.0775715f, -0.00624149f, -0.012580752f, 0.0033357253f}, {0.11154074f, 0.4946239f, 0.7511339f, 0.31525034f, -0.2262647f, -0.12976687f, 0.097501606f, 0.027522866f, -0.03158204f, 5.538422E-4f, 0.0047772573f, -0.0010773011f}, {0.077852055f, 0.39653933f, 0.7291321f, 0.4697823f, -0.143906f, -0.22403619f, 0.07130922f, 0.08061261f, -0.038029935f, -0.016574541f, 0.0125509985f, 4.2957798E-4f, -0.0018016407f, 3.537138E-4f}, {0.05441584f, 0.3128716f, 0.67563075f, 0.5853547f, -0.015829105f, -0.28401554f, 4.7248456E-4f, 0.12874743f, -0.0173693f, -0.044088256f, 0.0139810275f, 0.008746094f, -0.004870353f, -3.9174038E-4f, 6.754494E-4f, -1.1747678E-4f}, {0.038077947f, 0.24383467f, 0.6048231f, 0.6572881f, 0.13319738f, -0.29327378f, -0.096840784f, 0.14854075f, 0.030725682f, -0.06763283f, 2.509471E-4f, 0.022361662f, -0.0047232048f, -0.0042815036f, 0.0018476469f, 2.3038576E-4f, -2.5196318E-4f, 3.934732E-5f}, {0.026670057f, 0.1881768f, 0.5272012f, 0.68845904f, 0.28117234f, -0.24984643f, -0.19594628f, 0.12736934f, 0.093057364f, -0.071394145f, -0.029457537f, 0.033212673f, 0.0036065537f, -0.010733175f, 0.0013953517f, 0.0019924054f, -6.858567E-4f, -1.1646686E-4f, 9.358867E-5f, -1.3264203E-5f}};
    protected static final String[] filterNames = new String[]{"Daubechies  4", "Daubechies  6", "Daubechies  8", "Daubechies 10", "Daubechies 12", "Daubechies 14", "Daubechies 16", "Daubechies 18", "Daubechies 20"};

    public static void fwdTransformDaub4(float[] fArray, int n) {
        float[] fArray2 = new float[n >> 1];
        for (int i = n; i >= 4; i >>= 1) {
            int n2 = (i >> 1) - 1;
            float f = fArray[0];
            float f2 = fArray[1];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                fArray2[n3] = -0.12940952f * fArray[n4] - 0.22414386f * fArray[n4 + 1] + 0.8365163f * fArray[n4 + 2] - 0.4829629f * fArray[n4 + 3];
                fArray[n3++] = 0.4829629f * fArray[n4++] + 0.8365163f * fArray[n4++] + 0.22414386f * fArray[n4] + -0.12940952f * fArray[n4 + 1];
            }
            fArray[n2] = 0.4829629f * fArray[i - 2] + 0.8365163f * fArray[i - 1] + 0.22414386f * f + -0.12940952f * f2;
            fArray[i - 1] = -0.12940952f * fArray[i - 2] - 0.22414386f * fArray[i - 1] + 0.8365163f * f - 0.4829629f * f2;
            --n3;
            while (n3 >= 0) {
                fArray[n4--] = fArray2[n3--];
            }
        }
    }

    public static void invTransformDaub4(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        for (int i = 4; i <= n; i <<= 1) {
            int n2;
            int n3 = i >> 1;
            int n4 = i;
            for (n2 = n3 - 2; n2 >= 0; --n2) {
                fArray2[--n4] = -0.12940952f * fArray[n2] - 0.4829629f * fArray[n2 + n3] + 0.8365163f * fArray[n2 + 1] - 0.22414386f * fArray[n2 + n3 + 1];
                fArray2[--n4] = 0.22414386f * fArray[n2] + 0.8365163f * fArray[n2 + n3] + 0.4829629f * fArray[n2 + 1] + -0.12940952f * fArray[n2 + n3 + 1];
            }
            fArray2[1] = -0.12940952f * fArray[n3 - 1] - 0.4829629f * fArray[i - 1] + 0.8365163f * fArray[0] - 0.22414386f * fArray[n3];
            fArray[0] = 0.22414386f * fArray[n3 - 1] + 0.8365163f * fArray[i - 1] + 0.4829629f * fArray[0] + -0.12940952f * fArray[n3];
            for (n2 = 1; n2 < i; ++n2) {
                fArray[n2] = fArray2[n2];
            }
        }
    }

    public static float[][] getCoeffs(int n) {
        Object object = null;
        if (n >= 0 && n <= 8) {
            float[] fArray = static_cc[n];
            int n2 = fArray.length;
            float[] fArray2 = new float[n2];
            object = new float[2][];
            float[] fArray3 = new float[n2];
            object[0] = fArray2;
            object[1] = fArray3;
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                fArray2[i] = fArray[i];
                fArray3[n2 - i - 1] = (float)n3 * fArray2[i];
                n3 = -n3;
            }
        }
        return object;
    }

    public static String[] getFilterNames() {
        return filterNames;
    }

    public static int getCoeffsID(String string) {
        for (int i = 0; i < filterNames.length; ++i) {
            if (!filterNames[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public static void fwdTransform(float[] fArray, int n, float[][] fArray2) {
        float[] fArray3 = new float[n];
        float[] fArray4 = fArray2[0];
        float[] fArray5 = fArray2[1];
        float f = fArray4[0];
        float f2 = fArray5[0];
        int n2 = fArray4.length;
        for (int i = n; i >= 4; i >>= 1) {
            int n3 = n2 * i;
            int n4 = i - 1;
            int n5 = i >> 1;
            int n6 = -(n2 - 1 >> 1) + n3;
            int n7 = 0;
            int n8 = n6;
            while (n7 < n5) {
                int n9 = n8 & n4;
                float f3 = f * fArray[n9];
                float f4 = f2 * fArray[n9];
                for (int j = 1; j < n2; ++j) {
                    n9 = n8 + j & n4;
                    f3 += fArray4[j] * fArray[n9];
                    f4 += fArray5[j] * fArray[n9];
                }
                fArray3[n7] = f3;
                fArray3[n7 + n5] = f4;
                ++n7;
                n8 += 2;
            }
            System.arraycopy(fArray3, 0, fArray, 0, i);
        }
    }

    public static void fwdTransform(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, float[][] fArray4) {
        float[] fArray5 = fArray4[0];
        float[] fArray6 = fArray4[1];
        float f = fArray5[0];
        float f2 = fArray6[0];
        int n3 = fArray5.length;
        int n4 = n2 >> 1;
        int n5 = -(n3 - 1 >> 1) + n;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n5;
            float f3 = f * fArray[n7];
            float f4 = f2 * fArray[n7++];
            for (int i = 1; i < n3; ++i) {
                f3 += fArray5[i] * fArray[n7];
                f4 += fArray6[i] * fArray[n7++];
            }
            fArray2[n6] = f3;
            fArray3[n6] = f4;
            ++n6;
            n5 += 2;
        }
    }

    public static void invTransform(float[] fArray, int n, float[][] fArray2) {
        float[] fArray3 = new float[n];
        float[] fArray4 = fArray2[0];
        float[] fArray5 = fArray2[1];
        int n2 = fArray4.length;
        for (int i = 4; i <= n; i <<= 1) {
            int n3;
            int n4 = n2 * i;
            int n5 = i - 1;
            int n6 = i >> 1;
            int n7 = -(n2 - 1 >> 1) + n4;
            for (n3 = 0; n3 < i; ++n3) {
                fArray3[n3] = 0.0f;
            }
            n3 = 0;
            int n8 = n7;
            while (n3 < n6) {
                float f = fArray[n3];
                float f2 = fArray[n3 + n6];
                for (int j = 0; j < n2; ++j) {
                    int n9;
                    int n10 = n9 = n8 + j & n5;
                    fArray3[n10] = fArray3[n10] + (fArray4[j] * f + fArray5[j] * f2);
                }
                ++n3;
                n8 += 2;
            }
            System.arraycopy(fArray3, 0, fArray, 0, i);
        }
    }

    public static void invTransform(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, float[][] fArray4) {
        float[] fArray5 = fArray4[0];
        float[] fArray6 = fArray4[1];
        int n3 = fArray5.length;
        int n4 = n3 - 1 >> 1;
        int n5 = n4 & 1;
        for (int i = 0; i < n2; ++i) {
            fArray[i] = 0.0f;
            int n6 = n5;
            int n7 = (i - n6 + n4 >> 1) + n;
            while (n6 < n3) {
                int n8 = i;
                fArray[n8] = fArray[n8] + (fArray5[n6] * fArray2[n7] + fArray6[n6] * fArray3[n7]);
                n6 += 2;
                --n7;
            }
            n5 = 1 - n5;
        }
    }
}

