/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

public class Filter {
    public static final int FLTSMPPERCROSSING = 256;
    public static final int WIN_HAMMING = 0;
    public static final int WIN_BLACKMAN = 1;
    public static final int WIN_KAISER4 = 2;
    public static final int WIN_KAISER5 = 3;
    public static final int WIN_KAISER6 = 4;
    public static final int WIN_KAISER8 = 5;
    public static final int WIN_RECT = 6;
    public static final int WIN_HANNING = 7;
    public static final int WIN_TRI = 8;
    public static final int WIN_MAX = 8;
    protected static final String[] windowNames = new String[]{"Hamming", "Blackman", "Kaiser \u03b2=4", "Kaiser \u03b2=5", "Kaiser \u03b2=6", "Kaiser \u03b2=8", "Rectangle", "von Hann", "Triangle"};
    protected static final float[] dBAweight = new float[]{0.0f, 1.0E-7f, 2.512E-7f, 6.31E-7f, 1.567E-6f, 3.89E-6f, 9.661E-6f, 2.371E-5f, 5.37E-5f, 1.365E-4f, 3.162E-4f, 7.161E-4f, 0.001531f, 0.003126f, 0.006026f, 0.01096f, 0.01905f, 0.0309f, 0.04955f, 0.07586f, 0.1109f, 0.1585f, 0.2163f, 0.2884f, 0.3715f, 0.4677f, 0.5754f, 0.6918f, 0.8035f, 0.912f, 1.0f, 1.072f, 1.122f, 1.148f, 1.161f, 1.148f, 1.122f, 1.059f, 0.9886f, 0.881f, 0.7499f, 0.6095f, 0.4677f, 0.3428f, 0.2399f, 0.0f};

    public static void getDBAweights(float[] fArray, float[] fArray2, int n) {
        for (int i = 0; i < n; ++i) {
            float f = fArray2[i];
            if (f < 1.0f) {
                fArray[i] = dBAweight[0];
                continue;
            }
            if (f > 31622.7f) {
                fArray[i] = dBAweight[dBAweight.length - 1];
                continue;
            }
            float f2 = (float)(10.0 * Math.log(f) / 2.302585092994046);
            int n2 = (int)f2;
            fArray[i] = dBAweight[n2] * (1.0f - (f2 %= 1.0f)) + dBAweight[n2 + 1] * f2;
        }
    }

    public static void createLPF(float[] fArray, float f, int n, float f2, int n2) {
        double d;
        int n3;
        double d2 = n2;
        double d3 = f2;
        double d4 = (double)f * 2.0;
        double d5 = 1.0 / (double)(n - 1);
        fArray[0] = (float)d4;
        for (n3 = 1; n3 < n; ++n3) {
            d = Math.PI * (double)n3 / d2;
            fArray[n3] = (float)(Math.sin(d4 * d) / d);
        }
        double d6 = 1.0 / Filter.calcBesselZero(d3);
        n3 = 1;
        while (n3 < n) {
            d = (double)n3 * d5;
            int n4 = n3++;
            fArray[n4] = (float)((double)fArray[n4] * (Filter.calcBesselZero(d3 * Math.sqrt(1.0 - d * d)) * d6));
        }
    }

    public static float createAntiAliasFilter(float[] fArray, float[] fArray2, int n, float f, float f2) {
        return Filter.createAntiAliasFilter(fArray, fArray2, n, 256, f, f2);
    }

    public static float createAntiAliasFilter(float[] fArray, float[] fArray2, int n, int n2, float f, float f2) {
        int n3;
        float f3 = 0.0f;
        Filter.createLPF(fArray, 0.5f * f, n, f2, n2);
        if (fArray2 != null) {
            for (n3 = 0; n3 < n - 1; ++n3) {
                fArray2[n3] = fArray[n3 + 1] - fArray[n3];
            }
            fArray2[n3] = -fArray[n3];
        }
        for (n3 = n2; n3 < n; n3 += n2) {
            f3 += fArray[n3];
        }
        f3 = 2.0f * f3 + fArray[0];
        return 1.0f / Math.abs(f3);
    }

    public static float[] createKaiserWindow(int n, float f) {
        float[] fArray = new float[n];
        double d = f;
        double d2 = 1.0 / (double)(n - 1);
        double d3 = 1.0 / Filter.calcBesselZero(d);
        fArray[0] = 1.0f;
        for (int i = 1; i < n; ++i) {
            double d4 = (double)i * d2;
            fArray[i] = (float)(Filter.calcBesselZero(d * Math.sqrt(1.0 - d4 * d4)) * d3);
        }
        return fArray;
    }

    public static float[] createFullKaiserWindow(int n, float f) {
        float[] fArray = new float[n];
        int n2 = n >> 1;
        double d = f;
        double d2 = 1.0 / (double)n2;
        double d3 = 1.0 / Filter.calcBesselZero(d);
        int n3 = 0;
        int n4 = -n2;
        while (n3 < n) {
            double d4 = (double)n4 * d2;
            fArray[n3] = (float)(Filter.calcBesselZero(d * Math.sqrt(1.0 - d4 * d4)) * d3);
            ++n3;
            ++n4;
        }
        return fArray;
    }

    public static float[] createWindow(int n, int n2) {
        float[] fArray = new float[n];
        double d = Math.PI / (double)(n - 1);
        switch (n2) {
            case 1: {
                for (int i = 0; i < n; ++i) {
                    double d2 = (double)i * d;
                    fArray[i] = (float)(0.42 + 0.5 * Math.cos(d2) + 0.08 * Math.cos(2.0 * d2));
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n; ++i) {
                    double d3 = (double)i * d;
                    fArray[i] = (float)(0.5 + 0.5 * Math.cos(d3));
                }
                break;
            }
            case 2: {
                return Filter.createKaiserWindow(n, 4.0f);
            }
            case 3: {
                return Filter.createKaiserWindow(n, 5.0f);
            }
            case 4: {
                return Filter.createKaiserWindow(n, 6.0f);
            }
            case 5: {
                return Filter.createKaiserWindow(n, 8.0f);
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = 1.0f;
                }
                break;
            }
            case 8: {
                float f = 1.0f / (float)(n - 1);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = (float)(n - 1 - i) * f;
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    double d4 = (double)i * d;
                    fArray[i] = (float)(0.54 + 0.46 * Math.cos(d4));
                }
            }
        }
        return fArray;
    }

    public static float[] createFullWindow(int n, int n2) {
        float[] fArray = new float[n];
        int n3 = n >> 1;
        double d = Math.PI / (double)n3;
        switch (n2) {
            case 1: {
                int n4 = 0;
                int n5 = -n3;
                while (n4 < n) {
                    double d2 = (double)n5 * d;
                    fArray[n4] = (float)(0.42 + 0.5 * Math.cos(d2) + 0.08 * Math.cos(2.0 * d2));
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 7: {
                int n6 = 0;
                int n7 = -n3;
                while (n6 < n) {
                    double d3 = (double)n7 * d;
                    fArray[n6] = (float)(0.5 + 0.5 * Math.cos(d3));
                    ++n6;
                    ++n7;
                }
                break;
            }
            case 2: {
                return Filter.createFullKaiserWindow(n, 4.0f);
            }
            case 3: {
                return Filter.createFullKaiserWindow(n, 5.0f);
            }
            case 4: {
                return Filter.createFullKaiserWindow(n, 6.0f);
            }
            case 5: {
                return Filter.createFullKaiserWindow(n, 8.0f);
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = 1.0f;
                }
                break;
            }
            case 8: {
                int n8;
                float f = 1.0f / (float)n3;
                for (n8 = 0; n8 <= n3; ++n8) {
                    fArray[n8] = (float)n8 * f;
                }
                int n9 = n8;
                while (n8 < n) {
                    fArray[n8++] = fArray[--n9];
                }
                break;
            }
            default: {
                int n10 = 0;
                int n11 = -n3;
                while (n10 < n) {
                    double d4 = (double)n11 * d;
                    fArray[n10] = (float)(0.54 + 0.46 * Math.cos(d4));
                    ++n10;
                    ++n11;
                }
                break block0;
            }
        }
        return fArray;
    }

    public static String[] getWindowNames() {
        return windowNames;
    }

    public static int getWindowType(String string) {
        for (int i = 0; i < windowNames.length; ++i) {
            if (!windowNames[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public static void resample(float[] fArray, double d, float[] fArray2, int n, int n2, double d2, int n3) {
        int n4;
        float f;
        float f2;
        int n5 = 4096;
        switch (n3) {
            case 0: {
                f2 = 0.7f;
                f = 6.5f;
                n4 = 5;
                break;
            }
            case 1: {
                f2 = 0.8f;
                f = 7.0f;
                n4 = 9;
                break;
            }
            default: {
                f2 = 0.86f;
                f = 7.5f;
                n4 = 15;
            }
        }
        int n6 = (int)((float)(n5 * n4) / f2 + 0.5f);
        float[] fArray3 = new float[n6];
        float[] fArray4 = null;
        float f3 = Filter.createAntiAliasFilter(fArray3, fArray4, n6, n5, f2, f);
        float[][] fArrayArray = new float[4][];
        fArrayArray[0] = fArray3;
        fArrayArray[1] = fArray4;
        fArrayArray[2] = new float[2];
        fArrayArray[2][0] = n5;
        fArrayArray[2][1] = f3;
        Filter.resample(fArray, d, fArray2, n, n2, d2, fArrayArray);
    }

    public static void resample(float[] fArray, double d, float[] fArray2, int n, int n2, double d2, float[][] fArray3) {
        double d3;
        double d4;
        double d5 = 1.0 / d2;
        double d6 = d;
        float[] fArray4 = fArray3[0];
        float[] fArray5 = fArray3[1];
        float f = fArray3[2][0];
        double d7 = fArray3[2][1];
        int n3 = fArray4.length;
        int n4 = fArray.length;
        if (d5 > 1.0) {
            d4 = (double)f * d2;
            d3 = d7;
        } else {
            d4 = f;
            d3 = d7 * d5;
        }
        if (fArray5 == null) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                double d8 = d6 % 1.0;
                double d9 = 0.0;
                double d10 = d8 * d4 + 0.5;
                int n7 = (int)d10;
                for (n6 = (int)d6; n7 < n3 && n6 >= 0; --n6) {
                    d9 += (double)fArray[n6] * (double)fArray4[n7];
                    n7 = (int)(d10 += d4);
                }
                d10 = (1.0 - d8) * d4;
                n7 = (int)d10;
                for (n6 = (int)d6 + 1; n7 < n3 && n6 < n4; ++n6) {
                    d9 += (double)fArray[n6] * (double)fArray4[n7];
                    n7 = (int)(d10 += d4);
                }
                fArray2[n++] = (float)(d9 * d3);
                d6 = d + (double)(++n5) * d5;
            }
        } else {
            int n8 = 0;
            while (n8 < n2) {
                double d11;
                int n9;
                double d12 = d6 % 1.0;
                double d13 = 0.0;
                double d14 = d12 * d4;
                int n10 = (int)d14;
                for (n9 = (int)d6; n10 < n3 && n9 >= 0; --n9) {
                    d11 = d14 % 1.0;
                    d13 += (double)fArray[n9] * ((double)fArray4[n10] + (double)fArray5[n10] * d11);
                    n10 = (int)(d14 += d4);
                }
                d14 = (1.0 - d12) * d4;
                n10 = (int)d14;
                for (n9 = (int)d6 + 1; n10 < n3 && n9 < n4; ++n9) {
                    d11 = d14 % 1.0;
                    d13 += (double)fArray[n9] * ((double)fArray4[n10] + (double)fArray5[n10] * d11);
                    n10 = (int)(d14 += d4);
                }
                fArray2[n++] = (float)(d13 * d3);
                d6 = d + (double)(++n8) * d5;
            }
        }
    }

    public static double calcEnergy(float[] fArray, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        int n4 = n3 + n2;
        while (n3 < n4) {
            d += (double)(fArray[n3] * fArray[n3++]);
        }
        return d;
    }

    protected static double calcBesselZero(double d) {
        double d2;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = 1;
        d /= 2.0;
        do {
            d2 = d / (double)n;
            ++n;
        } while ((d3 *= d2 * d2) >= (d4 += d3) * 1.0E-21);
        return d4;
    }
}

