/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.util.NumberSpace;

public class ParamSpace
extends NumberSpace {
    public double inc;
    public int unit;

    public ParamSpace() {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1);
        this.inc = 0.1;
        this.unit = 0;
    }

    public ParamSpace(double d, double d2, double d3, int n) {
        super(d, d2, d3);
        this.inc = d3;
        this.unit = n;
    }

    public ParamSpace(ParamSpace paramSpace) {
        super(paramSpace.min, paramSpace.max, paramSpace.quant);
        this.inc = paramSpace.inc;
        this.unit = paramSpace.unit;
    }

    public boolean contains(double d) {
        return d + 1.0E-6 >= this.min && d - 1.0E-6 <= this.max;
    }

    public boolean contains(ParamSpace paramSpace) {
        return this.unit == paramSpace.unit && this.min <= paramSpace.min && this.max >= paramSpace.max && paramSpace.inc / this.inc - Math.floor(paramSpace.inc / this.inc) < 1.0E-6;
    }

    public double fitValue(double d) {
        d = (double)Math.round(d / this.inc) * this.inc;
        d = Math.max(this.min, Math.min(this.max, d));
        return d;
    }

    public String toString() {
        return "" + this.min + ',' + this.max + ',' + this.inc + ',' + this.unit;
    }

    public static ParamSpace valueOf(String string) {
        int n = string.indexOf(44);
        int n2 = string.indexOf(44, n + 1);
        int n3 = string.indexOf(44, n2 + 1);
        return new ParamSpace(Double.valueOf(string.substring(0, n)), Double.valueOf(string.substring(n + 1, n2)), Double.valueOf(string.substring(n2 + 1, n3)), Integer.parseInt(string.substring(n3 + 1)));
    }
}

